package org.gcube.portlets.user.occurrencemanagement.client.view.panel.data;


import org.gcube.portlets.user.occurrencemanagement.client.ConstantsPortletOccurrence;
import org.gcube.portlets.user.occurrencemanagement.client.dialog.CsvImport;
import org.gcube.portlets.user.occurrencemanagement.client.dialog.MessageBoxConfirm;
import org.gcube.portlets.user.occurrencemanagement.client.job.JobManager;
import org.gcube.portlets.user.occurrencemanagement.client.job.WindowInfoJobsSpecies;
import org.gcube.portlets.user.occurrencemanagement.client.resources.Resources;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;

import com.extjs.gxt.ui.client.Style.ButtonScale;
import com.extjs.gxt.ui.client.Style.SortDir;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.ui.AbstractImagePrototype;



public class OccurrencesLoadingPanel extends ContentPanel{
	
	private ToolBar toolbar;
	private Grid<BaseModelData> grid;
	private Button buttonLoad = new Button("Import");
	private final static String INFO = "Info";
	private static final String CANCEL = "Cancel";
	private static final String REFRESH = "Refresh";
	private Button buttonInfo = new Button(INFO);
	private Button buttonCancel =  new Button(CANCEL);
	private JobManager jobManager;
	private Button buttonRefresh;
	
	public OccurrencesLoadingPanel(final JobManager jobManager) {
		setLayout(new FitLayout());	
		setBodyBorder(false);
		
		setHeaderVisible(true);
		setHeading("Loading");
		
		this.jobManager = jobManager;
		
		this.grid = jobManager.getGridJob().getGrid();
		
		this.grid.getStore().sort(JobOccurrencesModel.ENDTIME, SortDir.ASC);
		
		this.grid.getSelectionModel().addSelectionChangedListener(new SelectionChangedListener<BaseModelData>() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent<BaseModelData> se) {
				System.out.println("selection grid change");
				
				ModelData target = se.getSelectedItem();
				
				if(target!=null)
					enableButtonOnClick(true);
				else
					enableButtonOnClick(false);
				
			}
		});
		
		addListener(Events.Expand, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				jobManager.getGridJob().updateProgressSize();
			}
		});
		
		createGridToolBar();
		createMenuItemsOnGrid();
		
		this.add(jobManager.getGridJob());
		
		
	}
	
	private void createGridToolBar(){
		
		this.toolbar = new ToolBar();
		
		buttonLoad.setScale(ButtonScale.MEDIUM);
//		buttonInfo.setIconAlign(IconAlign.LEFT);
//		buttonInfo.setArrowAlign(ButtonArrowAlign.RIGHT);
		buttonLoad.setIcon(AbstractImagePrototype.create(Resources.getImageUpload()));
		buttonLoad.setStyleAttribute("margin-left", "5px");
		buttonLoad.addSelectionListener(new SelectionListener<ButtonEvent>() {
			
			@Override
			public void componentSelected(ButtonEvent ce) {

//				ImportOccurrencesFileWindow importOccurrences = new ImportOccurrencesFileWindow();
//				importOccurrences.show();
				
				CsvImport cswImport = new CsvImport();
			}
		});
		


		buttonInfo.setScale(ButtonScale.MEDIUM);
//		buttonInfo.setIconAlign(IconAlign.LEFT);
//		buttonInfo.setArrowAlign(ButtonArrowAlign.RIGHT);
		buttonInfo.setIcon(AbstractImagePrototype.create(Resources.getImageInfo()));
		buttonInfo.setStyleAttribute("margin-left", "5px");
		buttonInfo.addSelectionListener(new SelectionListener<ButtonEvent>() {
			
			@Override
			public void componentSelected(ButtonEvent ce) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				info(jobModel);
			}
		});
		
		buttonCancel.setScale(ButtonScale.MEDIUM);
		buttonCancel.setIcon(AbstractImagePrototype.create(Resources.getImageDelete()));
		
		buttonCancel.addListener(Events.OnClick, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				cancel(jobModel);

			}
	
		});
		
		buttonRefresh =  new Button(REFRESH);
		buttonRefresh.setScale(ButtonScale.MEDIUM);
		buttonRefresh.setIcon(Resources.getIconRefresh());
		
		buttonRefresh.addListener(Events.OnClick, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				
				refresh();
	
			}

		});

		toolbar.add(buttonLoad);
		toolbar.add(new SeparatorToolItem());
		
		toolbar.add(buttonInfo);
		toolbar.add(new SeparatorToolItem());
		
		toolbar.add(buttonCancel);
		toolbar.add(new SeparatorToolItem());
		
		toolbar.add(buttonRefresh);
		toolbar.add(new SeparatorToolItem());
		
		setTopComponent(toolbar);
		
		enableButtonOnClick(false);
	}
	
	
	public void createMenuItemsOnGrid(){
		
		Menu menu = new Menu();
		
		MenuItem menuInfo = new MenuItem(); 
		menuInfo.setId(INFO);
		menuInfo.setText(INFO);  
		menuInfo.setIcon(AbstractImagePrototype.create(Resources.getImageInfo()));
		
		menuInfo.addSelectionListener(new SelectionListener<MenuEvent>() {

			@Override
			public void componentSelected(MenuEvent ce) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				info(jobModel);
			}

		});

		menu.add(menuInfo);
			
		MenuItem menuCancel= new MenuItem(); 
		menuCancel.setId(CANCEL);
		menuCancel.setText(CANCEL);  
		menuCancel.setIcon(AbstractImagePrototype.create(Resources.getImageDelete()));
		
		menuCancel.addSelectionListener(new SelectionListener<MenuEvent>() {
			
			@Override
			public void componentSelected(MenuEvent ce) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				cancel(jobModel);
			}

		});

		menu.add(menuCancel);
		
		grid.setContextMenu(menu);
	
	}
	
	
	private void cancel(final BaseModelData jobModel){
		
		if(jobModel!=null){
			
			String name = jobModel.get(JobOccurrencesModel.JOBNAME);
			
			MessageBoxConfirm mbc = new MessageBoxConfirm("Confirm delete", ConstantsPortletOccurrence.MESSAGE_CONFIRM_DELETE  + " "+ name+"?");
			mbc.getMessageBoxConfirm().addCallback(new Listener<MessageBoxEvent>() {
		          
			public void handleEvent(MessageBoxEvent be) {
				
				//IF CANCELLED
				String clickedButton = be.getButtonClicked().getItemId();
				if(clickedButton.equals(Dialog.YES)){
					
					final String jobIdentifier = jobModel.get(JobOccurrencesModel.JOBINDENTIFIER);

				}
			}	
			});
		}
		
	}
	
	private void info(BaseModelData jobModel){
		
		if(jobModel!=null){
			
			String id = jobModel.get(JobOccurrencesModel.JOBINDENTIFIER);
			WindowInfoJobsSpecies win = jobManager.getGridJob().getListWindowInfo().get(id);
			win.show();
		}
	}
	
	public void enableButtonOnClick(boolean bool){
		this.buttonCancel.setEnabled(bool);
		this.buttonInfo.setEnabled(bool);
	}
	
	public JobManager getJobManager(){
		return jobManager;
	}
	
	private void refresh() {
		this.jobManager.reset();
//		AppController.getEventBus().fireEvent(new ReLoadListOccurrencesEvent(ElaborationType.OCCURRENCESIMPORTING));
	}

}
