package org.gcube.portlets.user.occurrencemanagement.server.csv;

import java.io.File;

import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.harmonization.occurrence.OccurrenceStreamer;
import org.gcube.data.harmonization.occurrence.impl.readers.StreamProgress;
import org.gcube.portlets.user.csvimportwizard.client.progress.OperationProgress;
import org.gcube.portlets.user.csvimportwizard.server.csv.CSVParserConfiguration;
import org.gcube.portlets.user.csvimportwizard.server.csv.CSVTarget;
import org.gcube.portlets.user.occurrencemanagement.server.service.ReconciliationService;
import org.gcube.portlets.user.occurrencemanagement.server.util.SessionUtil;

public class CsvImportServer implements CSVTarget {
	public static Logger logger = Logger.getLogger(CsvImportServer.class);
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getId() {
		return "OccurrenceCSVTarget";
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void importCSV(HttpSession httpSession, File csvFile,String fileName, CSVParserConfiguration parserConfiguration, boolean[] columnToImportMask, final OperationProgress operationProgress) {
		
		logger.trace("ImportCSV...");
		System.out.println("ImportCSV...");
		
		org.gcube.data.harmonization.occurrence.impl.readers.CSVParserConfiguration  serverCsvConfiguration = CsvConfigurationReconciliationService.convertParserCofiguration(parserConfiguration, columnToImportMask);
		
		try {
			
			ASLSession aslSession = SessionUtil.getAslSession(httpSession);
			
			ReconciliationService reconciliationService = SessionUtil.getService(aslSession);
			
			final OccurrenceStreamer streamer = reconciliationService.importOccurrences(csvFile, serverCsvConfiguration, fileName, ""); //TODO filedescription
			
			streamer.streamData();
			
			final StreamProgress progress = streamer.getProgress();
			
			Thread th = new Thread(new Runnable() {
				
				@Override
				public void run() {
					operationProgress.setTotalLenght(progress.getTotalLenght());
//					operationProgress.setTotalLenght(progress.getTotalLenght()); //TODO???
					operationProgress.setState(org.gcube.portlets.user.csvimportwizard.client.progress.OperationState.INPROGRESS);
					
					while(operationProgress.getState().equals(org.gcube.portlets.user.csvimportwizard.client.progress.OperationState.INPROGRESS)){
						
						try {
							Thread.sleep(1000);
						} catch (InterruptedException e) {
							logger.error("ImportCSV - Thread.sleep " + e);
						}
						operationProgress.setElaboratedLenght(progress.getElaboratedLenght());
						operationProgress.setState(CsvConfigurationReconciliationService.convertState(progress.getState()));
						
						logger.trace("ImportCSV during in Progress- state: "+operationProgress.getState());
						logger.trace("ImportCSV - during in Progress - elaboratedLenght: "+operationProgress.getElaboratedLenght());
						
						//FOR DEBUG
						System.out.println("ImportCSV during in Progress- state: "+operationProgress.getState());
						System.out.println("ImportCSV - during in Progress - elaboratedLenght: "+operationProgress.getElaboratedLenght());
					}
					
					//UPDATE STATE FAILED OR COMPLETED
					operationProgress.setElaboratedLenght(progress.getElaboratedLenght());
					operationProgress.setState(CsvConfigurationReconciliationService.convertState(progress.getState()));
					
					
					//UPDATE FAILED REASON
					if(progress.getState().equals(org.gcube.portlets.user.csvimportwizard.client.progress.OperationState.FAILED)){
						
						operationProgress.setFailed(progress.getFailureReason(), progress.getFailureDetails());
						
						logger.trace("failed(): "+progress.getFailureReason() + " " + progress.getFailureDetails());
					}
					
					logger.trace("Exit in Progress - totalLenght: "+operationProgress.getTotalLenght());
					logger.trace("Exit in Progress - state: "+operationProgress.getState());
					logger.trace("Exit in Progress - elaboratedLenght: "+operationProgress.getElaboratedLenght());
					
					
					//FOR DEBUG
					System.out.println("ImportCSV - totalLenght: "+operationProgress.getTotalLenght());
					System.out.println("ImportCSV - state: "+operationProgress.getState());
					System.out.println("ImportCSV - elaboratedLenght: "+operationProgress.getElaboratedLenght());
					
					}
			});
			
			th.start();

			
		} catch (Exception e) {
			logger.error("Error in import CSV, "+e);
		}
		
	}
}