package org.gcube.portlets.user.occurrencemanagement.shared;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class ComputationModel implements Serializable {

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private String id;
	private String name;
	private String algorithm;
	private String description;
	private String category;
	private Map<String, String> parametersMap;

	private ElaborationType type;

	private Date startTime;

	private Date endTime;

	public ComputationModel(){
	}

	/**
	 * 
	 * @param id
	 * @param name
	 * @param algorithm
	 * @param description
	 * @param category
	 * @param elaborationType 
	 * @param paramteresMap
	 */
	public ComputationModel(String id, String name, String algorithm, String description, String category, Map<String, String> parametersMap, ElaborationType elaborationType, Date start, Date end) {
		this.id = id;
		this.name = name;
		this.algorithm = algorithm;
		this.description = description;
		this.category = category;
		this.parametersMap = parametersMap;
		
		this.startTime = start;
		this.endTime = end;
		
		this.type = elaborationType;
		
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getAlgorithm() {
		return algorithm;
	}

	public void setAlgorithm(String algorithm) {
		this.algorithm = algorithm;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public Map<String, String> getParametersMap() {
		return parametersMap;
	}

	public ElaborationType getType() {
		return type;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

}
