/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.questions.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.questions.client.resources.Images;
import org.gcube.portlets.user.questions.client.ui.DisplayBadge;

public class DisplayBadge
extends Composite {
    private static DisplayBadgeUiBinder uiBinder = (DisplayBadgeUiBinder)GWT.create(DisplayBadgeUiBinder.class);
    @UiField
    HTMLPanel mainPanel;
    @UiField
    Image avatarImage;
    @UiField
    HTML userFullName;
    @UiField
    HTML headlineLabel;
    @UiField
    HTML institutionLabel;
    @UiField
    AnchorElement imageRedirect;
    private UserInfo myUserInfo;

    public DisplayBadge(UserInfo user) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        String profileURL = "";
        String location = Window.Location.getHref();
        profileURL = location.split("/").length == 5 ? location + "/" + user.getAccountURL() : user.getAccountURL();
        Images images = (Images)GWT.create(Images.class);
        this.avatarImage.setUrl(images.avatarLoader().getSafeUri());
        this.mainPanel.addStyleName("profile-section");
        this.myUserInfo = user;
        this.avatarImage.getElement().getParentElement().setAttribute("href", this.myUserInfo.getAvatarId());
        if (this.myUserInfo.getAvatarId() == null) {
            this.avatarImage.setUrl(images.avatarDefaultImage().getSafeUri());
        } else {
            this.avatarImage.setUrl(this.myUserInfo.getAvatarId());
        }
        this.userFullName.setHTML("<a class=\"manager-person-link\" href=\"" + profileURL + "\">" + this.myUserInfo.getFullName() + "</a>");
        this.headlineLabel.setText(user.getEmailaddress());
        this.imageRedirect.setHref(profileURL);
        String title = "See profile of " + this.myUserInfo.getFullName();
        this.avatarImage.setTitle(title);
        this.userFullName.setTitle(title);
    }
}

