/**
 * 
 */
package org.gcube.portlets.user.shareupdates.client.form;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.TextArea;

/**
 * @author massi
 *
 */
public class MyTextArea extends TextArea {

	/**
	 * 
	 */
	public MyTextArea() {
		sinkEvents(Event.ONPASTE);
		sinkEvents(Event.ONCONTEXTMENU);
	}

	/**
	 * @param element
	 */
	public MyTextArea(Element element) {
		super(element);
	}

	/**
	 * paste event overridden
	 */
	public void onBrowserEvent(Event event) {
	    super.onBrowserEvent(event);
	    switch (event.getTypeInt()) {
	        case Event.ONPASTE: {
	        	final String before = getText();
	        	GWT.log("BEFORE:" + before);
	            Timer t = new Timer() {
					@Override
					public void run() {
						String toCheck = getText().replaceAll(before, "");
						ShareUpdateForm.get().checkLink(toCheck);
					}
				};
	        	t.schedule(100);
	            break;
	        }
	        case Event.ONCONTEXTMENU: {
	        	removeSampleText();
	        	break;
	        }
	    }
	}
	protected void removeSampleText() {
		if (getText().equals(ShareUpdateForm.SHARE_UPDATE_TEXT) || getText().equals(ShareUpdateForm.ERROR_UPDATE_TEXT) ) {
			setText("");
			addStyleName("dark-color");
			removeStyleName("error");
		}
	}
}
