/**
 * 
 */
package org.gcube.portlets.user.shareupdates.client.form;

import java.util.ArrayList;

import org.gcube.portlets.user.pickuser.client.dialog.PickUsersDialog;
import org.gcube.portlets.user.pickuser.client.events.PickedUserEvent;
import org.gcube.portlets.user.pickuser.client.events.PickedUserEventHandler;
import org.gcube.portlets.user.pickuser.shared.PickingUser;
import org.gcube.portlets.user.shareupdates.client.ShareUpdateService;
import org.gcube.portlets.user.shareupdates.client.ShareUpdateServiceAsync;
import org.gcube.portlets.user.shareupdates.client.elements.ContentEditDiv;
import org.gcube.portlets.user.shareupdates.client.elements.Span;
import org.gcube.portlets.user.shareupdates.client.elements.TagBox;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;

/**
 * 
 * @author Massimiliano Assante, ISTI-CNR
 * 
 * SmartTextArea allows pasting of links with preview generation and tagging of people
 *
 */
public class SmartTextArea extends ContentEditDiv {
	/**
	 * Create a remote service proxy to talk to the server-side Greeting service.
	 */
	private final ShareUpdateServiceAsync shareupdateService = GWT
			.create(ShareUpdateService.class);
	private final HandlerManager eventBus = new HandlerManager(null);

	public final static int ARROW_UP = 38; 
	public final static int ARROW_DOWN = 40; 
	PickUsersDialog pickUserDlg;
	/**
	 * 
	 */
	public SmartTextArea() {
		bind();
		sinkEvents(Event.ONPASTE);
		sinkEvents(Event.ONCONTEXTMENU);
		sinkEvents(Event.ONKEYUP);
		sinkEvents(Event.ONKEYDOWN);

		shareupdateService.getPortalUsers(new AsyncCallback<ArrayList<PickingUser>>() {

			@Override
			public void onSuccess(ArrayList<PickingUser> users) {
				pickUserDlg = new PickUsersDialog(users, eventBus, 525);				
			}

			@Override
			public void onFailure(Throwable caught) {				
			}
		});
	}

	/**
	 * events binder
	 */
	private void bind() {
		eventBus.addHandler(PickedUserEvent.TYPE, new PickedUserEventHandler() {
			@Override
			public void onSelectedUser(PickedUserEvent event) {
				String[] toSplit = getHTML().split("@"); //get the interesting part		
				TagBox span = new TagBox(event.getSelectedUser().getFullName());
				setHTML(toSplit[0]);
				getElement().appendChild(span.getElement());
				getElement().appendChild(new Span(" ").getElement());				
				setEndOfContenteditable();
			}			
		});  
	}

	/**
	 * paste and other events overridden
	 */
	public void onBrowserEvent(Event event) {
		super.onBrowserEvent(event);
		switch (event.getTypeInt()) {
		case Event.ONPASTE: {
			final String before = getHTML();
			GWT.log("BEFORE:" + before);
			Timer t = new Timer() {
				@Override
				public void run() {
					String toCheck = extractLink(getHTML());
					if (toCheck != null) {
						GWT.log("toCheck1:" + toCheck);
						ShareUpdateForm.get().checkLink(new HTML(toCheck).getText());
						String sanitized = before + toCheck;
						setHTML(sanitized);
						setEndOfContenteditable();
					}
				}
			};
			t.schedule(100);
			break;
		}
		case Event.ONCONTEXTMENU: {
			removeSampleText();
			break;
		}
		case Event.ONKEYUP: {
			pickUserDlg.onKeyUp(event.getKeyCode(), this.getAbsoluteLeft(), this.getAbsoluteTop()+65, getText());				
			break;
		}
		case Event.ONKEYDOWN: {
			if (pickUserDlg.isShowing()) {
				//avoid the arrow up to move the cursor at the beginning of the textbox and the TAB to move around inputs and enter to go newline
				if (event.getKeyCode() == ARROW_UP || event.getKeyCode() == KeyCodes.KEY_TAB || event.getKeyCode() ==  KeyCodes.KEY_ENTER) {
					DOM.eventCancelBubble(event, true);
					DOM.eventPreventDefault(event);
					return;
				}
			}
			break;
		}
		}
		DomEvent.fireNativeEvent(event, this, this.getElement());
	}

	/**
	 * extract the pasted link
	 * @param textToCheck 
	 * @return null if there's no link present
	 */
	private String extractLink(String textToCheck) {
		GWT.log("textToCheck:" + textToCheck);
		String [] parts = textToCheck.split("\\s");
		// Attempt to convert each item into an URL.   
		for( String item : parts ) {
			if (item.startsWith("http")) {
				return item;
			}
			if (item.startsWith("href") || item.startsWith("HREF")) { //this is for (damned) safari because sometimes it paste <a href="http... nsteand of http
				textToCheck = textToCheck.replaceAll("\"", " ");
				textToCheck = textToCheck.replaceAll("href", " ");
				textToCheck = textToCheck.replaceAll("HREF", " ");
				return extractLink(textToCheck);
			}
		}
		//else we try plain text here (chrome)
		String plainText = new HTML(textToCheck).getText();
		if (textToCheck.length() != plainText.length()) {
			plainText = textToCheck.replaceAll("nbsp;", " ");
			String [] pparts = plainText.split("\\s");
			for( String item : pparts ) {
				if (item.startsWith("http")) 
					return item;
			}
		}
		return null;
	}

	protected void removeSampleText() {
		if (getText().equals(ShareUpdateForm.SHARE_UPDATE_TEXT) || getText().equals(ShareUpdateForm.ERROR_UPDATE_TEXT) ) {
			setText("");
			addStyleName("dark-color");
			removeStyleName("error");
		}
	}
}
