package org.gcube.portlets.user.shareupdates.server;

import java.util.ArrayList;

import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;

/**
 * 
 * @author Massimiliano Assante ISTI-CNR
 *
 */
public class MentionNotificationsThread implements Runnable {
	private static GCUBEClientLog _log = new GCUBEClientLog(MentionNotificationsThread.class);
	
	private String postText;
	private String postId;
	private NotificationsManager nm;
	private ArrayList<String> userIds;
	
	
	public MentionNotificationsThread(String postId, String postText, NotificationsManager nm, ArrayList<String> userIds) {
		super();
		this.postId = postId;
		this.postText = postText;
		this.nm = nm;
		this.userIds = userIds;
	}

	@Override
	public void run() {
		for (String userIdToNotify : userIds) {
			boolean result = nm.notifyUserTag(userIdToNotify, postId, postText);
			_log.trace("Sending Notification for post mention to: " + userIdToNotify + " result?"+ result);
		}
	}
}
