/**
 * 
 */
package org.gcube.portlets.user.shareupdates.client.form;

import java.util.ArrayList;

import org.gcube.portlets.user.pickuser.client.dialog.PickUsersDialog;
import org.gcube.portlets.user.pickuser.client.events.PickedUserEvent;
import org.gcube.portlets.user.pickuser.client.events.PickedUserEventHandler;
import org.gcube.portlets.user.pickuser.shared.PickingUser;
import org.gcube.portlets.user.shareupdates.client.ShareUpdateService;
import org.gcube.portlets.user.shareupdates.client.ShareUpdateServiceAsync;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.TextArea;

/**
 * @author massi
 *
 */
public class SuperPosedTextArea extends TextArea {
	private final ShareUpdateServiceAsync shareupdateService = GWT
			.create(ShareUpdateService.class);
	private final HandlerManager eventBus = new HandlerManager(null);

	PickUsersDialog pickUserDlg;
	public final static int ARROW_UP = 38; 
	public final static int ARROW_DOWN = 40; 
	
	private ArrayList<String> mentionedUsers = new ArrayList<String>();

	/**
	 * 
	 */
	public SuperPosedTextArea() {
		sinkEvents(Event.ONPASTE);
		sinkEvents(Event.ONKEYUP);
		sinkEvents(Event.ONCONTEXTMENU);
		sinkEvents(Event.ONKEYDOWN);

		shareupdateService.getPortalUsers(new AsyncCallback<ArrayList<PickingUser>>() {

			@Override
			public void onSuccess(ArrayList<PickingUser> users) {
				pickUserDlg = new PickUsersDialog(users, eventBus, 525);				
			}

			@Override
			public void onFailure(Throwable caught) {				
			}
		});
		DOM.setElementAttribute(getElement(), "id", "postTextArea"); 
		 bind();
	}

	/**
	 * @param element
	 */
	public SuperPosedTextArea(Element element) {
		super(element);
	}

	/**
	 * paste event overridden
	 */
	public void onBrowserEvent(Event event) {
		super.onBrowserEvent(event);
		switch (event.getTypeInt()) {
		case Event.ONPASTE: {
			final String before = getText();
			GWT.log("BEFORE:" + before);
			Timer t = new Timer() {
				@Override
				public void run() {
					String toCheck = getText().replaceAll(before, "");
					ShareUpdateForm.get().checkLink(toCheck);
				}
			};
			t.schedule(100);
			break;
		}
		case Event.ONKEYUP: {
			injectInDiv(getText());
			pickUserDlg.onKeyUp(event.getKeyCode(), this.getAbsoluteLeft(), this.getAbsoluteTop()+65, getText());				
			break;
		}
		case Event.ONCONTEXTMENU: {
			removeSampleText();
			break;
		}
		case Event.ONKEYDOWN: {
			if (pickUserDlg.isShowing()) {
				//avoid the arrow up to move the cursor at the beginning of the textbox and the TAB to move around inputs and enter to go newline
				if (event.getKeyCode() == ARROW_UP || event.getKeyCode() == KeyCodes.KEY_TAB || event.getKeyCode() ==  KeyCodes.KEY_ENTER) {
					DOM.eventCancelBubble(event, true);
					DOM.eventPreventDefault(event);
					return;
				}
			}
			break;
		}
		}
	}
	protected void removeSampleText() {
		if (getText().equals(ShareUpdateForm.SHARE_UPDATE_TEXT) || getText().equals(ShareUpdateForm.ERROR_UPDATE_TEXT) ) {
			setText("");
			addStyleName("darker-color");
			removeStyleName("error");
		}
	}
	protected void cleanHighlihterDiv() {
		DOM.getElementById("highlighter").setInnerHTML("");
	}
	private void injectInDiv(String textAreaText) {
		String text;
		// parse the text:
		// replace all the line braks by <br/>, and all the double spaces by the html version &nbsp;
		text = textAreaText.replaceAll("(\r\n|\n)","<br />");
		text = text.replaceAll("\\s\\s","&nbsp;&nbsp;");

		for (String mentionedUser : mentionedUsers) {
			text = text.replaceAll(mentionedUser,"<span class=\"highlightedUser\">"+mentionedUser+"</span>");
		}
		// re-inject the processed text into the div
		DOM.getElementById("highlighter").setInnerHTML(text);
	}
	
	/**
	 * events binder
	 */
	private void bind() {
		eventBus.addHandler(PickedUserEvent.TYPE, new PickedUserEventHandler() {
			@Override
			public void onSelectedUser(PickedUserEvent event) {

				String toAdd = event.getSelectedUser().getFullName();
				mentionedUsers.add(toAdd);
				
				String[] toSplit = getText().split("@"); //get the preceeding part	
				
				setText(toSplit[0]+toAdd);
				Element highDiv = DOM.getElementById("highlighter");
				
				String[] htmlToSplit = highDiv.getInnerHTML().split("@"); //get the preceeding part	
				String highLightedUser = "<span class=\"highlightedUser\">"+toAdd+"</span>";
				highDiv.setInnerHTML(htmlToSplit[0]+highLightedUser);
			}			
		});  
	}
	
	public ArrayList<String> getMentionedUsers() {
		ArrayList<String> toReturn = new ArrayList<String>();
		for (String mentionedUser : mentionedUsers) {
			if (getText().contains(mentionedUser))
				toReturn.add(mentionedUser);
		}
		GWT.log(toReturn.toString());
		return mentionedUsers;
	}
}
