/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.server.metaseeker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import org.gcube.portlets.user.shareupdates.server.metaseeker.MetaElement;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaSeeker {
    private static Logger _log = LoggerFactory.getLogger(MetaSeeker.class);
    private String pageUrl;
    private Hashtable<String, ArrayList<MetaElement>> metaAttributes = new Hashtable();
    private String baseType;
    private boolean isImported = false;
    private boolean hasChanged = false;
    public static final String[] REQUIRED_META = new String[]{"title", "type", "image", "url"};
    public static final Hashtable<String, String[]> BASE_TYPES = new Hashtable();

    public MetaSeeker() {
    }

    public MetaSeeker(String url) throws IOException, Exception {
        this();
        String inputLine;
        this.isImported = true;
        URL httpURL = new URL(url);
        BufferedReader dis = new BufferedReader(new InputStreamReader(httpURL.openStream()));
        StringBuffer headContents = new StringBuffer();
        while ((inputLine = dis.readLine()) != null) {
            if (inputLine.contains("</head>")) {
                inputLine = inputLine.substring(0, inputLine.indexOf("</head>") + 7);
                inputLine = inputLine.concat("<body></body></html>");
                headContents.append(inputLine + "\r\n");
                break;
            }
            headContents.append(inputLine + "\r\n");
        }
        String headContentsStr = headContents.toString();
        HtmlCleaner cleaner = new HtmlCleaner();
        TagNode pageData = cleaner.clean(headContentsStr);
        TagNode[] metaData = pageData.getElementsByName("meta", true);
        _log.trace("meta length " + metaData.length);
        for (TagNode metaElement : metaData) {
            String target = null;
            _log.trace("meta found ");
            if (!metaElement.hasAttribute("name")) continue;
            target = "name";
            this.setProperty(metaElement.getAttributeByName(target), metaElement.getAttributeByName("content"));
            _log.trace(metaElement.getAttributeByName("content"));
        }
        this.pageUrl = httpURL.toExternalForm();
    }

    public String getBaseType() {
        return this.baseType;
    }

    public String getContent(String property) {
        if (this.metaAttributes.containsKey(property) && ((ArrayList)this.metaAttributes.get(property)).size() > 0) {
            return ((MetaElement)((ArrayList)this.metaAttributes.get(property)).get(0)).getContent();
        }
        return null;
    }

    public MetaElement[] getProperties() {
        ArrayList allElements = new ArrayList();
        for (ArrayList collection : this.metaAttributes.values()) {
            allElements.addAll(collection);
        }
        return allElements.toArray(new MetaElement[allElements.size()]);
    }

    public MetaElement[] getProperties(String property) {
        if (this.metaAttributes.containsKey(property)) {
            ArrayList target = (ArrayList)this.metaAttributes.get(property);
            return target.toArray(new MetaElement[target.size()]);
        }
        return null;
    }

    public String getOriginalUrl() {
        return this.pageUrl;
    }

    public void setProperty(String property, String content) {
        MetaElement element = new MetaElement(property, content);
        if (!this.metaAttributes.containsKey(property)) {
            this.metaAttributes.put(property, new ArrayList());
        }
        ((ArrayList)this.metaAttributes.get(property)).add(element);
    }

    public void removeProperty(String property) {
        this.metaAttributes.remove(property);
    }

    public Hashtable<String, ArrayList<MetaElement>> exposeTable() {
        return this.metaAttributes;
    }

    public boolean isFromWeb() {
        return this.isImported;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    static {
        BASE_TYPES.put("activity", new String[]{"activity", "sport"});
        BASE_TYPES.put("business", new String[]{"bar", "company", "cafe", "hotel", "restaurant"});
        BASE_TYPES.put("group", new String[]{"cause", "sports_league", "sports_team"});
        BASE_TYPES.put("organization", new String[]{"band", "government", "non_profit", "school", "university"});
        BASE_TYPES.put("person", new String[]{"actor", "athlete", "author", "director", "musician", "politician", "profile", "public_figure"});
        BASE_TYPES.put("place", new String[]{"city", "country", "landmark", "state_province"});
        BASE_TYPES.put("product", new String[]{"album", "book", "drink", "food", "game", "movie", "product", "song", "tv_show"});
        BASE_TYPES.put("website", new String[]{"blog", "website", "article"});
    }
}

