/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.sun.net.ssl.HttpsURLConnection;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.validator.routines.UrlValidator;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.storage.UriResolverReaderParameter;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.ClientFeed;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.FeedType;
import org.gcube.portal.databook.shared.PrivacyLevel;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portlets.user.shareupdates.client.ShareUpdateService;
import org.gcube.portlets.user.shareupdates.server.FilePreviewer;
import org.gcube.portlets.user.shareupdates.server.MentionNotificationsThread;
import org.gcube.portlets.user.shareupdates.server.PostNotificationsThread;
import org.gcube.portlets.user.shareupdates.server.TextTransfromUtils;
import org.gcube.portlets.user.shareupdates.server.UploadToStorageThread;
import org.gcube.portlets.user.shareupdates.server.UploadToWorkspaceThread;
import org.gcube.portlets.user.shareupdates.server.opengraph.OpenGraph;
import org.gcube.portlets.user.shareupdates.shared.LinkPreview;
import org.gcube.portlets.user.shareupdates.shared.UserSettings;
import org.gcube.portlets.widgets.pickuser.shared.PickingUser;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GroupModel;
import org.gcube.vomanagement.usermanagement.model.UserModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShareUpdateServiceImpl
extends RemoteServiceServlet
implements ShareUpdateService {
    private static final String ADMIN_ROLE = "Administrator";
    public static final String TEST_USER = "test.user";
    private static final String STORAGE_OWNER = "gCubeSocialFramework";
    public static final String UPLOAD_DIR = "/social-framework-uploads";
    private static final String NEWS_FEED_PORTLET_CLASSNAME = "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl";
    private static Logger _log = LoggerFactory.getLogger(ShareUpdateServiceImpl.class);
    private DatabookStore store;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
    }

    public void destroy() {
        this.store.closeConnection();
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube/devsec/devVRE");
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public String getDevelopmentUser() {
        String user = "test.user";
        return user;
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    public ClientFeed share(String postText, FeedType feedType, PrivacyLevel pLevel, String vreId, LinkPreview preview, String urlThumbnail, ArrayList<String> mentionedUserFullNames, String fileName, String filePathOnServer, boolean notifyGroup) {
        Thread thread;
        ApplicationNotificationsManager nm;
        String escapedFeedText = TextTransfromUtils.escapeHtmlAndTransformUrl((String)postText);
        ArrayList mentionedUsers = null;
        if (mentionedUserFullNames != null && !mentionedUserFullNames.isEmpty()) {
            mentionedUsers = this.getSelectedUserIds(mentionedUserFullNames);
            escapedFeedText = TextTransfromUtils.convertMentionPeopleAnchorHTML((String)escapedFeedText, (ArrayList)mentionedUsers);
        }
        ASLSession session = this.getASLSession();
        String username = session.getUsername();
        String email = String.valueOf(username) + "@isti.cnr.it";
        String fullName = String.valueOf(username) + " FULL";
        String thumbnailURL = "images/Avatar_default.png";
        boolean withinPortal = this.isWithinPortal();
        if (withinPortal && username.compareTo("test.user") != 0) {
            try {
                UserInfo user = this.getUserSettings().getUserInfo();
                email = user.getEmailaddress();
                fullName = user.getFullName();
                thumbnailURL = user.getAvatarId();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String linkTitle = preview.getTitle();
        String linkDesc = preview.getDescription();
        String host = preview.getHost();
        String url = preview.getUrl();
        if (urlThumbnail == null) {
            urlThumbnail = "null";
        }
        Date feedDate = new Date();
        String textToPost = "";
        textToPost = escapedFeedText.trim().compareTo("_N0_73X7_SH4R3_") == 0 ? TextTransfromUtils.convertFileNameAnchorHTML((String)url) : escapedFeedText;
        String vreScope2Set = "";
        if (pLevel == PrivacyLevel.SINGLE_VRE && vreId != null && vreId.compareTo("") != 0) {
            vreScope2Set = withinPortal ? this.getScopeByOrganizationId(vreId) : session.getScope();
        }
        Feed toShare = new Feed(UUID.randomUUID().toString(), feedType, username, feedDate, vreScope2Set, url, urlThumbnail, textToPost, pLevel, fullName, email, thumbnailURL, linkTitle, linkDesc, host);
        _log.info("Attempting to save Feed with text: " + textToPost + " Level: " + pLevel + " Timeline=" + vreScope2Set);
        boolean result = this.store.saveUserFeed(toShare);
        if (pLevel == PrivacyLevel.VRES) {
            _log.trace("PrivacyLevel was set to VRES attempting to write onto User's VRES Timelines");
            for (GroupModel vre : this.getUserVREs(username)) {
                String vreScope = this.getScopeByOrganizationId(vre.getGroupId());
                _log.trace("Attempting to write onto " + vreScope);
                try {
                    this.store.saveFeedToVRETimeline(toShare.getKey(), vreScope);
                }
                catch (FeedIDNotFoundException e) {
                    _log.error("Error writing onto VRES Time Line" + vreScope);
                }
                _log.trace("Success writing onto " + vreScope);
            }
        } else if (pLevel == PrivacyLevel.SINGLE_VRE && vreId != null && vreId.compareTo("") != 0) {
            _log.trace("Attempting to write onto " + vreScope2Set);
            try {
                this.store.saveFeedToVRETimeline(toShare.getKey(), vreScope2Set);
            }
            catch (FeedIDNotFoundException e) {
                _log.error("Error writing onto VRES Time Line" + vreScope2Set);
            }
            _log.trace("Success writing onto " + vreScope2Set);
        }
        if (!result) {
            return null;
        }
        ClientFeed cf = new ClientFeed(toShare.getKey(), toShare.getType().toString(), username, feedDate, toShare.getUri(), TextTransfromUtils.replaceAmpersand((String)toShare.getDescription()), fullName, email, thumbnailURL, toShare.getLinkTitle(), toShare.getLinkDescription(), toShare.getUriThumbnail(), toShare.getLinkHost());
        if (pLevel == PrivacyLevel.SINGLE_VRE && vreId != null && vreId.compareTo("") != 0 && notifyGroup) {
            nm = new ApplicationNotificationsManager(session, "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl");
            thread = new Thread((Runnable)new PostNotificationsThread(toShare.getKey(), textToPost, "" + session.getGroupId(), (NotificationsManager)nm));
            thread.start();
        }
        if (mentionedUsers != null && mentionedUsers.size() > 0) {
            nm = new ApplicationNotificationsManager(session);
            thread = new Thread((Runnable)new MentionNotificationsThread(toShare.getKey(), textToPost, (NotificationsManager)nm, mentionedUsers));
            thread.start();
        }
        if (fileName != null && filePathOnServer != null) {
            Thread thread2 = new Thread((Runnable)new UploadToWorkspaceThread(username, fileName, filePathOnServer));
            thread2.start();
        }
        return cf;
    }

    public UserSettings getUserSettings() {
        try {
            ASLSession session = this.getASLSession();
            String username = session.getUsername();
            String email = String.valueOf(username) + "@isti.cnr.it";
            String fullName = String.valueOf(username) + " FULL";
            String thumbnailURL = "images/Avatar_default.png";
            if (this.isWithinPortal() && username.compareTo("test.user") != 0) {
                User user = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)username);
                thumbnailURL = "/image/user_male_portrait?img_id=" + user.getPortraitId();
                fullName = String.valueOf(user.getFirstName()) + " " + user.getLastName();
                email = user.getEmailAddress();
                ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
                String accountURL = themeDisplay.getURLMyAccount().toString();
                HashMap vreNames = this.getUserVreNames(username);
                UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, user.getEmailAddress(), accountURL, true, this.isAdmin(), vreNames);
                UserSettings toReturn = new UserSettings(userInfo, 0, session.getScopeName(), this.isInfrastructureScope());
                return toReturn;
            }
            _log.info("Returning test USER = " + session.getUsername());
            HashMap<String, String> fakeVreNames = new HashMap<String, String>();
            fakeVreNames.put("/gcube/devsec/devVRE", "devVRE");
            UserInfo user = new UserInfo(session.getUsername(), fullName, thumbnailURL, email, "fakeAccountUrl", true, false, fakeVreNames);
            return new UserSettings(user, 0, session.getScopeName(), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new UserSettings();
        }
    }

    public LinkPreview checkUploadedFile(String fileName, String fileabsolutePathOnServer) {
        LinkPreview toReturn = null;
        String randomUploadFolderName = UUID.randomUUID().toString();
        String remoteFilePath = "/social-framework-uploads/" + randomUploadFolderName + "/" + fileName;
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set("/" + PortalContext.getConfiguration().getInfrastructureName());
        IClient storageClient = new StorageClient("gCubeSocialFramework", AccessType.SHARED, MemoryType.PERSISTENT).getClient();
        ScopeProvider.instance.set(currScope);
        String httpURL = "";
        String smpURI = storageClient.getUrl().RFile(remoteFilePath);
        Thread thread = new Thread((Runnable)new UploadToStorageThread(storageClient, fileName, fileabsolutePathOnServer, remoteFilePath));
        thread.start();
        try {
            String mimeType = FilePreviewer.getMimeType((File)new File(fileabsolutePathOnServer), (String)fileName);
            UriResolverReaderParameter resolver = new UriResolverReaderParameter();
            httpURL = resolver.resolveAsUriRequest(smpURI, fileName, mimeType, true);
            switch (mimeType) {
                case "application/pdf": {
                    toReturn = FilePreviewer.getPdfPreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType);
                    break;
                }
                case "application/vnd.openxmlformats-officedocument.wordprocessingml.document": {
                    mimeType = "application/wordprocessor";
                    return FilePreviewer.getUnhandledTypePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType);
                }
                case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": {
                    mimeType = "application/spreadsheet";
                    return FilePreviewer.getUnhandledTypePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType);
                }
                case "application/vnd.openxmlformats-officedocument.presentationml.presentation": {
                    mimeType = "application/presentation";
                    return FilePreviewer.getUnhandledTypePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType);
                }
                case "image/jpeg": 
                case "image/tiff": 
                case "image/bmp": 
                case "image/gif": 
                case "image/jpg": 
                case "image/png": {
                    toReturn = FilePreviewer.getImagePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType);
                    break;
                }
                default: {
                    return FilePreviewer.getUnhandledTypePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType);
                }
            }
        }
        catch (Exception e) {
            _log.error("Error while resolving or previewing file");
            e.printStackTrace();
        }
        _log.debug("smpURI=" + smpURI);
        _log.debug("Returning httpURL=" + httpURL);
        return toReturn;
    }

    public LinkPreview checkLink(String linkToCheck) {
        URL pageURL;
        LinkPreview toReturn = null;
        _log.info("to check " + linkToCheck);
        linkToCheck = TextTransfromUtils.extractURL((String)linkToCheck);
        if (linkToCheck == null) {
            return null;
        }
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        if (!urlValidator.isValid(linkToCheck)) {
            _log.warn("url is NOT valid, returning nothing");
            return null;
        }
        _log.debug("url is valid");
        HttpURLConnection siteConnection = null;
        try {
            pageURL = new URL(linkToCheck);
            if (pageURL.getProtocol().equalsIgnoreCase("https")) {
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                Security.addProvider((java.security.Provider)new Provider());
                TextTransfromUtils.trustAllHTTPSConnections();
                siteConnection = (HttpsURLConnection)pageURL.openConnection();
            } else {
                siteConnection = (HttpURLConnection)pageURL.openConnection();
            }
        }
        catch (MalformedURLException e) {
            _log.error("url is not valid");
            return null;
        }
        catch (IOException e) {
            _log.error("url is not reachable");
            return null;
        }
        siteConnection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        ArrayList imageUrls = new ArrayList();
        String host = pageURL.getHost().replaceAll("www.", "");
        OpenGraph ogLink = null;
        try {
            ogLink = new OpenGraph(linkToCheck, true, (URLConnection)siteConnection);
            if (ogLink != null && ogLink.getContent("title") != null) {
                _log.info("OpenGraph Found");
                String title = ogLink.getContent("title");
                String description = ogLink.getContent("description") != null ? ogLink.getContent("description") : "";
                String string = description = description.length() > 256 ? String.valueOf(description.substring(0, 256)) + "..." : description;
                if (ogLink.getContent("image") != null) {
                    String imageUrl = TextTransfromUtils.getImageUrlFromSrcAttribute((URL)pageURL, (String)ogLink.getContent("image"));
                    imageUrls.add(imageUrl);
                    _log.trace("OpenGraph getImage = " + imageUrl);
                } else {
                    _log.trace("OpenGraph No Image, trying manuale parsing");
                    ArrayList images = TextTransfromUtils.getImagesWithCleaner((URL)pageURL);
                    if (!images.isEmpty()) {
                        imageUrls = images;
                    }
                }
                toReturn = new LinkPreview(title, description, linkToCheck, host, imageUrls);
                return toReturn;
            }
            _log.info("No OpenGraph Found, going Best guess from page content");
            toReturn = TextTransfromUtils.getInfoFromHTML((URLConnection)siteConnection, (URL)pageURL, (String)linkToCheck, (String)host);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private HashMap<String, String> getUserVreNames(String username) {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        if (this.isInfrastructureScope()) {
            for (GroupModel vre : this.getUserVREs(username)) {
                toReturn.put(vre.getGroupId(), vre.getGroupName());
            }
        } else {
            for (GroupModel vre : this.getUserVREs(username)) {
                if (vre.getGroupName().compareTo(this.getASLSession().getGroupName()) != 0) continue;
                toReturn.put(vre.getGroupId(), vre.getGroupName());
            }
        }
        return toReturn;
    }

    private boolean isAdmin() throws PortalException, SystemException {
        User currUser = OrganizationsUtil.validateUser((String)this.getASLSession().getUsername());
        List organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
        Organization rootOrganization = null;
        for (Organization organization : organizations) {
            if (!organization.getName().equals(OrganizationsUtil.getRootOrganizationName())) continue;
            rootOrganization = organization;
            break;
        }
        try {
            _log.trace("root: " + rootOrganization.getName());
            return this.hasRole("Administrator", rootOrganization.getName(), currUser);
        }
        catch (NullPointerException e) {
            _log.error("Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder");
            return false;
        }
    }

    private boolean hasRole(String rolename, String organizationName, User user) throws SystemException {
        for (Role role : user.getRoles()) {
            if (role.getName().compareTo(rolename) != 0) continue;
            return true;
        }
        return false;
    }

    private ArrayList<GroupModel> getUserVREs(String username) {
        ArrayList<GroupModel> toReturn = new ArrayList<GroupModel>();
        try {
            LiferayGroupManager gm = new LiferayGroupManager();
            User currUser = OrganizationsUtil.validateUser((String)username);
            for (Organization org : currUser.getOrganizations()) {
                if (!gm.isVRE(String.valueOf(org.getOrganizationId())).booleanValue()) continue;
                GroupModel toAdd = gm.getGroup("" + org.getOrganizationId());
                toReturn.add(toAdd);
            }
        }
        catch (Exception e) {
            _log.error("Failed reading User VREs for : " + username);
            e.printStackTrace();
            return toReturn;
        }
        return toReturn;
    }

    private String getScopeByOrganizationId(String vreid) {
        LiferayGroupManager gm = new LiferayGroupManager();
        try {
            return gm.getScope(vreid);
        }
        catch (Exception e) {
            _log.error("Could not find a scope for this VREid: " + vreid);
            return null;
        }
    }

    private boolean isInfrastructureScope() {
        ScopeBean scope = new ScopeBean(this.getASLSession().getScope());
        return scope.is(ScopeBean.Type.INFRASTRUCTURE);
    }

    public ArrayList<PickingUser> getSelectedUserIds(ArrayList<String> fullNames) {
        if (fullNames == null) {
            return new ArrayList<PickingUser>();
        }
        ArrayList allUsers = this.getPortalUsers();
        ArrayList<PickingUser> toReturn = new ArrayList<PickingUser>();
        block0: for (String fullName : fullNames) {
            for (PickingUser puser : allUsers) {
                if (puser.getFullName().compareTo(fullName) != 0) continue;
                toReturn.add(puser);
                continue block0;
            }
        }
        return toReturn;
    }

    public ArrayList<PickingUser> getPortalUsers() {
        ASLSession session = this.getASLSession();
        boolean withinPortal = false;
        if (this.isWithinPortal() && session.getUsername().compareTo("test.user") != 0) {
            withinPortal = true;
        }
        return ShareUpdateServiceImpl.getOrganizationUsers((String)session.getScope(), (String)session.getUsername(), (boolean)withinPortal);
    }

    public static ArrayList<PickingUser> getOrganizationUsers(String scope, String currUser, boolean withinPortal) {
        ArrayList<PickingUser> portalUsers = new ArrayList<PickingUser>();
        try {
            if (withinPortal) {
                LiferayUserManager um = new LiferayUserManager();
                LiferayGroupManager gm = new LiferayGroupManager();
                ScopeBean sb = new ScopeBean(scope);
                List users = null;
                if (sb.is(ScopeBean.Type.INFRASTRUCTURE)) {
                    users = um.listUsersByGroup(gm.getRootVO().getGroupId());
                } else if (sb.is(ScopeBean.Type.VRE)) {
                    String orgName = scope.substring(scope.lastIndexOf("/") + 1, scope.length());
                    users = um.listUsersByGroup(gm.getGroupId(orgName));
                } else {
                    _log.error("Error, you must be in SCOPE VRE OR INFRASTURCTURE, you are in VO SCOPE returning no users");
                    return portalUsers;
                }
                for (UserModel user : users) {
                    if (user.getScreenName().compareTo("test.user") == 0 || user.getScreenName().compareTo(currUser) == 0) continue;
                    String thumbnailURL = "";
                    User lifeUser = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)user.getScreenName());
                    thumbnailURL = "/image/user_male_portrait?img_id=" + lifeUser.getPortraitId();
                    portalUsers.add(new PickingUser(user.getUserId(), user.getScreenName(), user.getFullname(), thumbnailURL));
                }
            } else {
                portalUsers.add(new PickingUser("12111", "massimiliano.assante", "Test User #1", ""));
                portalUsers.add(new PickingUser("14111", "massimiliano.assante", "Test Second User #2", ""));
                portalUsers.add(new PickingUser("11511", "massimiliano.assante", "Test Third User", ""));
                portalUsers.add(new PickingUser("11611", "massimiliano.assante", "Test Fourth User", ""));
                portalUsers.add(new PickingUser("11711", "massimiliano.assante", "Test Fifth User", ""));
                portalUsers.add(new PickingUser("11811", "massimiliano.assante", "Test Sixth User", ""));
                portalUsers.add(new PickingUser("15811", "massimiliano.assante", "Ninth Testing User", ""));
                portalUsers.add(new PickingUser("15811", "massimiliano.assante", "Eighth Testing User", ""));
                portalUsers.add(new PickingUser("11211", "giogio.giorgi", "Seventh Test User", ""));
                portalUsers.add(new PickingUser("2222", "pino.pinetti", "Tenth Testing User", ""));
            }
        }
        catch (Exception e) {
            _log.error("Error in server get all contacts ", (Throwable)e);
        }
        return portalUsers;
    }
}

