/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.socialprofile.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.util.HashMap;
import java.util.Properties;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.socialprofile.client.SocialService;
import org.gcube.portlets.user.socialprofile.shared.UserContext;

public class SocialServiceImpl
extends RemoteServiceServlet
implements SocialService {
    private static GCUBEClientLog _log = new GCUBEClientLog(SocialServiceImpl.class, new Properties[0]);
    private boolean withinPortal = false;

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn((Object)"USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = "test.user";
            user = "massimiliano.assante";
            this.withinPortal = false;
        } else {
            this.withinPortal = true;
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public UserContext getUserContext(String userid) {
        if (userid == null || userid.equals("")) {
            System.out.println("Own Profile");
            _log.info((Object)"Own Profile");
            return this.getOwnProfile();
        }
        System.out.println("Reading Profile");
        _log.info((Object)(String.valueOf(userid) + " Reading Profile"));
        return this.getUserProfile(userid);
    }

    private UserContext getUserProfile(String username) {
        ASLSession session = this.getASLSession();
        String email = String.valueOf(username) + "@isti.cnr.it";
        String fullName = String.valueOf(username) + " FULL";
        String thumbnailURL = "images/Avatar_default.png";
        if (this.withinPortal) {
            try {
                User user = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)username);
                thumbnailURL = "/image/user_male_portrait?img_id=" + user.getPortraitId();
                fullName = String.valueOf(user.getFirstName()) + " " + user.getLastName();
                email = user.getEmailAddress();
                HashMap vreNames = new HashMap();
                UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, user.getEmailAddress(), "", true, false, vreNames);
                return new UserContext(userInfo, this.getHeadline(username), this.getInstitution(username), session.getScopeName(), true);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new UserContext();
            }
        }
        _log.info((Object)"Returning test USER");
        HashMap<String, String> fakeVreNames = new HashMap<String, String>();
        fakeVreNames.put("/gcube/devsec/devVRE", "devVRE");
        UserInfo user = new UserInfo(username, String.valueOf(username) + "FULL", thumbnailURL, email, "fakeAccountUrl", true, false, fakeVreNames);
        return new UserContext(user, null, "Institution", session.getScopeName(), true);
    }

    private UserContext getOwnProfile() {
        try {
            ASLSession session = this.getASLSession();
            String username = session.getUsername();
            String email = String.valueOf(username) + "@isti.cnr.it";
            String fullName = String.valueOf(username) + " FULL";
            String thumbnailURL = "images/Avatar_default.png";
            if (this.withinPortal) {
                User user = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)username);
                thumbnailURL = "/image/user_male_portrait?img_id=" + user.getPortraitId();
                fullName = String.valueOf(user.getFirstName()) + " " + user.getLastName();
                email = user.getEmailAddress();
                ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
                String accountURL = themeDisplay.getURLMyAccount().toString();
                HashMap vreNames = new HashMap();
                UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, user.getEmailAddress(), accountURL, true, false, vreNames);
                return new UserContext(userInfo, this.getHeadline(session.getUsername()), this.getInstitution(session.getUsername()), session.getScopeName(), true);
            }
            _log.info((Object)"Returning test USER");
            HashMap<String, String> fakeVreNames = new HashMap<String, String>();
            fakeVreNames.put("/gcube/devsec/devVRE", "devVRE");
            UserInfo user = new UserInfo(this.getASLSession().getUsername(), fullName, thumbnailURL, email, "fakeAccountUrl", true, false, fakeVreNames);
            return new UserContext(user, "", "", session.getScopeName(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new UserContext();
        }
    }

    private String getHeadline(String userid) throws PortalException, SystemException {
        User user = OrganizationsUtil.validateUser((String)userid);
        return user.getJobTitle();
    }

    private String getInstitution(String userid) throws PortalException, SystemException {
        User user = OrganizationsUtil.validateUser((String)userid);
        return user.getComments();
    }

    public Boolean saveHeadline(String newHeadline) {
        try {
            User user = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)this.getASLSession().getUsername());
            user.setJobTitle(this.escapeHtml(newHeadline));
            if (UserLocalServiceUtil.updateUser((User)user) != null) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Boolean saveIsti(String institution) {
        try {
            User user = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)this.getASLSession().getUsername());
            user.setComments(this.escapeHtml(institution));
            if (UserLocalServiceUtil.updateUser((User)user) != null) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private String escapeHtml(String html) {
        if (html == null) {
            return null;
        }
        return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

