package org.gcube.portlets.user.socialprofile.client.ui;

import java.util.ArrayList;
import java.util.List;


import org.gcube.portal.databook.client.GCubeSocialNetworking;
import org.gcube.portal.databook.client.util.Encoder;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.socialprofile.client.SocialService;
import org.gcube.portlets.user.socialprofile.client.SocialServiceAsync;
import org.gcube.portlets.user.socialprofile.shared.UserContext;
import org.gcube.portlets.widgets.wsmail.client.forms.MailForm;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

public class DisplayProfile extends Composite {
	protected final static String HEADLINE_TEXT = "Professional Headline";
	protected final static String HEADLINE_ERROR = "Your Headline please";
	protected final static String ISTI_TEXT = "Company";
	protected final static String ISTI_ERROR = "Your Company please";
	
	private static DisplayProfileUiBinder uiBinder = GWT
			.create(DisplayProfileUiBinder.class);

	interface DisplayProfileUiBinder extends UiBinder<Widget, DisplayProfile> {
	}
	public static final String avatar_default = GWT.getModuleBaseURL() + "../images/Avatar_default.png";
	public static final String loading = GWT.getModuleBaseURL() + "../images/avatarLoader.gif";
	public static final String savingImage = GWT.getModuleBaseURL() + "../images/saving.gif";
	public static final String GET_OID_PARAMETER = "oid";
	private final SocialServiceAsync socialService = GWT.create(SocialService.class);

	@UiField HTMLPanel mainPanel;
	@UiField Image avatarImage;	
	@UiField HTML userFullName;
	@UiField TextBox headlineBox;
	@UiField TextBox institutionBox;
	
	@UiField HTML editHeadline;
	@UiField HTML editIsti;
	
	@UiField HTML headlineLabel;
	@UiField HTML institutionLabel;
	
	@UiField Image savingHeadline;
	@UiField Button saveHead;
	@UiField Button cancelHead;
	
	@UiField Button saveIsti;
	@UiField Button cancelIsti;
	
	@UiField Button messageButton;

	private String currHeadLine;
	private String currInstitution;
	
	private UserInfo myUserInfo;

	public DisplayProfile() {
		initWidget(uiBinder.createAndBindUi(this));
		avatarImage.setUrl(loading);
		mainPanel.addStyleName("framed");	
		savingHeadline.setUrl(savingImage);
		socialService.getUserContext(getUserToShowId(), new AsyncCallback<UserContext>() {
			@Override
			public void onSuccess(UserContext result) {
				myUserInfo = result.getUserInfo();				
				avatarImage.getElement().getParentElement().setAttribute("href", myUserInfo.getAccountURL());
				avatarImage.setSize("100px", "100px");
				avatarImage.setUrl(myUserInfo.getAvatarId());	
				userFullName.setText(myUserInfo.getFullName());
			
				if (getUserToShowId() == null) { //its him seeing his profile
					
					String head = (result.getHeadline() == null || result.getHeadline().compareTo("") == 0) ? HEADLINE_TEXT : result.getHeadline();
					String isti = (result.getInstitution() == null ||result.getInstitution().compareTo("") == 0) ? ISTI_TEXT : result.getInstitution();
					headlineLabel.setText(head);
					institutionLabel.setText(isti);
										
					editHeadline.setStyleName("editImage");
					editHeadline.setTitle("Edit your Professional Headline");
							
					editIsti.setStyleName("editImage");
					editIsti.setTitle("Edit your Company");
					
					headlineBox.setMaxLength(70);
					institutionBox.setMaxLength(70);
				
					messageButton.removeFromParent();
					currHeadLine = head;
					if  (result.getHeadline() == null || result.getHeadline().compareTo("") == 0) {
						headlineLabel.getElement().getStyle().setOpacity(0.5);
						institutionLabel.getElement().getStyle().setOpacity(0.5);						
					}
				} else { //its someone else
					String head = (result.getHeadline() == null || result.getHeadline().compareTo("") == 0) ? "" : result.getHeadline();
					String isti = (result.getInstitution() == null || result.getInstitution().compareTo("") == 0) ? "" : result.getInstitution();
					headlineLabel.setText(head);
					institutionLabel.setText(isti);
					
					avatarImage.getElement().getParentElement().setAttribute("href", "");
					avatarImage.setTitle(myUserInfo.getFullName());
					messageButton.setText("Private Message");
					messageButton.setVisible(true);
				}


			}
			@Override
			public void onFailure(Throwable caught) {
				Window.alert("Failure: " + caught.getMessage());
				avatarImage.setSize("100px", "100px");
				avatarImage.setUrl(avatar_default);				
			}
		});
	}
	
	@UiHandler("editHeadline") 
	void onEditHeadlineClick(ClickEvent e) {
		headlineLabel.setVisible(false);
		headlineBox.setText(headlineLabel.getText());
		headlineBox.addStyleName("edit");		
		headlineBox.setVisible(true);
		headlineBox.setFocus(true);
		headlineBox.selectAll();		

		editHeadline.setVisible(false);
		saveHead.setVisible(true);		
		cancelHead.setVisible(true);		
	}
	
	@UiHandler("editIsti") 
	void onEditInstitutionClick(ClickEvent e) {
		institutionLabel.setVisible(false);
		institutionBox.setText(institutionLabel.getText());
		institutionBox.addStyleName("edit");		
		institutionBox.setVisible(true);
		institutionBox.setFocus(true);
		institutionBox.selectAll();		

		editIsti.setVisible(false);
		saveIsti.setVisible(true);		
		cancelIsti.setVisible(true);		
	}
	
	@UiHandler("cancelHead") 
	void onCancelHeadlineClick(ClickEvent e) {
		cancelHeadline();
	}
	
	@UiHandler("cancelIsti") 
	void onCancelIstiClick(ClickEvent e) {
		cancelInsti();
	}
	
	
	@UiHandler("saveHead")
	void onSaveHeadlineClick(ClickEvent e) {
		String toShare = escapeHtml(headlineBox.getText());
		if (toShare.equals("") || toShare.equals(HEADLINE_TEXT) || toShare.equals(HEADLINE_ERROR)) {
			headlineBox.setText(HEADLINE_ERROR);
		} else {
			currHeadLine = toShare;
			saveHead.setVisible(false);		
			cancelHead.setVisible(false);
			savingHeadline.setVisible(true);
			socialService.saveHeadline(currHeadLine, new AsyncCallback<Boolean>() {

				@Override
				public void onFailure(Throwable caught) {
					Window.alert("Sorry, an error occurred");
					cancelHeadline();	
					savingHeadline.setVisible(false);		
				}

				@Override
				public void onSuccess(Boolean result) {
					headlineLabel.setText(currHeadLine);
					editHeadline.setVisible(true);
					headlineLabel.getElement().getStyle().setOpacity(1.0);	
					headlineBox.setVisible(false);
					headlineLabel.setVisible(true);		
					savingHeadline.setVisible(false);		
				}
			});
			
		}
	}
	
	@UiHandler("saveIsti")
	void onSaveInstitutionClick(ClickEvent e) {
		String toShare = escapeHtml(institutionBox.getText());
		if (toShare.equals("") || toShare.equals(ISTI_TEXT) || toShare.equals(ISTI_ERROR)) {
			institutionBox.setText(ISTI_ERROR);
		} else {
			currInstitution = toShare;
			saveIsti.setVisible(false);		
			cancelIsti.setVisible(false);
			savingHeadline.setVisible(true);
			socialService.saveIsti(currInstitution, new AsyncCallback<Boolean>() {

				@Override
				public void onFailure(Throwable caught) {
					Window.alert("Sorry, an error occurred");
					cancelHeadline();	
					savingHeadline.setVisible(false);		
				}

				@Override
				public void onSuccess(Boolean result) {
					institutionLabel.setText(currInstitution);
					editIsti.setVisible(true);
					institutionLabel.getElement().getStyle().setOpacity(1.0);	
					institutionBox.setVisible(false);
					institutionLabel.setVisible(true);		
					savingHeadline.setVisible(false);		
				}
			});
			
		}
	}
	
	@UiHandler("messageButton")
	void onSendPrivateMessageClick(ClickEvent e) {
		final List<String> listToLogin = new ArrayList<String>();
		listToLogin.add(getUserToShowId() );
		GWT.runAsync(new RunAsyncCallback() {
			@Override
			public void onSuccess() {
				new MailForm(listToLogin);
			}
			public void onFailure(Throwable reason) {
				Window.alert("Could not load this component: " + reason.getMessage());
			}   
		});
	}
	
	private void cancelHeadline() {
		editHeadline.setVisible(true);
		saveHead.setVisible(false);		
		cancelHead.setVisible(false);	
		headlineBox.setVisible(false);
		headlineLabel.setVisible(true);
	}
	
	private void cancelInsti() {
		editIsti.setVisible(true);
		saveIsti.setVisible(false);		
		cancelIsti.setVisible(false);	
		institutionBox.setVisible(false);
		institutionLabel.setVisible(true);
	}
	
	
	/**
	 * check if it has to show just one feed
	 * @return
	 */
	private String getUserToShowId() {
		String encodedOid = Encoder.encode(GCubeSocialNetworking.USER_PROFILE_OID);
		if (Window.Location.getParameter(encodedOid) == null)
			return null;
		String encodedUserId = Window.Location.getParameter(encodedOid);
		return Encoder.decode(encodedUserId);
	}
	
	/**
	 * Escape an html string. Escaping data received from the client helps to
	 * prevent cross-site script vulnerabilities.
	 * 
	 * @param html the html string to escape
	 * @return the escaped string
	 */
	private String escapeHtml(String html) {
		if (html == null) {
			return null;
		}
		return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;")
				.replaceAll(">", "&gt;");
	}
}
