/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.job.taxonomy;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentPlugin;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.filters.DateFilter;
import com.extjs.gxt.ui.client.widget.grid.filters.Filter;
import com.extjs.gxt.ui.client.widget.grid.filters.GridFilters;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.gcube.portlets.user.speciesdiscovery.client.event.ReSubmitJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SaveJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.job.taxonomy.TaxonomyGridJob;
import org.gcube.portlets.user.speciesdiscovery.client.job.taxonomy.TaxonomyJobSpeciesProgressBar;
import org.gcube.portlets.user.speciesdiscovery.client.job.taxonomy.TaxonomyWindowInfoJobsSpecies;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.client.window.MessageBoxConfirm;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSource;
import org.gcube.portlets.user.speciesdiscovery.shared.DownloadState;
import org.gcube.portlets.user.speciesdiscovery.shared.JobTaxonomyModel;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchResultType;

public class TaxonomyGridJob
extends ContentPanel {
    private static final String REFRESH_LIST = "Refresh List";
    private static final String RE_SUBMIT = "Re-submit";
    private static final String SAVE = "Save";
    private static final String CANCEL = "Cancel";
    private static final String INFO = "Info";
    private ListStore<BaseModelData> store;
    private ToolBar toolBar = new ToolBar();
    private Grid<BaseModelData> grid;
    private HashMap<String, TaxonomyWindowInfoJobsSpecies> listWindowInfo = new HashMap();
    private EventBus eventBus;
    private Button buttonInfo;
    private Button buttonCancel;
    private Button buttonSave;
    private Button buttonReSubmit;
    private Button buttonRefreshList;
    private Menu menu = new Menu();

    public TaxonomyGridJob(EventBus eventBus) {
        this.eventBus = eventBus;
        ColumnConfig name = new ColumnConfig("Name", "Name", 220);
        ColumnConfig dataSources = new ColumnConfig("Data Source", "Data Source", 90);
        ColumnConfig progress = new ColumnConfig("Progress", "Progress", 250);
        ColumnConfig creationDate = new ColumnConfig("Start Time", "Start Time", 140);
        ColumnConfig endTime = new ColumnConfig("End Time", "End Time", 140);
        ColumnConfig elapsedTime = new ColumnConfig("Elapsed Time", "Elapsed Time HH:mm:ss", 140);
        ColumnConfig status = new ColumnConfig("Status", "Status", 80);
        ColumnModel cm = new ColumnModel(Arrays.asList(name, dataSources, progress, creationDate, endTime, elapsedTime, status));
        this.setBodyBorder(false);
        this.setHeaderVisible(false);
        this.setLayout((Layout)new FitLayout());
        GridFilters filters = new GridFilters();
        filters.setLocal(true);
        DateFilter dateFilterStart = new DateFilter("Start Time");
        DateFilter dateFilterEnd = new DateFilter("End Time");
        filters.addFilter((Filter)dateFilterStart);
        filters.addFilter((Filter)dateFilterEnd);
        this.store = new ListStore();
        this.grid = new Grid(this.store, cm);
        this.grid.setLoadMask(true);
        1 downloadStateRenderer = new /* Unavailable Anonymous Inner Class!! */;
        2 jobSpeciesRenderer = new /* Unavailable Anonymous Inner Class!! */;
        progress.setRenderer((GridCellRenderer)jobSpeciesRenderer);
        status.setRenderer((GridCellRenderer)downloadStateRenderer);
        this.grid.getView().setEmptyText("Empty");
        this.grid.getView().setShowDirtyCells(false);
        this.grid.getView().setShowInvalidCells(false);
        this.grid.setBorders(false);
        this.grid.setColumnLines(true);
        this.grid.addPlugin((ComponentPlugin)filters);
        this.grid.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        this.grid.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Component)this.grid);
        this.createGridToolBar();
        this.createMenuItemsOnGrid();
    }

    public void addJobIntoGrid(JobTaxonomyModel jobModel, TaxonomyJobSpeciesProgressBar jobProgressBar) {
        BaseModelData baseModelData = new BaseModelData();
        baseModelData.set("jobIdentifier", (Object)jobModel.getIdentifier());
        baseModelData.set("Name", (Object)jobModel.getName());
        baseModelData.set("Progress", (Object)jobProgressBar);
        baseModelData.set("Status", (Object)jobModel.getDownloadState().toString());
        baseModelData.set("Start Time", (Object)jobModel.getStartTime());
        baseModelData.set("End Time", (Object)jobModel.getEndTime());
        baseModelData.set("Elapsed Time", (Object)jobModel.getElapsedTime());
        baseModelData.set("Data Source", (Object)jobModel.getDataSource());
        baseModelData.set("Scientific Name", (Object)jobModel.getScientificName());
        baseModelData.set("Rank", (Object)jobModel.getRank());
        baseModelData.set(jobModel.getIdentifier(), (Object)jobModel);
        this.store.add((ModelData)baseModelData);
        this.updateJobInfo(jobModel);
    }

    private void updateJobInfo(JobTaxonomyModel jobModel) {
        TaxonomyWindowInfoJobsSpecies win = (TaxonomyWindowInfoJobsSpecies)this.listWindowInfo.get(jobModel.getIdentifier());
        if (win == null) {
            win = new TaxonomyWindowInfoJobsSpecies();
        }
        win.setWindowTitle("Job " + jobModel.getName() + " Status");
        win.updateListStore(jobModel);
        this.listWindowInfo.put(jobModel.getIdentifier(), win);
    }

    public void updateStatus(JobTaxonomyModel jobModel, TaxonomyJobSpeciesProgressBar jobProgressBar) {
        BaseModelData job = (BaseModelData)this.store.findModel("jobIdentifier", (Object)jobModel.getIdentifier());
        if (job != null) {
            job.set("Progress", (Object)jobProgressBar);
            job.set("Start Time", (Object)jobModel.getStartTime());
            job.set("Status", (Object)jobModel.getDownloadState().toString());
            job.set("End Time", (Object)jobModel.getEndTime());
            job.set("Elapsed Time", (Object)jobModel.getElapsedTime());
            job.set(jobModel.getIdentifier(), (Object)jobModel);
            this.updateJobInfo(jobModel);
            this.store.update((ModelData)job);
        }
    }

    public void removeSpeciesJobByIdentifier(String jobIdentifier) {
        BaseModelData job = (BaseModelData)this.store.findModel("jobIdentifier", (Object)jobIdentifier);
        if (job != null) {
            this.store.remove((ModelData)job);
        }
    }

    private void viewInfoJob() {
        BaseModelData baseModelData = (BaseModelData)this.grid.getSelectionModel().getSelectedItem();
        if (baseModelData != null) {
            TaxonomyWindowInfoJobsSpecies win = (TaxonomyWindowInfoJobsSpecies)this.listWindowInfo.get(baseModelData.get("jobIdentifier"));
            win.show();
        }
    }

    private void cancelJob() {
        BaseModelData baseModelData = (BaseModelData)this.grid.getSelectionModel().getSelectedItem();
        if (baseModelData != null) {
            String name = (String)baseModelData.get("Name");
            MessageBoxConfirm mbc = new MessageBoxConfirm("Confirm delete", "Are you sure you want to delete the job " + name + "?");
            mbc.getMessageBoxConfirm().addCallback((Listener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void saveJob() {
        BaseModelData baseModelData = (BaseModelData)this.grid.getSelectionModel().getSelectedItem();
        if (baseModelData != null) {
            String load = baseModelData.get("Status").toString();
            if (load.compareTo(DownloadState.COMPLETED.toString()) == 0 || load.compareTo(DownloadState.SAVED.toString()) == 0) {
                String jobIdentifier = (String)baseModelData.get("jobIdentifier");
                String scientificName = (String)baseModelData.get("Scientific Name");
                String dataSource = (String)baseModelData.get("Data Source");
                String rank = (String)baseModelData.get("Rank");
                JobTaxonomyModel jobModel = (JobTaxonomyModel)baseModelData.get(jobIdentifier);
                ArrayList<DataSource> dataSourceList = new ArrayList<DataSource>();
                dataSourceList.add(new DataSource(dataSource, dataSource));
                this.eventBus.fireEvent((GwtEvent)new SaveJobEvent(jobIdentifier, scientificName, dataSourceList, rank, SearchResultType.TAXONOMY_ITEM, jobModel));
            } else {
                String name = (String)baseModelData.get("Name");
                MessageBox.alert((String)"Alert", (String)("The job " + name + " " + " is not completed!"), null);
            }
        }
    }

    private void resubmitJob() {
        BaseModelData baseModelData = (BaseModelData)this.grid.getSelectionModel().getSelectedItem();
        if (baseModelData != null) {
            String load = baseModelData.get("Status").toString();
            if (load.compareTo(DownloadState.FAILED.toString()) == 0 || load.compareTo(DownloadState.COMPLETED.toString()) == 0 || load.compareTo(DownloadState.SAVED.toString()) == 0) {
                String jobIdentifier = (String)baseModelData.get("jobIdentifier");
                JobTaxonomyModel jobModel = (JobTaxonomyModel)baseModelData.get(jobIdentifier);
                this.eventBus.fireEvent((GwtEvent)new ReSubmitJobEvent(SearchResultType.TAXONOMY_ITEM, null, jobModel));
            } else {
                String name = (String)baseModelData.get("Name");
                MessageBox.alert((String)INFO, (String)("The job " + name + " " + "can no be re-submitted until it has completed!"), null);
            }
        }
    }

    private void createGridToolBar() {
        this.buttonInfo = new Button(INFO);
        this.buttonInfo.setScale(Style.ButtonScale.MEDIUM);
        this.buttonInfo.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getInfoIcon()));
        this.buttonInfo.setStyleAttribute("margin-left", "5px");
        this.buttonInfo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonCancel = new Button(CANCEL);
        this.buttonCancel.setScale(Style.ButtonScale.MEDIUM);
        this.buttonCancel.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getDelete()));
        this.buttonCancel.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonSave = new Button(SAVE);
        this.buttonSave.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSaveProducts()));
        this.buttonSave.setScale(Style.ButtonScale.MEDIUM);
        this.buttonSave.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonReSubmit = new Button(RE_SUBMIT);
        this.buttonReSubmit.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getReSubmit()));
        this.buttonReSubmit.setScale(Style.ButtonScale.MEDIUM);
        this.buttonReSubmit.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonRefreshList = new Button(REFRESH_LIST);
        this.buttonRefreshList.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getRefresh()));
        this.buttonRefreshList.setScale(Style.ButtonScale.MEDIUM);
        this.buttonRefreshList.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolBar.add((Component)this.buttonInfo);
        this.toolBar.add((Component)new SeparatorToolItem());
        this.toolBar.add((Component)this.buttonSave);
        this.toolBar.add((Component)new SeparatorToolItem());
        this.toolBar.add((Component)this.buttonCancel);
        this.toolBar.add((Component)new SeparatorToolItem());
        this.toolBar.add((Component)this.buttonReSubmit);
        this.toolBar.add((Component)new SeparatorToolItem());
        this.toolBar.add((Component)new FillToolItem());
        this.toolBar.add((Component)new SeparatorToolItem());
        this.toolBar.add((Component)this.buttonRefreshList);
        this.setTopComponent((Component)this.toolBar);
        this.enableButtonOnClick(false);
    }

    public void enableButtonOnClick(boolean bool) {
        this.buttonCancel.setEnabled(bool);
        this.buttonInfo.setEnabled(bool);
        this.buttonSave.setEnabled(bool);
        this.buttonReSubmit.setEnabled(bool);
    }

    public void resetStore() {
        this.store.removeAll();
    }

    public void createMenuItemsOnGrid() {
        MenuItem menuInfo = new MenuItem();
        menuInfo.setText(INFO);
        menuInfo.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getInfoIcon()));
        menuInfo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.menu.add((Component)menuInfo);
        MenuItem menuSave = new MenuItem();
        menuSave.setText(SAVE);
        menuSave.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSaveProducts()));
        menuSave.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.menu.add((Component)menuSave);
        MenuItem menuCancel = new MenuItem();
        menuCancel.setText(CANCEL);
        menuCancel.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getDelete()));
        menuCancel.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.menu.add((Component)menuCancel);
        MenuItem menuResubmit = new MenuItem();
        menuResubmit.setText(RE_SUBMIT);
        menuResubmit.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getReSubmit()));
        menuResubmit.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.menu.add((Component)menuResubmit);
        this.grid.setContextMenu(this.menu);
    }

    static /* synthetic */ void access$000(TaxonomyGridJob x0) {
        x0.viewInfoJob();
    }

    static /* synthetic */ void access$100(TaxonomyGridJob x0) {
        x0.cancelJob();
    }

    static /* synthetic */ void access$200(TaxonomyGridJob x0) {
        x0.saveJob();
    }

    static /* synthetic */ void access$300(TaxonomyGridJob x0) {
        x0.resubmitJob();
    }

    static /* synthetic */ EventBus access$400(TaxonomyGridJob x0) {
        return x0.eventBus;
    }
}

