/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.session;

import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.speciesdiscovery.server.session.Fetcher;
import org.gcube.portlets.user.speciesdiscovery.server.session.FetchingBuffer;
import org.gcube.portlets.user.speciesdiscovery.server.stream.Aggregator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.AggregatorIterator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.CloseableIterator;
import org.gcube.portlets.user.speciesdiscovery.shared.FetchingElement;

public class FetchingSession<T extends FetchingElement>
implements Closeable {
    protected Logger logger = Logger.getLogger(FetchingSession.class);
    protected FetchingBuffer<T> buffer;
    protected Fetcher<T> fetcher;
    protected Thread fetcherThread;
    protected CloseableIterator<T> source;
    protected AggregatorIterator<T> aggregatorIterator;

    public FetchingSession(CloseableIterator<T> source, FetchingBuffer<T> buffer) {
        this.source = source;
        this.buffer = buffer;
        this.fetcher = new Fetcher(source, buffer);
    }

    public void addAggregator(Aggregator<T, ?> aggregator) {
        if (this.aggregatorIterator == null) {
            this.setupAggregatorIterator();
        }
        this.aggregatorIterator.addAggregator(aggregator);
    }

    protected void setupAggregatorIterator() {
        this.aggregatorIterator = new AggregatorIterator(this.source);
        this.fetcher.setSource((CloseableIterator)this.aggregatorIterator);
    }

    public Aggregator<T, ?> getAggregator(String name) {
        if (this.aggregatorIterator != null) {
            return this.aggregatorIterator.getAggregator(name);
        }
        return null;
    }

    public void startFetching() {
        this.fetcherThread = new Thread((Runnable)this.fetcher);
        this.logger.trace((Object)"###fetcherThread start");
        this.fetcherThread.start();
    }

    @Override
    public void close() throws IOException {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isComplete() {
        return this.fetcher.isComplete();
    }

    public FetchingBuffer<T> getBuffer() throws Exception {
        this.logger.trace((Object)("fetcherThread is alive: " + this.fetcherThread.isAlive()));
        try {
            this.logger.trace((Object)("buffer size: " + this.buffer.size()));
        }
        catch (SQLException e) {
            this.logger.error((Object)("error in getBuffer: " + e));
        }
        return this.buffer;
    }

    public int getBufferSize() throws Exception {
        return this.buffer.size();
    }
}

