/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.shared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSource;
import org.gcube.portlets.user.speciesdiscovery.shared.DownloadState;
import org.gcube.portlets.user.speciesdiscovery.shared.OccurrencesSaveEnum;
import org.gcube.portlets.user.speciesdiscovery.shared.SaveFileFormat;

public class JobOccurrencesModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JOBINDENTIFIER = "jobIdentifier";
    public static final String JOBNAME = "Name";
    public static final String STARTTIME = "Start Time";
    public static final String PROGRESS = "Progress";
    public static final String ENDTIME = "End Time";
    public static final String ELAPSEDTIME = "Elapsed Time";
    public static final String DATASOURCESASSTRING = "Data Sources";
    public static final String SCIENTIFICNAME = "Scientific Name";
    public static final String PERCENTAGE = "Percentage";
    public static final String DESCRIPTION = "Description";
    public static final String STATUS = "Status";
    public static final String FILEFORMAT = "File format";
    public static final String CSVTYPE = "CSV type";
    public static final String BYDATASOURCE = "byDataSource";
    public static final String COMPLETEDENTRY = "Completed Entry";
    public static final String ITEMSNUMBER = "Number of items";
    private String scientificName;
    private String jobIdentifier;
    private String jobName;
    private DownloadState downloadState;
    protected Date startTime;
    protected Date endTime;
    protected String elapsedTime;
    private List<DataSource> dataSources;
    private String description;
    private float percentage;
    private int nodeCompleted;
    private int totalOccurrences;
    private SaveFileFormat fileFormat;
    private OccurrencesSaveEnum csvType;
    private boolean byDataSource;

    public JobOccurrencesModel() {
    }

    public JobOccurrencesModel(String jobIdentifier, String jobName) {
        this.setId(jobIdentifier);
        this.setJobName(jobName);
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public JobOccurrencesModel(String jobIdentifier, String jobName, String description, DownloadState state, String scientificName, List<DataSource> listDataSource, Date startTime, Date endTime, int nodeCompleted, int totalOccurrence) {
        this(jobIdentifier, jobName);
        this.setScientificName(scientificName);
        this.setStartTime(startTime);
        this.setState(state);
        this.setDataSources(listDataSource);
        this.setEndTime(endTime);
        this.setDescription(description);
        this.setNodeCompleted(nodeCompleted);
        this.setTotalOccurrences(totalOccurrence);
        this.setPercentage((float)(nodeCompleted * 100 / totalOccurrence));
    }

    public JobOccurrencesModel(String jobIdentifier, String jobName2, String scientificName2, List<DataSource> dataSourceList, SaveFileFormat fileFormat, OccurrencesSaveEnum csvType, boolean byDataSource, int totalOccurrence) {
        this(jobIdentifier, jobName2);
        this.setScientificName(scientificName2);
        this.setDataSources(dataSourceList);
        this.setFileFormat(fileFormat);
        this.setCsvType(csvType);
        this.setByDataSource(byDataSource);
        this.setTotalOccurrences(totalOccurrence);
    }

    public JobOccurrencesModel(String jobIdentifier, String jobName2, String scientificName2, List<DataSource> dataSourceList, SaveFileFormat fileFormat2, OccurrencesSaveEnum csvType, boolean byDataSource2) {
        this(jobIdentifier, jobName2);
        this.setScientificName(scientificName2);
        this.setDataSources(dataSourceList);
        this.setFileFormat(fileFormat2);
        this.setCsvType(csvType);
        this.setByDataSource(byDataSource2);
    }

    public void setScientificName(String scientificName) {
        this.scientificName = scientificName;
    }

    public void setId(String jobId) {
        this.jobIdentifier = jobId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getJobIdentifier() {
        return this.jobIdentifier;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getScientificName() {
        return this.scientificName;
    }

    public void setDataSources(List<DataSource> dataSources) {
        this.dataSources = dataSources;
    }

    public List<DataSource> getDataSources() {
        return this.dataSources;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setPercentage(float percentage) {
        this.percentage = percentage;
    }

    public float getPercentage() {
        return this.percentage;
    }

    public void setState(DownloadState state) {
        this.downloadState = state;
    }

    public DownloadState getDownloadState() {
        return this.downloadState;
    }

    public String getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(String elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public SaveFileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(SaveFileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public OccurrencesSaveEnum getCsvType() {
        return this.csvType;
    }

    public void setCsvType(OccurrencesSaveEnum csvType) {
        this.csvType = csvType;
    }

    public boolean isByDataSource() {
        return this.byDataSource;
    }

    public void setByDataSource(boolean byDataSource) {
        this.byDataSource = byDataSource;
    }

    public int getNodeCompleted() {
        return this.nodeCompleted;
    }

    public void setNodeCompleted(int nodeCompleted) {
        this.nodeCompleted = nodeCompleted;
    }

    public List<String> getDataSourcesNameAsString() {
        ArrayList<String> listDataSourceName = new ArrayList<String>();
        if (this.dataSources != null) {
            for (DataSource dataSource : this.dataSources) {
                listDataSourceName.add(dataSource.getName());
            }
        }
        return listDataSourceName;
    }

    public int getTotalOccurrences() {
        return this.totalOccurrences;
    }

    public void setTotalOccurrences(int totalOccurrences) {
        this.totalOccurrences = totalOccurrences;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JobOccurrencesModel [scientificName=");
        builder.append(this.scientificName);
        builder.append(", jobIdentifier=");
        builder.append(this.jobIdentifier);
        builder.append(", jobName=");
        builder.append(this.jobName);
        builder.append(", downloadState=");
        builder.append(this.downloadState);
        builder.append(", startTime=");
        builder.append(this.startTime);
        builder.append(", endTime=");
        builder.append(this.endTime);
        builder.append(", elapsedTime=");
        builder.append(this.elapsedTime);
        builder.append(", dataSources=");
        builder.append(this.dataSources);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", percentage=");
        builder.append(this.percentage);
        builder.append(", nodeCompleted=");
        builder.append(this.nodeCompleted);
        builder.append(", totalOccurrences=");
        builder.append(this.totalOccurrences);
        builder.append(", fileFormat=");
        builder.append(this.fileFormat);
        builder.append(", csvType=");
        builder.append(this.csvType);
        builder.append(", byDataSource=");
        builder.append(this.byDataSource);
        builder.append("]");
        return builder.toString();
    }
}

