/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.Classification;
import org.gcube.data.spd.client.proxies.Executor;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.client.proxies.Occurrence;
import org.gcube.data.spd.model.Coordinate;
import org.gcube.data.spd.model.OccurrencePoint;
import org.gcube.data.spd.model.Properties;
import org.gcube.data.spd.model.Property;
import org.gcube.data.spd.model.ResultElement;
import org.gcube.data.spd.model.TaxonomyItem;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.stubs.exceptions.InvalidIdentifierException;
import org.gcube.data.spd.stubs.types.CapabilityDescription;
import org.gcube.data.spd.stubs.types.PluginDescription;
import org.gcube.data.spd.stubs.types.PluginProperty;
import org.gcube.data.spd.stubs.types.RepositoryInfo;
import org.gcube.data.spd.stubs.types.Status;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.portlets.user.speciesdiscovery.server.service.QueryBuilder;
import org.gcube.portlets.user.speciesdiscovery.server.service.StreamIterator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.CloseableIterator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.IteratorPointInfo;
import org.gcube.portlets.user.speciesdiscovery.server.util.StorageUtil;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceCapability;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceModel;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceRepositoryInfo;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchFilters;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchType;
import org.gcube.portlets.user.speciesdiscovery.shared.SpeciesCapability;

public class SpeciesService {
    protected Logger logger = Logger.getLogger(SpeciesService.class);
    protected GCUBEScope scope;
    protected ASLSession session;
    protected Manager call;
    protected Occurrence occurrencesCall;
    protected Classification classificationCall;
    protected Executor executorCall;

    public SpeciesService(GCUBEScope scope, ASLSession session) throws Exception {
        this(scope);
        this.session = session;
    }

    public SpeciesService(GCUBEScope scope) throws Exception {
        this.scope = scope;
        ScopeProvider.instance.set(scope.toString());
        System.out.println("CALLING MANAGER ");
        this.call = (Manager)AbstractPlugin.manager().withTimeout(3, TimeUnit.MINUTES).build();
        this.executorCall = (Executor)AbstractPlugin.executor().withTimeout(3, TimeUnit.MINUTES).build();
        this.occurrencesCall = (Occurrence)AbstractPlugin.occurrence().withTimeout(3, TimeUnit.MINUTES).build();
        this.classificationCall = (Classification)AbstractPlugin.classification().withTimeout(3, TimeUnit.MINUTES).build();
    }

    public SpeciesService(GCUBEScope scope, boolean instanceOnlyOccurrence) throws Exception {
        this.scope = scope;
        if (instanceOnlyOccurrence) {
            ScopeProvider.instance.set(scope.toString());
            System.out.println("CALLING OCCURRENCE MANAGER ");
            this.occurrencesCall = (Occurrence)AbstractPlugin.occurrence().withTimeout(3, TimeUnit.MINUTES).build();
        }
    }

    public CloseableIterator<ResultElement> searchByFilters(String searchTerm, SearchType searchType, SearchFilters searchFilters) throws SearchServiceException {
        this.logger.trace((Object)("searchByFilters searchTerm: " + searchTerm + " usearchFilters: " + searchFilters));
        try {
            this.logger.trace((Object)"query building...");
            String query = QueryBuilder.buildQuery((String)searchTerm, (SearchType)searchType, (SearchFilters)searchFilters);
            this.logger.trace((Object)("query build - OK " + query));
            return this.searchByQuery(query);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public CloseableIterator<TaxonomyItem> retrieveTaxonomyById(Stream<String> streamIds) throws SearchServiceException {
        this.logger.trace((Object)"retrieveTaxonomyById...");
        try {
            ScopeProvider.instance.set(this.scope.toString());
            Stream stream = this.classificationCall.getTaxaByIds(streamIds);
            return new StreamIterator(stream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public CloseableIterator<TaxonomyItem> retrieveSynonymsById(String id) throws SearchServiceException {
        this.logger.trace((Object)"retrieveSynonymsById...");
        try {
            ScopeProvider.instance.set(this.scope.toString());
            Stream stream = this.classificationCall.getSynonymsById(id);
            return new StreamIterator(stream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public CloseableIterator<ResultElement> searchByQuery(String query) throws SearchServiceException {
        this.logger.trace((Object)("search by Query - query is: " + query));
        try {
            ScopeProvider.instance.set(this.scope.toString());
            this.logger.trace((Object)"call species service search...");
            Stream stream = this.call.search(query);
            return new StreamIterator(stream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public Stream<ResultElement> searchByQuery2(String query) throws SearchServiceException {
        this.logger.trace((Object)("searchByQuery query: " + query));
        try {
            ScopeProvider.instance.set(this.scope.toString());
            this.logger.trace((Object)"call species service search...");
            System.out.println("call species service search...");
            return this.call.search(query);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public List<DataSourceModel> getPlugins() throws SearchServiceException {
        this.logger.trace((Object)"getPlugins...");
        try {
            ArrayList<DataSourceModel> listDsModel = new ArrayList<DataSourceModel>();
            ScopeProvider.instance.set(this.scope.toString());
            List plugin = this.call.getPluginsDescription();
            if (plugin != null) {
                this.logger.trace((Object)("*****PluginDescription is NOT null - length: " + plugin.size()));
                for (int i = 0; i < plugin.size(); ++i) {
                    PluginDescription pluginDescription = (PluginDescription)plugin.get(i);
                    List listCapabilityDescription = pluginDescription.getCapabilities();
                    ArrayList<DataSourceCapability> listCapabilities = new ArrayList<DataSourceCapability>();
                    this.logger.trace((Object)("getCapabilities for..." + pluginDescription.getName()));
                    for (CapabilityDescription capabilityDescription : listCapabilityDescription) {
                        List properties = capabilityDescription.getProperties();
                        ArrayList listProperties = properties != null ? new ArrayList(properties) : new ArrayList();
                        ArrayList<SpeciesCapability> listPropertiesEnum = new ArrayList<SpeciesCapability>();
                        for (String property : listProperties) {
                            listPropertiesEnum.add(this.getFilterCapabilityFromProperties(property));
                        }
                        listCapabilities.add(new DataSourceCapability(this.getGxtCapabilityValueFromCapability(capabilityDescription.getName()), listPropertiesEnum));
                    }
                    RepositoryInfo rep = pluginDescription.getRepositoryInfo();
                    DataSourceRepositoryInfo dsInfo = new DataSourceRepositoryInfo();
                    if (rep != null) {
                        dsInfo.setLogoUrl(rep.getLogoUrl());
                        dsInfo.setPageUrl(rep.getReferencePageUrl());
                        dsInfo.setProperties(this.getPropertiesFromRepositoryInfoType(rep));
                        dsInfo.setDescription(rep.getDescription());
                        this.logger.trace((Object)("DataSourceRepositoryInfo :" + dsInfo));
                    }
                    listDsModel.add(new DataSourceModel(pluginDescription.getName(), pluginDescription.getName(), pluginDescription.getDescription(), listCapabilities, dsInfo));
                }
            } else {
                this.logger.trace((Object)"*****PluginDescription is null");
            }
            return listDsModel;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
            throw new SearchServiceException("loading the data sources");
        }
    }

    private Map<String, String> getPropertiesFromRepositoryInfoType(RepositoryInfo rep) {
        HashMap<String, String> mapProperties = new HashMap<String, String>();
        if (rep.getProperties() == null) {
            this.logger.trace((Object)"*****Properties From RepositoryInfoType is null");
            return mapProperties;
        }
        for (PluginProperty prop : rep.getProperties()) {
            mapProperties.put(prop.getKey(), prop.getValue());
        }
        return mapProperties;
    }

    private SpeciesCapability getFilterCapabilityFromProperties(String property) {
        if (property.compareTo(Properties.DateFrom.name()) == 0) {
            return SpeciesCapability.FROMDATE;
        }
        if (property.compareTo(Properties.DateTo.name()) == 0) {
            return SpeciesCapability.TODATE;
        }
        if (property.compareTo(Properties.CoordinateTo.name()) == 0) {
            return SpeciesCapability.UPPERBOUND;
        }
        if (property.compareTo(Properties.CoordinateFrom.name()) == 0) {
            return SpeciesCapability.LOWERBOUND;
        }
        return SpeciesCapability.UNKNOWN;
    }

    private SpeciesCapability getGxtCapabilityValueFromCapability(String capability) {
        if (capability.compareTo(Capabilities.Classification.name()) == 0) {
            return SpeciesCapability.TAXONOMYITEM;
        }
        if (capability.compareTo(Capabilities.Occurences.name()) == 0) {
            return SpeciesCapability.RESULTITEM;
        }
        if (capability.compareTo(Capabilities.NamesMapping.name()) == 0) {
            return SpeciesCapability.NAMESMAPPING;
        }
        if (capability.compareTo(Capabilities.Synonims.name()) == 0) {
            return SpeciesCapability.SYNONYMS;
        }
        return SpeciesCapability.UNKNOWN;
    }

    protected List<Property> createFilterProperties(SearchFilters searchFilters) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (searchFilters.getUpperBound() != null) {
            properties.add(new Property(Properties.CoordinateTo, (Object)this.convertCoordinate(searchFilters.getUpperBound())));
        }
        if (searchFilters.getLowerBound() != null) {
            properties.add(new Property(Properties.CoordinateFrom, (Object)this.convertCoordinate(searchFilters.getLowerBound())));
        }
        if (searchFilters.getFromDate() != null) {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTime(searchFilters.getFromDate());
            properties.add(new Property(Properties.DateFrom, (Object)fromDate));
        }
        if (searchFilters.getToDate() != null) {
            Calendar toDate = Calendar.getInstance();
            toDate.setTime(searchFilters.getToDate());
            properties.add(new Property(Properties.DateTo, (Object)toDate));
        }
        return properties;
    }

    protected Coordinate convertCoordinate(org.gcube.portlets.user.speciesdiscovery.shared.Coordinate coordinate) {
        return new Coordinate((double)coordinate.getLatitude(), (double)coordinate.getLongitude());
    }

    public CloseableIterator<OccurrencePoint> getOccurrencesByKeys(List<String> keys) throws SearchServiceException {
        try {
            Stream keysStream = Streams.convert(keys);
            ScopeProvider.instance.set(this.scope.toString());
            Stream stream = this.occurrencesCall.getByKeys(keysStream);
            return new StreamIterator(stream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public CloseableIterator<OccurrencePoint> getOccurrencesByIds(List<String> ids) throws SearchServiceException {
        try {
            Stream idsStream = Streams.convert(ids);
            ScopeProvider.instance.set(this.scope.toString());
            Stream stream = this.occurrencesCall.getByIds(idsStream);
            return new StreamIterator(stream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public String generateMapFromOccurrencePoints(IteratorPointInfo streamKey) throws SearchServiceException {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            return this.occurrencesCall.createLayer((Stream)streamKey);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public StreamIterator<TaxonomyItem> getTaxonChildrenByParentId(String parentId) throws Exception {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            Stream items = this.classificationCall.getTaxonChildrenById(parentId);
            return new StreamIterator(items);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error calling the Species Service: " + e.getMessage());
        }
    }

    public Status getTaxonomyJobById(String jobId) {
        ScopeProvider.instance.set(this.scope.toString());
        Status status = null;
        try {
            status = this.executorCall.getStatus(jobId);
        }
        catch (InvalidIdentifierException e) {
            this.logger.error((Object)"Error on service for get job by Id - InvalidIdentifierException");
            status = null;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error on service for get job by Id: " + e.getMessage()), (Throwable)e);
            status = null;
        }
        return status;
    }

    public InputStream getTaxonomyJobFileById(String jobIdentifier) throws Exception {
        InputStream is = null;
        ScopeProvider.instance.set(this.scope.toString());
        try {
            String url = this.executorCall.getResultLink(jobIdentifier);
            this.logger.trace((Object)("URL returned by species service is: " + url));
            is = StorageUtil.getInputStreamByStorageClient((String)url);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error saving file: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error saving file: " + e.getMessage());
        }
        return is;
    }

    public String createTaxonomyJobForDWCAByChildren(String taxonomyId) throws Exception {
        ScopeProvider.instance.set(this.scope.toString());
        try {
            return this.executorCall.createDwCAByChildren(taxonomyId);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in createTaxonomyJob: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in createTaxonomyJob: " + e.getMessage());
        }
    }

    public String createTaxonomyJobForDWCAByIds(List<String> ids) throws Exception {
        ScopeProvider.instance.set(this.scope.toString());
        try {
            Stream keysStream = Streams.convert(ids);
            return this.executorCall.createDwCAByIds(keysStream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in createTaxonomyJobForDWCA: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in createTaxonomyJobForDWCA: " + e.getMessage());
        }
    }

    public void cancelTaxonomyJobById(String jobIdentifier) {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            this.executorCall.removeJob(jobIdentifier);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error on service for remove job: " + e.getMessage()), (Throwable)e);
        }
    }

    public Status getOccurrenceJobById(String jobId) {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            return this.executorCall.getStatus(jobId);
        }
        catch (InvalidIdentifierException e) {
            this.logger.error((Object)"Error on service for get job by Id - InvalidIdentifierException");
            return null;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error on service for get job by Id: " + e.getMessage()));
            return null;
        }
    }

    public String createOccurrenceCSVJob(Stream<String> streamKey) throws Exception {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            return this.executorCall.createCSV(streamKey);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in createOccurrenceCSVJob: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in createOccurrenceCSVJob: " + e.getMessage());
        }
    }

    public String createOccurrenceDARWINCOREJob(Stream<String> streamKey) throws Exception {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            return this.executorCall.createDarwincoreFromOccurrenceKeys(streamKey);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in createOccurrenceDARWINCOREJob: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in createOccurrenceDARWINCOREJob: " + e.getMessage());
        }
    }

    public String createOccurrenceCSVOpenModellerJob(Stream<String> streamKey) throws Exception {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            return this.executorCall.createCSVforOM(streamKey);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in createOccurrenceCSVOpenModellerJob: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in createOccurrenceCSVOpenModellerJob: " + e.getMessage());
        }
    }

    public void cancelOccurrenceJobById(String jobIdentifier) {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            this.executorCall.removeJob(jobIdentifier);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error on service for remove job: " + e.getMessage()), (Throwable)e);
        }
    }

    public InputStream getOccurrenceJobFileById(String jobIdentifier) throws Exception {
        InputStream is = null;
        ScopeProvider.instance.set(this.scope.toString());
        try {
            String url = this.executorCall.getResultLink(jobIdentifier);
            this.logger.trace((Object)("URL returned by species service is: " + url));
            is = StorageUtil.getInputStreamByStorageClient((String)url);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error saving file: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error saving file: " + e.getMessage());
        }
        return is;
    }
}

