/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.util;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.log4j.Logger;
import org.gcube.dataaccess.spql.SPQLLexer;
import org.gcube.dataaccess.spql.SPQLParser;
import org.gcube.dataaccess.spql.model.ParsingResult;
import org.gcube.dataaccess.spql.model.ReturnType;
import org.gcube.portlets.user.speciesdiscovery.server.util.QueryUtil;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchFilters;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchResultType;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.SpeciesCapability;

public class QueryUtil {
    protected static Logger logger = Logger.getLogger(QueryUtil.class);

    public static SearchResultType getQueryResultType(String query) throws SearchServiceException {
        try {
            SPQLLexer lexer = new SPQLLexer((CharStream)new ANTLRStringStream(query));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SPQLParser parser = new SPQLParser((TokenStream)tokens);
            ParsingResult result = parser.query();
            ReturnType type = result.getReturnExpression().getType();
            if (type == null) {
                return SearchResultType.SPECIES_PRODUCT;
            }
            switch (1.$SwitchMap$org$gcube$dataaccess$spql$model$ReturnType[type.ordinal()]) {
                case 1: {
                    return SearchResultType.SPECIES_PRODUCT;
                }
                case 2: {
                    return SearchResultType.OCCURRENCE_POINT;
                }
                case 3: {
                    return SearchResultType.TAXONOMY_ITEM;
                }
            }
            logger.error((Object)("Unknow return type: " + type));
        }
        catch (RecognitionException e) {
            logger.warn((Object)"Error parsing the user query", (Throwable)e);
            throw new SearchServiceException("Wrong query: " + e.getMessage());
        }
        return null;
    }

    public static SearchResultType getResultType(SearchFilters searchFilters) {
        switch (1.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SpeciesCapability[searchFilters.getResultType().ordinal()]) {
            case 1: {
                return SearchResultType.SPECIES_PRODUCT;
            }
            case 2: {
                return SearchResultType.TAXONOMY_ITEM;
            }
        }
        logger.error((Object)("Unknow return type: " + searchFilters.getResultType()));
        return null;
    }

    public static SpeciesCapability getResultType(SearchResultType resultType) {
        switch (1.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SearchResultType[resultType.ordinal()]) {
            case 1: {
                return SpeciesCapability.RESULTITEM;
            }
            case 2: {
                return SpeciesCapability.OCCURRENCESPOINTS;
            }
            case 3: {
                return SpeciesCapability.TAXONOMYITEM;
            }
        }
        return null;
    }
}

