/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.util.stream;

import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Collections;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.SpeciesDiscovery;
import org.gcube.portlets.user.speciesdiscovery.client.util.OccurencesGridFields;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.DataSource;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.StreamState;
import org.gcube.portlets.user.speciesdiscovery.shared.ItemParameter;
import org.gcube.portlets.user.speciesdiscovery.shared.Occurrence;
import org.gcube.portlets.user.speciesdiscovery.shared.filter.ResultFilter;

public class OccurrencesDataSource
implements DataSource {
    private int count;

    public void getStreamState(AsyncCallback<StreamState> callback) {
        callback.onSuccess((Object)new StreamState(this.count, true, false));
    }

    public void getData(int start, int limit, ResultFilter activeFiltersObject, AsyncCallback<List<ModelData>> callback) {
        SpeciesDiscovery.taxonomySearchService.getOccurrencesBatch(start, limit, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected BaseModelData convertToData(Occurrence occurrence) {
        BaseModelData data = new BaseModelData();
        String author = "";
        String lsid = "";
        String credits = "";
        String propertiesHtml = "";
        if (occurrence.getAuthor() != null) {
            author = occurrence.getAuthor();
        }
        if (occurrence.getLsid() != null) {
            lsid = occurrence.getLsid();
        }
        if (occurrence.getCredits() != null) {
            credits = occurrence.getCredits();
        }
        if (occurrence.getProperties() != null) {
            List listProperties = occurrence.getProperties();
            Collections.sort(listProperties, ItemParameter.COMPARATOR);
            propertiesHtml = propertiesHtml + "<table class=\"parameters\">";
            for (ItemParameter itemParameter : listProperties) {
                propertiesHtml = propertiesHtml + "<tr>\t<td class=\"title\">" + itemParameter.getKey() + "</td>" + "\t<td>" + itemParameter.getValue() + "</td>" + "</tr>";
            }
            propertiesHtml = propertiesHtml + "</table>";
        }
        data.set(OccurencesGridFields.INSTITUTION_CODE.getId(), (Object)occurrence.getInstitutionCode());
        data.set(OccurencesGridFields.COLLECTION_CODE.getId(), (Object)occurrence.getCollectionCode());
        data.set(OccurencesGridFields.CATALOGUE_NUMBER.getId(), (Object)occurrence.getCatalogueNumber());
        data.set(OccurencesGridFields.DATASET.getId(), (Object)occurrence.getDataSet());
        data.set(OccurencesGridFields.DATAPROVIDER.getId(), (Object)occurrence.getDataProvider());
        data.set(OccurencesGridFields.DATASOURCE.getId(), (Object)occurrence.getDataSource());
        data.set(OccurencesGridFields.AUTHOR.getId(), (Object)author);
        data.set(OccurencesGridFields.CREDITS.getId(), (Object)credits);
        data.set(OccurencesGridFields.PROPERTIES.getId(), (Object)propertiesHtml);
        data.set(OccurencesGridFields.RECORDED_BY.getId(), (Object)occurrence.getRecordedBy());
        data.set(OccurencesGridFields.EVENT_DATE.getId(), (Object)occurrence.getEventDate());
        data.set(OccurencesGridFields.MODIFIED.getId(), (Object)occurrence.getModified());
        data.set(OccurencesGridFields.SCIENTIFIC_NAME.getId(), (Object)occurrence.getScientificName());
        data.set(OccurencesGridFields.KINGDOM.getId(), (Object)occurrence.getKingdom());
        data.set(OccurencesGridFields.FAMILY.getId(), (Object)occurrence.getFamily());
        data.set(OccurencesGridFields.LOCALITY.getId(), (Object)occurrence.getLocality());
        data.set(OccurencesGridFields.COUNTRY.getId(), (Object)occurrence.getCountry());
        data.set(OccurencesGridFields.CITATION.getId(), (Object)occurrence.getCitation());
        data.set(OccurencesGridFields.DECIMAL_LATITUDE.getId(), (Object)occurrence.getDecimalLatitude());
        data.set(OccurencesGridFields.DECIMAL_LONGITUDE.getId(), (Object)occurrence.getDecimalLongitude());
        data.set(OccurencesGridFields.COORDINATE_UNCERTAINTY_IN_METERS.getId(), (Object)occurrence.getCoordinateUncertaintyInMeters());
        data.set(OccurencesGridFields.MAX_DEPTH.getId(), (Object)occurrence.getMaxDepth());
        data.set(OccurencesGridFields.MIN_DEPTH.getId(), (Object)occurrence.getMinDepth());
        data.set(OccurencesGridFields.BASIS_OF_RECORD.getId(), (Object)occurrence.getBasisOfRecord());
        return data;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getInfo() {
        return "OccurrencesDataSource";
    }
}

