/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.job;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.spd.stubs.types.Status;
import org.gcube.data.streams.Stream;
import org.gcube.portlets.user.speciesdiscovery.server.job.KeyStringList;
import org.gcube.portlets.user.speciesdiscovery.server.job.OccurrenceJobUtil;
import org.gcube.portlets.user.speciesdiscovery.server.job.OccurrenceKeys;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.DaoSession;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.OccurrenceJobPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.ResultRowPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.service.SpeciesService;
import org.gcube.portlets.user.speciesdiscovery.server.session.FetchingSession;
import org.gcube.portlets.user.speciesdiscovery.server.session.SelectableFetchingBuffer;
import org.gcube.portlets.user.speciesdiscovery.server.stream.StreamExtend;
import org.gcube.portlets.user.speciesdiscovery.server.util.DateUtil;
import org.gcube.portlets.user.speciesdiscovery.server.util.XStreamUtil;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSource;
import org.gcube.portlets.user.speciesdiscovery.shared.DownloadState;
import org.gcube.portlets.user.speciesdiscovery.shared.JobOccurrencesModel;
import org.gcube.portlets.user.speciesdiscovery.shared.OccurrencesJob;
import org.gcube.portlets.user.speciesdiscovery.shared.OccurrencesSaveEnum;
import org.gcube.portlets.user.speciesdiscovery.shared.ResultRow;
import org.gcube.portlets.user.speciesdiscovery.shared.SaveFileFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class OccurrenceJobUtil {
    public static final String COMPLETED = "COMPLETED";
    public static final String FAILED = "FAILED";
    public static final String RUNNING = "RUNNING";
    public static final String PENDING = "PENDING";
    private static final String ALIASKEY = "key";
    protected static Logger logger = Logger.getLogger(OccurrenceJobUtil.class);

    public static JobOccurrencesModel convertJob(OccurrencesJob job, Status statusResponse, OccurrenceJobPersistence occurrencesJobDao) {
        DownloadState downloadState = null;
        long endTime = 0L;
        String status = statusResponse.getStatus();
        downloadState = OccurrenceJobUtil.getDownloadState((String)status);
        logger.trace((Object)("jobId: " + job.getId() + " download state: " + downloadState));
        if (downloadState == null) {
            return null;
        }
        long startTime = job.getStartTime();
        Date start = DateUtil.millisecondsToDate((long)startTime);
        int completedEntry = 0;
        if (statusResponse.getCompletedEntries() > 0) {
            completedEntry = statusResponse.getCompletedEntries();
        }
        boolean changeStatus = false;
        if (downloadState.equals((Object)DownloadState.COMPLETED) && job.getState().compareTo(DownloadState.SAVED.toString()) == 0) {
            downloadState = DownloadState.SAVED;
            changeStatus = true;
        }
        JobOccurrencesModel jobOccurrenceModel = new JobOccurrencesModel(job.getId(), job.getName(), job.getDescription(), downloadState, job.getScientificName(), job.getDataSources(), start, null, completedEntry, job.getExpectedOccurrence());
        try {
            boolean changeEndTime = false;
            if ((downloadState.equals((Object)DownloadState.FAILED) || downloadState.equals((Object)DownloadState.COMPLETED)) && job.getEndTime() == 0L) {
                logger.trace((Object)("UPDATE end time first time only - " + downloadState));
                endTime = Calendar.getInstance().getTimeInMillis();
                job.setEndTime(endTime);
                changeEndTime = true;
            }
            if (changeStatus || changeEndTime) {
                job.setState(downloadState.toString());
                occurrencesJobDao.update((Object)job);
            }
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred on update the  occurrencesJobDao ", (Throwable)e);
        }
        endTime = job.getEndTime();
        long elapsedTime = 0L;
        if (endTime != 0L) {
            Date end = DateUtil.millisecondsToDate((long)endTime);
            jobOccurrenceModel.setEndTime(end);
            elapsedTime = endTime;
        } else {
            elapsedTime = Calendar.getInstance().getTimeInMillis();
        }
        jobOccurrenceModel.setElapsedTime(DateUtil.getDifference((long)startTime, (long)elapsedTime));
        jobOccurrenceModel.setFileFormat(OccurrenceJobUtil.converFileFormat((String)job.getFileFormat()));
        jobOccurrenceModel.setCsvType(OccurrenceJobUtil.convertCsvType((String)job.getCsvType()));
        jobOccurrenceModel.setByDataSource(job.isByDataSource());
        return jobOccurrenceModel;
    }

    public static DownloadState getDownloadState(String status) {
        if (status != null) {
            if (status.compareToIgnoreCase("PENDING") == 0) {
                return DownloadState.PENDING;
            }
            if (status.compareToIgnoreCase("RUNNING") == 0) {
                return DownloadState.ONGOING;
            }
            if (status.compareToIgnoreCase("FAILED") == 0) {
                return DownloadState.FAILED;
            }
            if (status.compareToIgnoreCase("COMPLETED") == 0) {
                return DownloadState.COMPLETED;
            }
        }
        return null;
    }

    public static OccurrencesSaveEnum convertCsvType(String csvType) {
        if (csvType != null) {
            if (csvType.compareToIgnoreCase(OccurrencesSaveEnum.STANDARD.toString()) == 0) {
                return OccurrencesSaveEnum.STANDARD;
            }
            if (csvType.compareToIgnoreCase(OccurrencesSaveEnum.OPENMODELLER.toString()) == 0) {
                return OccurrencesSaveEnum.OPENMODELLER;
            }
        }
        return null;
    }

    public static SaveFileFormat converFileFormat(String fileFormat) {
        if (fileFormat != null) {
            if (fileFormat.compareToIgnoreCase(SaveFileFormat.CSV.toString()) == 0) {
                return SaveFileFormat.CSV;
            }
            if (fileFormat.compareToIgnoreCase(SaveFileFormat.DARWIN_CORE.toString()) == 0) {
                return SaveFileFormat.DARWIN_CORE;
            }
        }
        return null;
    }

    public static int deleteOccurrenceJobById(String jobIdentifier, OccurrenceJobPersistence occurrencesJobDao) {
        logger.trace((Object)("Delete occurrence job id: " + jobIdentifier));
        try {
            int removed = occurrencesJobDao.deleteItemByIdField(jobIdentifier);
            return 1;
        }
        catch (Exception e) {
            logger.error((Object)("An error occured deleteOccurrenceJobById  jobId: " + jobIdentifier + " exception: " + e), (Throwable)e);
            logger.trace((Object)("job not exists : " + jobIdentifier));
            return 0;
        }
    }

    public static int changeStatusOccurrenceJobById(String jobIdentifier, DownloadState state, OccurrenceJobPersistence occurrencesJobDao) {
        logger.trace((Object)("Change status occurrence job id: " + jobIdentifier));
        int result = 0;
        try {
            CriteriaBuilder queryBuilder = occurrencesJobDao.getCriteriaBuilder();
            CriteriaQuery cq = queryBuilder.createQuery();
            Predicate pr1 = queryBuilder.equal((Expression)occurrencesJobDao.rootFrom(cq).get("id"), (Object)jobIdentifier);
            cq.where((Expression)pr1);
            Iterator iterator = occurrencesJobDao.executeCriteriaQuery(cq).iterator();
            if (!iterator.hasNext()) {
                return 0;
            }
            OccurrencesJob job = (OccurrencesJob)iterator.next();
            job.setState(state.toString());
            occurrencesJobDao.update((Object)job);
        }
        catch (Exception e) {
            logger.error((Object)("An error occured in change status  jobId: " + jobIdentifier + " exception: " + e), (Throwable)e);
        }
        return result;
    }

    public static List<String> getListOfSelectedKey(FetchingSession<ResultRow> searchSession) throws Exception {
        List selectedRows = ((SelectableFetchingBuffer)searchSession.getBuffer()).getSelected();
        logger.trace((Object)("found " + selectedRows.size() + " selected rows"));
        int count = 0;
        ArrayList<String> keys = new ArrayList<String>(selectedRows.size());
        for (ResultRow row : selectedRows) {
            if (row.getOccurencesKey() == null || row.getOccurencesKey().length() <= 0) continue;
            keys.add(row.getOccurencesKey());
            count += row.getOccurencesCount();
        }
        logger.trace((Object)("found " + count + " occurrence points"));
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OccurrenceKeys getListOfSelectedKeyByDataSource(String dataSource, ASLSession session) {
        logger.trace((Object)"getListOfSelectedKeyByDataSource...");
        OccurrenceKeys occurrenceKeys = new OccurrenceKeys();
        ArrayList<String> keys = new ArrayList<String>();
        Iterator resulRowIt = null;
        int count = 0;
        try {
            logger.trace((Object)("datasource name: " + dataSource));
            ResultRowPersistence resultRowDao = DaoSession.getResultRowDAO((ASLSession)session);
            EntityManager em = resultRowDao.createNewManager();
            try {
                Query query = em.createQuery("select t from ResultRow t where t.dataSourceName = '" + dataSource + "' AND t." + "selected" + " = true");
                resulRowIt = query.getResultList().iterator();
            }
            catch (Exception e) {
                logger.error((Object)("Error in update: " + e.getMessage()), (Throwable)e);
                OccurrenceKeys occurrenceKeys2 = null;
                return occurrenceKeys2;
            }
            finally {
                em.close();
            }
            while (resulRowIt.hasNext()) {
                ResultRow row = (ResultRow)resulRowIt.next();
                if (row.getOccurencesKey() == null || row.getOccurencesKey().length() <= 0) continue;
                keys.add(row.getOccurencesKey());
                count += row.getOccurencesCount();
            }
            occurrenceKeys.setListKey(keys);
            occurrenceKeys.setTotalOccurrence(count);
        }
        catch (Exception e) {
            logger.error((Object)("error in getListOfSelectedKeyByDataSource " + e));
        }
        logger.trace((Object)("found " + count + " occurrence points"));
        return occurrenceKeys;
    }

    public static JobOccurrencesModel createOccurrenceJobOnServiceByKeys(JobOccurrencesModel jobModel, SpeciesService taxonomyService, OccurrenceJobPersistence occurrencesJobDao, List<String> keys, List<DataSource> dataSources, SaveFileFormat saveFileFormat, OccurrencesSaveEnum csvType, int expectedOccurrence) {
        String serviceJobId = null;
        StreamExtend streamKeys = new StreamExtend(keys.iterator());
        String csvTypeString = null;
        try {
            switch (1.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SaveFileFormat[saveFileFormat.ordinal()]) {
                case 1: {
                    if (csvType.equals((Object)OccurrencesSaveEnum.STANDARD)) {
                        serviceJobId = taxonomyService.createOccurrenceCSVJob((Stream)streamKeys);
                    } else if (csvType.equals((Object)OccurrencesSaveEnum.OPENMODELLER)) {
                        serviceJobId = taxonomyService.createOccurrenceCSVOpenModellerJob((Stream)streamKeys);
                    }
                    if (jobModel.getCsvType() != null) {
                        csvTypeString = jobModel.getCsvType().toString();
                    }
                    break;
                }
                case 2: {
                    serviceJobId = taxonomyService.createOccurrenceDARWINCOREJob((Stream)streamKeys);
                    csvTypeString = "";
                    break;
                }
                default: {
                    serviceJobId = taxonomyService.createOccurrenceCSVJob((Stream)streamKeys);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"An error occured in create new occurrences job on server ", (Throwable)e);
            return null;
        }
        long startTimeInMillis = Calendar.getInstance().getTimeInMillis();
        try {
            OccurrencesJob occurrenceJob = new OccurrencesJob(serviceJobId, jobModel.getJobName(), jobModel.getDescription(), jobModel.getScientificName(), dataSources, DownloadState.PENDING.toString(), "", startTimeInMillis, 0L, jobModel.getFileFormat().toString(), csvTypeString, jobModel.isByDataSource(), OccurrenceJobUtil.convertListKeyIntoStoreXMLString(keys), expectedOccurrence);
            occurrencesJobDao.insert((Object)occurrenceJob);
            Date start = DateUtil.millisecondsToDate((long)startTimeInMillis);
            jobModel.setStartTime(start);
            jobModel.setId(serviceJobId);
            jobModel.setState(DownloadState.PENDING);
            jobModel.setEndTime(null);
        }
        catch (Exception e) {
            logger.error((Object)("An error occured in create new occurrences job on dao object " + e), (Throwable)e);
        }
        return jobModel;
    }

    public static String convertListKeyIntoStoreXMLString(List<String> keys) {
        String storeKeys = "";
        KeyStringList keyStringList = new KeyStringList();
        XStreamUtil xstreamUtil = new XStreamUtil("key", KeyStringList.class);
        for (String key : keys) {
            System.out.println("key :" + key);
            keyStringList.addKey(key);
        }
        storeKeys = xstreamUtil.toXML((Object)keyStringList);
        return storeKeys;
    }

    public static List<String> revertListKeyFromStoredXMLString(String storedKeysAsXml) {
        ArrayList<String> listKey = new ArrayList<String>();
        XStreamUtil xstreamUtil = new XStreamUtil("key", KeyStringList.class);
        KeyStringList keyStringList = (KeyStringList)xstreamUtil.fromXML(storedKeysAsXml);
        for (String key : keyStringList.getListKeys()) {
            listKey.add(key);
        }
        return listKey;
    }
}

