/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.gcube.data.spd.model.Coordinate;
import org.gcube.data.spd.model.Properties;
import org.gcube.data.spd.model.Property;
import org.gcube.portlets.user.speciesdiscovery.server.service.QueryBuilder;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceModel;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchFilters;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchType;

/*
 * Exception performing whole class analysis ignored.
 */
public class QueryBuilder {
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("d/MM/yyyy");

    public static String buildQuery(String searchTerm, SearchType searchType, SearchFilters searchFilters) {
        List properties;
        StringBuilder query = new StringBuilder();
        query.append('\'');
        query.append(searchTerm);
        query.append('\'');
        switch (1.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SearchType[searchType.ordinal()]) {
            case 1: {
                query.append(" as ScientificName ");
                break;
            }
            case 2: {
                query.append(" as CommonName ");
            }
        }
        if (searchFilters.getListDataSources() != null && searchFilters.getListDataSources().size() > 0) {
            query.append(" in ");
            Iterator dsIterator = searchFilters.getListDataSources().iterator();
            while (dsIterator.hasNext()) {
                DataSourceModel ds = (DataSourceModel)dsIterator.next();
                query.append(" ");
                query.append(ds.getId());
                if (dsIterator.hasNext()) {
                    query.append(", ");
                    continue;
                }
                query.append(" ");
            }
        }
        if ((properties = QueryBuilder.createFilterProperties((SearchFilters)searchFilters)).size() > 0) {
            query.append(" where ");
            Iterator pIterator = properties.iterator();
            while (pIterator.hasNext()) {
                Property property = (Property)pIterator.next();
                String statement = QueryBuilder.getQueryStatementFromProperty((Property)property);
                query.append(statement);
                if (pIterator.hasNext()) {
                    query.append(" AND ");
                    continue;
                }
                query.append(" ");
            }
        }
        query.append(" return ");
        if (searchFilters.getResultType() != null) {
            switch (1.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SpeciesCapability[searchFilters.getResultType().ordinal()]) {
                case 1: {
                    query.append("* having Occurrence");
                    break;
                }
                case 2: {
                    query.append("Taxon");
                }
            }
        } else {
            query.append("* having Occurrence");
        }
        return query.toString();
    }

    protected static String getQueryStatementFromProperty(Property property) {
        String statement = null;
        Properties prop = property.getProp();
        if (prop.equals((Object)Properties.CoordinateTo)) {
            Coordinate coordinate = (Coordinate)property.getValue();
            statement = "lowerBound IS " + coordinate.getLatitude() + " , " + coordinate.getLongitude();
        } else if (prop.equals((Object)Properties.CoordinateFrom)) {
            Coordinate coordinate = (Coordinate)property.getValue();
            statement = "upperBound IS " + coordinate.getLatitude() + " , " + coordinate.getLongitude();
        } else if (prop.equals((Object)Properties.DateFrom)) {
            Calendar calendar = (Calendar)property.getValue();
            statement = "fromDate IS " + DATE_FORMAT.format(calendar.getTime());
        } else if (prop.equals((Object)Properties.DateTo)) {
            Calendar calendar = (Calendar)property.getValue();
            statement = "toDate IS " + DATE_FORMAT.format(calendar.getTime());
        }
        return statement;
    }

    protected static List<Property> createFilterProperties(SearchFilters searchFilters) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (searchFilters.getUpperBound() != null) {
            properties.add(new Property(Properties.CoordinateTo, (Object)QueryBuilder.convert((org.gcube.portlets.user.speciesdiscovery.shared.Coordinate)searchFilters.getUpperBound())));
        }
        if (searchFilters.getLowerBound() != null) {
            properties.add(new Property(Properties.CoordinateFrom, (Object)QueryBuilder.convert((org.gcube.portlets.user.speciesdiscovery.shared.Coordinate)searchFilters.getLowerBound())));
        }
        if (searchFilters.getFromDate() != null) {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTime(searchFilters.getFromDate());
            properties.add(new Property(Properties.DateFrom, (Object)fromDate));
        }
        if (searchFilters.getToDate() != null) {
            Calendar toDate = Calendar.getInstance();
            toDate.setTime(searchFilters.getToDate());
            properties.add(new Property(Properties.DateTo, (Object)toDate));
        }
        return properties;
    }

    protected static Coordinate convert(org.gcube.portlets.user.speciesdiscovery.shared.Coordinate coordinate) {
        return new Coordinate((double)coordinate.getLatitude(), (double)coordinate.getLongitude());
    }
}

