/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.portlets.user.speciesdiscovery.client.util.SpeciesGridFields;
import org.gcube.portlets.user.speciesdiscovery.server.asl.SessionUtil;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.ResultRowPersistence;
import org.gcube.portlets.user.speciesdiscovery.shared.CommonName;
import org.gcube.portlets.user.speciesdiscovery.shared.ItemParameter;
import org.gcube.portlets.user.speciesdiscovery.shared.ResultRow;
import org.gcube.portlets.user.speciesdiscovery.shared.Taxon;
import org.gcube.portlets.user.speciesdiscovery.shared.util.NormalizeString;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResultRowTable
extends HttpServlet {
    public static final String TEXT_HTML = "text/html; charset=UTF-8";
    protected static final String UTF_8 = "UTF-8";
    private static final long serialVersionUID = -9006347088111602996L;
    protected Logger logger = Logger.getLogger(ResultRowTable.class);
    public static final String DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">";
    public static final String HTML = "<HTML>";
    public static final String HTMLCLOSE = "</HTML>";
    public static final String HEAD = "<HEAD>";
    public static final String HEADCLOSE = "</HEAD>";
    public static final String TITLE = "<TITLE>";
    public static final String TITLECLOSE = "</TITLE>";
    public static final String BODY = "<BODY>";
    public static final String BODYCLOSE = "</BODY>";

    public static String headWithTitle(String title) {
        return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<HTML>\n<HEAD>\n<TITLE>" + title + "</TITLE>" + "\n" + "</HEAD>" + "\n";
    }

    protected ASLSession getASLSession(HttpServletRequest req) {
        return SessionUtil.getAslSession((HttpSession)req.getSession());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String resultServiceRowID = "";
        resp.setContentType("text/html; charset=UTF-8");
        PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)resp.getOutputStream(), "UTF-8"), true);
        out.println(ResultRowTable.headWithTitle((String)""));
        out.println("<BODY>");
        try {
            resultServiceRowID = req.getParameter("oid");
            if (resultServiceRowID == null || resultServiceRowID.isEmpty()) {
                out.println(this.error("Parameter oid not found"));
            } else {
                this.logger.trace((Object)("found oid " + resultServiceRowID));
                try {
                    ResultRowPersistence persistence = SessionUtil.getCurrentEJBResultRow((ASLSession)this.getASLSession(req));
                    if (persistence == null) {
                        this.logger.trace((Object)"ResultRowPersistence not found in database");
                        out.println(this.error("Row id not found in database"));
                        out.close();
                        return;
                    }
                    CriteriaBuilder queryBuilder = persistence.getCriteriaBuilder();
                    CriteriaQuery cq = queryBuilder.createQuery();
                    Predicate pr1 = queryBuilder.equal((Expression)persistence.rootFrom(cq).get("serviceIdField"), (Object)resultServiceRowID);
                    cq.where((Expression)pr1);
                    Iterator iterator = persistence.executeCriteriaQuery(cq).iterator();
                    ResultRow row = null;
                    if (iterator.hasNext()) {
                        row = (ResultRow)iterator.next();
                    }
                    if (row == null) {
                        this.logger.trace((Object)"Service Row id not found in database");
                        out.println(this.error("Service Row id not found in database"));
                        out.close();
                        return;
                    }
                    String table = this.getTableForResultRow(row, ResultRowTable.getClassification((List)row.getParents()));
                    this.logger.trace((Object)("table for ResultRowPersistence is empty " + table.isEmpty()));
                    out.println(table);
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error in ResultRowTable servlet ", (Throwable)e);
                    throw new Exception("Error in ResultRowTable servlet ", e);
                }
            }
            out.println("</BODY>");
            out.println("</HTML>");
            out.close();
        }
        catch (Exception e) {
            String error = "Sorry an error occurred when creating the table for result row with id: " + resultServiceRowID;
            if (out != null) {
                out.println(error);
            }
            out.println("</BODY>");
            out.println("</HTML>");
            out.close();
        }
    }

    public String error(String message) {
        String errorPage = "";
        errorPage = errorPage + "<p>Error: " + message + "</p>";
        return errorPage;
    }

    public static String getClassification(List<Taxon> listTaxon) {
        StringBuilder sb = new StringBuilder();
        for (int i = listTaxon.size() - 1; i >= 0; --i) {
            Taxon taxon = listTaxon.get(i);
            sb.append("<b>");
            if (!NormalizeString.isUndefined((String)taxon.getRank())) {
                sb.append(taxon.getRank());
            } else {
                sb.append("Rank not found");
            }
            sb.append("</b>: ");
            if (!NormalizeString.isUndefined((String)taxon.getName())) {
                sb.append(taxon.getName());
            } else {
                sb.append("Name not found");
            }
            if (i == 0) continue;
            sb.append(" -> ");
        }
        return sb.toString();
    }

    public String getTableForResultRow(ResultRow row, String classification) {
        String dataSourceName = "";
        String dataProviderName = "";
        String dataSetName = "";
        String dataSetCitation = "";
        String matchingTaxonName = "";
        String matchingAccordionTo = "";
        String matchingRank = "";
        String matchingCredits = "";
        int occurencesCount = 0;
        String scientificNameAuthorship = "";
        String lsid = "";
        String credits = "";
        String propertiesHtml = "";
        if (row.getParents() != null) {
            if (((Taxon)row.getParents().get(0)).getName() != null) {
                matchingTaxonName = ((Taxon)row.getParents().get(0)).getName();
            }
            if (((Taxon)row.getParents().get(0)).getAccordingTo() != null) {
                matchingAccordionTo = ((Taxon)row.getParents().get(0)).getAccordingTo();
            }
            if (((Taxon)row.getParents().get(0)).getRank() != null) {
                matchingRank = ((Taxon)row.getParents().get(0)).getRank();
            }
        }
        if (row.getDataSourceName() != null) {
            dataSourceName = row.getDataSourceName();
        }
        if (row.getDataProviderName() != null) {
            dataProviderName = row.getDataProviderName();
        }
        if (row.getDataSetName() != null) {
            dataSetName = row.getDataSetName();
        }
        if (row.getDataSetCitation() != null) {
            dataSetCitation = row.getDataSetCitation();
        }
        if (row.getMatchingCredits() != null) {
            matchingCredits = row.getMatchingCredits();
        }
        if (row.getOccurencesCount() != 0) {
            occurencesCount = row.getOccurencesCount();
        }
        String commonNames = "";
        if (row.getCommonNames() != null) {
            for (CommonName comName : row.getCommonNames()) {
                commonNames = commonNames + "<b>" + comName.getName() + "</b> (" + comName.getLanguage() + ") - ";
            }
        }
        if (row.getScientificNameAuthorship() != null) {
            scientificNameAuthorship = row.getScientificNameAuthorship();
        }
        if (row.getLsid() != null) {
            lsid = row.getLsid();
        }
        if (row.getCredits() != null) {
            credits = row.getCredits();
        }
        if (row.getProperties() != null) {
            List listProperties = row.getProperties();
            Collections.sort(listProperties, ItemParameter.COMPARATOR);
            propertiesHtml = propertiesHtml + "<table class=\"parameters\">";
            for (ItemParameter itemParameter : listProperties) {
                propertiesHtml = propertiesHtml + "<tr>\t<td class=\"title\">" + itemParameter.getKey() + "</td>\t<td>" + itemParameter.getValue() + "</td></tr>";
            }
            propertiesHtml = propertiesHtml + "</table>";
        }
        String table = "<table class=\"imagetable\"><tr>\t<th>" + matchingTaxonName + "</th></tr><tr>\t<td class=\"title\">" + SpeciesGridFields.CLASSIFICATION_STRING.getName() + "</td>\t<td>" + classification + "</td></tr><tr>\t<td class=\"title\">" + SpeciesGridFields.COMMON_NAMES.getName() + " (Language)</td>\t<td>" + commonNames + "</td></tr><tr>\t<td class=\"title\">" + SpeciesGridFields.DATASOURCE.getName() + "</td>\t<td>" + dataSourceName + "</td></tr><tr>\t<td class=\"title\">" + SpeciesGridFields.DATAPROVIDER.getName() + "</td>\t<td>" + dataProviderName + "</td></tr><tr>\t<td class=\"title\">" + SpeciesGridFields.DATASET.getName() + "</td>\t<td>" + dataSetName + "</td></tr><tr>\t<td class=\"title\">" + SpeciesGridFields.MATCHING_RANK.getName() + "</td>\t<td>" + matchingRank + "</td></tr><tr>\t<td class=\"title\">" + SpeciesGridFields.DATASET_CITATION.getName() + "</td>\t<td>" + dataSetCitation + "</td></tr><tr>\t<td class=\"title\">" + SpeciesGridFields.PRODUCT_OCCURRENCES.getName() + "</td>\t<td>" + occurencesCount + "</td></tr><tr>\t<td class=\"title\">" + SpeciesGridFields.LSID.getName() + "</td>\t<td>" + lsid + "</td></tr><tr>\t<td class=\"title\">" + SpeciesGridFields.SCIENTIFICNAMEAUTHORSHIP.getName() + "</td>\t<td>" + scientificNameAuthorship + "</td></tr><tr>\t<td class=\"title\">" + SpeciesGridFields.CREDITS.getName() + "</td>\t<td>" + credits + "</td></tr><tr>\t<td class=\"title\">" + SpeciesGridFields.PROPERTIES.getName() + "</td>\t<td>" + propertiesHtml + "</td></tr></table>";
        return table;
    }
}

