package org.gcube.portlets.user.speciesdiscovery.client.windowdetail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

import org.gcube.portlets.user.speciesdiscovery.client.ConstantsSpeciesDiscovery;
import org.gcube.portlets.user.speciesdiscovery.client.SearchController;
import org.gcube.portlets.user.speciesdiscovery.client.SpeciesDiscovery;
import org.gcube.portlets.user.speciesdiscovery.client.advancedsearch.AdvancedSearchPanelManager;
import org.gcube.portlets.user.speciesdiscovery.client.cluster.TablesForTaxonomyRow;
import org.gcube.portlets.user.speciesdiscovery.client.event.SearchEvent;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceModel;
import org.gcube.portlets.user.speciesdiscovery.shared.SpeciesCapability;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyRow;
import org.gcube.portlets.user.speciesdiscovery.shared.cluster.ClusterCommonNameDataSource;
import org.gcube.portlets.user.speciesdiscovery.shared.cluster.ClusterStructuresForTaxonomyRow;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.Style.VerticalAlignment;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.layout.ColumnData;
import com.extjs.gxt.ui.client.widget.layout.ColumnLayout;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Anchor;

public class TaxonomyRowDetailsFiller implements DetailsFiller {

	private TabItem tabItemDetails;
	private ToolBar toolbarTaxonomy;
	private AbstractImagePrototype imgAttention = AbstractImagePrototype.create(Resources.INSTANCE.getAttention());
	private ContentPanel panelDetails;
	private int width = 900;
	private List<String> lastlistDataSourceFound;
	private CommonDetailComponents common;
	private String lastScientificName;
	private TabPanel tabPanel;
	
	public TaxonomyRowDetailsFiller(TabItem tabItemDetails, ToolBar toolbarTaxonomy, TabPanel tabPanel, ContentPanel panelDetails, SearchEvent lastSearchEvent){
		this.tabItemDetails = tabItemDetails;
		this.toolbarTaxonomy = toolbarTaxonomy;
		this.panelDetails = panelDetails;
		this.tabPanel = tabPanel;
		this.common = new CommonDetailComponents(lastSearchEvent);
	}
	

	private void enableToolbarTaxonomy(boolean bool){
		toolbarTaxonomy.setEnabled(bool);
	}
	
	public void loadStructuresAndFillingPage(){
		
		final long startTime = System.currentTimeMillis();
		
		SpeciesDiscovery.taxonomySearchService.loadStructuresForTaxonomyClustering(new AsyncCallback<ClusterStructuresForTaxonomyRow>() {

			@Override
			public void onFailure(Throwable caught) {
				Info.display("Sorry", "Error retriving selected results");
				tabItemDetails.unmask();
				enableToolbarTaxonomy(true);
				
			}

			@Override
			public void onSuccess(ClusterStructuresForTaxonomyRow result) {
				
				int size = result.getResult().size();
				
				long returnedTime = System.currentTimeMillis();
				
				long loadTime = returnedTime-startTime;

				Log.trace("fillPageDetailsForTaxonomy: " +size +" cluster taxonomy row was loaded in "+  loadTime +" msc");
				
//				TablesForTaxonomyRow tableClassification = new TablesForTaxonomyRow(result, DEFAULTLANGUAGE, tabPanel, isSearchByCommonName, searchController.getEventBus());
				
				String items = size>0?"items":"item"; 
				
				String msg = "";
				
				if(result.getTotalRow()>size){
					msg = ConstantsSpeciesDiscovery.ROW_LIMIT_REACHED + " - ";
					tabItemDetails.setIcon(imgAttention);
					tabItemDetails.setToolTip(ConstantsSpeciesDiscovery.THE_MAX_NUMBER_OF_ITEMS_DISPLAYABLE_IS+ConstantsSpeciesDiscovery.LIMIT_ITEM_DETAILS);
				}
				
				msg+= tabItemDetails.getText() + " ("+size +" "+ items+")";
				tabItemDetails.setText(msg);
				
				
				createCommonNameDetailsPageForTaxonomyRow(result);
				enableToolbarTaxonomy(true);
				tabItemDetails.unmask();
				
				long avilableTime = returnedTime-loadTime;
				
				Log.trace("fillPageDetailsForTaxonomy: " +size +" view details taxonomy row are available in "+  avilableTime +" msc");
			}

			
		});
		
	}
	
	private void createCommonNameDetailsPageForTaxonomyRow(ClusterStructuresForTaxonomyRow result) {
		HashMap<String, ArrayList<String>> hashTaxonomyRowID = result.getHashClusterScientificNameTaxonomyRowID();
//		ArrayList<String> listDataSourceFound = tableClassification.getListFoundDataSources();
		HashMap<String,ClusterCommonNameDataSource<TaxonomyRow>> hashClusterCommonNamesDataSources = result.getHashClusterCommonNamesDataSources();
		
//		HashMap<String, ArrayList<GxtClassificationModel>> hashHTMLTables = result.getHashClassificationTables();
		
		String title = common.getSearchTitle();
		panelDetails.add(new Html(title));
			
//		for (String dataSource : listDataSourceFound) {
//			  System.out.println("############# Data Source found " + dataSource);
//		}
		
		List<String> listKey = new ArrayList<String>(hashTaxonomyRowID.keySet());
		Collections.sort(listKey);
		
		
		final Anchor anchorIndex = new Anchor();
		anchorIndex.setName("indexOfContents");
		
		panelDetails.add(new Html("<p style=\"font-size:12px;\"><b> Index of Contents"+anchorIndex+"</b></p><br/>"));
		panelDetails.add(common.createIndexOfContents(listKey));
		
		//update last list data source found
		lastlistDataSourceFound = result.getListFoundDataSources();
		
		//Create panels about
		panelDetails.add(new Html("<hr><br/>"));
		VerticalPanel verticaPanelAbouts = common.createPanelAbout(SpeciesCapability.TAXONOMYITEM, result.getListFoundDataSources());
		panelDetails.add(verticaPanelAbouts);
		panelDetails.add(new Html("<br/>"));
		
		for (final String scientificName : listKey) {
			
			Anchor anchor = new Anchor("[top index]");
			anchor.setName(scientificName);
			
			anchor.addClickHandler(new ClickHandler() {
			    public void onClick(ClickEvent event) {
			         com.google.gwt.user.client.Window.Location.assign("#indexOfContents");
			    }
			});
			
			LayoutContainer titleContainer = new LayoutContainer();
			titleContainer.setLayout(new ColumnLayout());
			titleContainer.setWidth(width-80);
			
			LayoutContainer left = new LayoutContainer();
		    FormLayout layout = new FormLayout();
		    left.setLayout(layout);
		    
		    LayoutContainer right = new LayoutContainer();
		    layout = new FormLayout();
		    right.setLayout(layout);
	

		    HorizontalPanel hp = new HorizontalPanel();
		    hp.setTableWidth("100%");
		    TableData td = new TableData();
		    td.setHorizontalAlign(HorizontalAlignment.RIGHT);
		    hp.add(anchor, td);
		    

			titleContainer.add(left, new ColumnData(.8));
			titleContainer.add(right, new ColumnData(.2));
			
//			HorizontalPanel hp = new HorizontalPanel();
//			hp.setHorizontalAlign(HorizontalAlignment.CENTER);
//			hp.setStyleAttribute("margin", FIVEPX);
			
			this.lastScientificName = scientificName;
			
			left.add(new Html("<p style=\"margin-right:5px; font-size:14px;\"><b>" + ConstantsSpeciesDiscovery.SCIENTIFICNAME + ": " + scientificName + "</b></p>"));
			right.add(hp);
			
			panelDetails.add(titleContainer);
			panelDetails.add(new Html("<br/><br/>"));
			panelDetails.add(common.createExternalLinks(scientificName));
			
			String commonNamesTitle = "<p style=\"font-size:12px;\"><b>Common Names (Data Source/s)</b></p>";
			panelDetails.add(new Html(commonNamesTitle));
			
			ClusterCommonNameDataSource<TaxonomyRow> cluster = hashClusterCommonNamesDataSources.get(scientificName);
			
			String tableCommonName = common.createTableWithCheckCommonNameDataSource(cluster.getHashMapCommonNameDataSources(), cluster.getListDataSourcesFound());
			panelDetails.add(new Html("<br/>"+tableCommonName+"<br/>"));
			
			ArrayList<String> arrayTaxonomyID = hashTaxonomyRowID.get(scientificName);
			
			for(int i=0; i<arrayTaxonomyID.size(); i++ ){
				TaxonomyRow taxonomy = result.getTaxonomyRowByKey(arrayTaxonomyID.get(i));
				String dataSource = taxonomy.getDataProviderName();
				
				TablesForTaxonomyRow tables = new TablesForTaxonomyRow(tabPanel, SearchController.eventBus);
	
				HorizontalPanel horizontalPanel = new HorizontalPanel();
				horizontalPanel.add(new Html("<br/><p style=\"font-size:12px;\"><b> Scientific Classification of "+ scientificName + " on " +dataSource+ " Data Source</b> </p> "));
				horizontalPanel.setVerticalAlign(VerticalAlignment.BOTTOM);
				
				DataSourceModel ds = AdvancedSearchPanelManager.getInstance().findDataSourceByCapabilityAndName(SpeciesCapability.TAXONOMYITEM, dataSource);
				
				Anchor createAbout = common.createAbout(ds,true);
				if(createAbout!=null){
					createAbout.getElement().getStyle().setMarginLeft(25, Unit.PX);
					horizontalPanel.add(createAbout);
				}
				
				panelDetails.add(horizontalPanel);
				panelDetails.add(tables.getPanelClassificationForTaxonomy(taxonomy, dataSource, false));
				
				tables.setParents(taxonomy.getParents());
				panelDetails.add(tables.getHTMLTableForTaxonomyWithRef(taxonomy, false, dataSource));
			}
		}
		
		panelDetails.layout(true);
		
	}

	@Override
	public String getLastScientificName() {
		return lastScientificName;
	}

	@Override
	public List<String> getLastlistDataSourceFound() {
		return lastlistDataSourceFound;
	}
}
