/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.util.stream;

import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.SpeciesDiscovery;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.client.util.SpeciesGridFields;
import org.gcube.portlets.user.speciesdiscovery.client.util.TaxonomyGridField;
import org.gcube.portlets.user.speciesdiscovery.client.util.Util;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.DataSource;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.StreamState;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyRow;
import org.gcube.portlets.user.speciesdiscovery.shared.filter.ResultFilter;
import org.gcube.portlets.user.speciesdiscovery.shared.util.NormalizeString;

public class TaxonomyRowDataSource
implements DataSource {
    protected boolean showOnlySelected = false;
    protected boolean isActiveFilterOnResult = false;

    public void getStreamState(AsyncCallback<StreamState> callback) {
        SpeciesDiscovery.taxonomySearchService.getSearchStatus(this.showOnlySelected, this.isActiveFilterOnResult, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getData(int start, int limit, ResultFilter activeFiltersObject, AsyncCallback<List<ModelData>> callback) {
        SpeciesDiscovery.taxonomySearchService.getSearchTaxonomyRow(start, limit, activeFiltersObject, this.showOnlySelected, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected List<ModelData> convertData(ArrayList<TaxonomyRow> rows) {
        ArrayList<ModelData> data = new ArrayList<ModelData>(rows.size());
        for (TaxonomyRow row : rows) {
            data.add((ModelData)this.convertTaxonomyRow(row));
        }
        return data;
    }

    protected BaseModelData convertTaxonomyRow(TaxonomyRow row) {
        BaseModelData data = new BaseModelData();
        String dataProviderName = "";
        String dataSetCitation = "";
        String rank = "";
        String statusRedId = "";
        String statusRefName = "";
        String dateModified = "";
        String name = "";
        String statusRemarks = "";
        String classificationString = "";
        String author = "";
        List hashProperties = new ArrayList();
        if (row.getDataProviderName() != null) {
            dataProviderName = row.getDataProviderName();
        }
        if (row.getDataSetCitation() != null) {
            dataSetCitation = row.getDataSetCitation();
        }
        if (row.getRank() != null) {
            rank = row.getRank();
        }
        if (row.getStatusRefId() != null) {
            statusRedId = row.getStatusRefId();
        }
        if (row.getStatusName() != null) {
            statusRefName = row.getStatusName();
        }
        if (row.getDateModified() != null) {
            dateModified = row.getDateModified();
        }
        if (row.getName() != null) {
            name = row.getName();
        }
        if (row.getStatusRemarks() != null) {
            statusRemarks = row.getStatusRemarks();
        }
        if (row.getProperties() != null) {
            hashProperties = row.getProperties();
        }
        if (row.getAuthor() != null) {
            author = row.getAuthor();
        }
        if (row.getParents() != null) {
            classificationString = this.getClassification(row.getParents());
            data.set(TaxonomyGridField.CLASSIFICATION_STRING.getId(), (Object)classificationString);
            String rankHTML = this.getRankHtml(row.getParents());
            data.set(TaxonomyGridField.TAXONOMY.getId(), (Object)rankHTML);
        }
        data.set(TaxonomyGridField.SCIENTIFIC_NAME.getId(), (Object)name);
        data.set(TaxonomyGridField.SELECTION.getId(), (Object)row.isSelected());
        data.set(TaxonomyGridField.DATASOURCE.getId(), (Object)dataProviderName);
        data.set(TaxonomyGridField.CITATION.getId(), (Object)dataSetCitation);
        data.set(TaxonomyGridField.MATCHING_RANK.getId(), (Object)rank);
        data.set(TaxonomyGridField.STATUSREFNAME.getId(), (Object)statusRefName);
        data.set(TaxonomyGridField.STATUSREFID.getId(), (Object)statusRedId);
        data.set(TaxonomyGridField.DATEMODIFIED.getId(), (Object)dateModified);
        data.set(TaxonomyGridField.AUTHOR.getId(), (Object)author);
        data.set(TaxonomyGridField.STATUS_REMARKS.getId(), (Object)statusRemarks);
        data.set(TaxonomyGridField.PROPERTIES.getId(), hashProperties);
        String provenance = this.getProvenanceHTML(dataProviderName, dataSetCitation);
        data.set(SpeciesGridFields.PROVENANCE.getId(), (Object)provenance);
        data.set(TaxonomyGridField.ROW.getId(), (Object)row);
        return data;
    }

    public String getClassification(List<TaxonomyRow> listTaxonomy) {
        StringBuilder sb = new StringBuilder();
        int i = listTaxonomy.size() - 1;
        while (i >= 0) {
            TaxonomyRow taxonomy = listTaxonomy.get(i);
            sb.append("<b>");
            if (!NormalizeString.isUndefined((String)taxonomy.getRank())) {
                sb.append(taxonomy.getRank());
            } else {
                sb.append("Rank not found");
            }
            sb.append("</b>: ");
            if (!NormalizeString.isUndefined((String)taxonomy.getName())) {
                sb.append(taxonomy.getName());
            } else {
                sb.append("Name not found");
            }
            if (i != 0) {
                sb.append(" -> ");
            }
            --i;
        }
        return sb.toString();
    }

    protected String getRankHtml(List<TaxonomyRow> listTaxonomy) {
        String id = Document.get().createUniqueId();
        StringBuilder html = new StringBuilder("<p><br/>");
        int offset = html.length();
        html.append("<table id=\"");
        html.append(id);
        html.append("\">");
        boolean addToggler = false;
        for (TaxonomyRow taxonomy : listTaxonomy) {
            if (!Util.isMainTaxonomicRank((String)taxonomy.getRank())) {
                html.append("<tr class=\"");
                html.append("SPECIES_TOGGLE");
                html.append("\" style=\"display:none\"><td><b>");
                addToggler = true;
            } else {
                html.append("<tr><td><b>");
            }
            if (!NormalizeString.isUndefined((String)taxonomy.getRank())) {
                html.append(taxonomy.getRank());
            } else {
                html.append("Rank not found");
            }
            html.append(":</b></td><td>{");
            if (!NormalizeString.isUndefined((String)taxonomy.getName())) {
                html.append(taxonomy.getName());
            } else {
                html.append("Name not found");
            }
            html.append("}</td></tr>");
        }
        html.append("</table>");
        if (addToggler) {
            StringBuilder toggler = new StringBuilder();
            String idImgExpand = Document.get().createUniqueId();
            String idImgCollapse = Document.get().createUniqueId();
            toggler.append("<a href=\"#\" onclick=\"toggle('");
            toggler.append("SPECIES_TOGGLE");
            toggler.append("','");
            toggler.append(id);
            toggler.append("','tr');toggleSingle('");
            toggler.append(idImgExpand);
            toggler.append("');toggleSingle('");
            toggler.append(idImgCollapse);
            toggler.append("')\">");
            toggler.append("<img id=\"");
            toggler.append(idImgExpand);
            toggler.append("\" src=\"");
            toggler.append(Resources.INSTANCE.getExpand().getSafeUri().asString());
            toggler.append("\" style=\"float:left;\" />");
            toggler.append("<img id=\"");
            toggler.append(idImgCollapse);
            toggler.append("\" src=\"");
            toggler.append(Resources.INSTANCE.getCollapse().getSafeUri().asString());
            toggler.append("\" style=\"float:left;display:none\" />");
            toggler.append("</a>");
            html.insert(offset, toggler.toString());
        } else {
            html.insert(offset, "<div style=\"padding-left:" + Resources.INSTANCE.getExpand().getWidth() + "px\">");
            html.append("</div>");
        }
        html.append("</p>");
        return html.toString();
    }

    protected String getProvenanceHTML(String dataSource, String datasetCitation) {
        StringBuilder html = new StringBuilder("<p><br/><table>");
        html.append("<tr><td><b>Data Source:</b></td><td>");
        html.append(dataSource);
        html.append("</td></tr>");
        html.append("<tr><td><b>Citation:</b></td><td>");
        html.append(datasetCitation);
        html.append("</td></tr>");
        html.append("</table></p>");
        return html.toString();
    }

    public boolean isShowOnlySelected() {
        return this.showOnlySelected;
    }

    public void setShowOnlySelected(boolean showOnlySelected) {
        this.showOnlySelected = showOnlySelected;
    }

    public boolean isActiveFilterOnResult() {
        return this.isActiveFilterOnResult;
    }

    public void setActiveFilterOnResult(boolean isActiveFilterOnResult) {
        this.isActiveFilterOnResult = isActiveFilterOnResult;
    }

    public String getInfo() {
        return "TaxonomyRowDataSource";
    }
}

