/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.persistence.dao;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portlets.user.speciesdiscovery.shared.DatabaseServiceException;

public abstract class AbstractPersistence<T> {
    protected EntityManagerFactory entityManagerFactory;
    public final String AND = "AND";
    protected GCUBELog logger = new GCUBELog(AbstractPersistence.class);

    AbstractPersistence(EntityManagerFactory factory) {
        this.entityManagerFactory = factory;
    }

    public boolean insert(T item) throws DatabaseServiceException {
        EntityManager em = this.createNewManager();
        try {
            try {
                em.getTransaction().begin();
                em.persist(item);
                em.getTransaction().commit();
            }
            catch (Exception e) {
                this.logger.error((Object)("Error in insert: " + e.getMessage()), (Throwable)e);
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
        return true;
    }

    public T update(T item) throws DatabaseServiceException {
        block8: {
            EntityManager em = this.createNewManager();
            try {
                try {
                    em.getTransaction().begin();
                    item = em.merge(item);
                    em.getTransaction().commit();
                }
                catch (Exception e) {
                    this.logger.error((Object)("Error in update: " + e.getMessage()), (Throwable)e);
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
                throw throwable;
            }
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
        return item;
    }

    public boolean remove(T item, boolean transaction) throws DatabaseServiceException {
        block8: {
            EntityManager em = this.createNewManager();
            try {
                try {
                    if (transaction) {
                        em.getTransaction().begin();
                        em.remove(item);
                        em.getTransaction().commit();
                        break block8;
                    }
                    em.remove(item);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Error in remove: " + e.getMessage()), (Throwable)e);
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
            }
            finally {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return true;
    }

    public abstract int removeAll() throws DatabaseServiceException;

    public abstract List<T> getList() throws DatabaseServiceException;

    public abstract List<T> getList(int var1, int var2) throws DatabaseServiceException;

    public abstract int countItems() throws DatabaseServiceException;

    public abstract T getItemByKey(Integer var1) throws DatabaseServiceException;

    public abstract List<T> executeCriteriaQuery(CriteriaQuery<Object> var1) throws DatabaseServiceException;

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public EntityManager createNewManager() throws DatabaseServiceException {
        try {
            if (this.entityManagerFactory != null) {
                return this.entityManagerFactory.createEntityManager();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred in create new entity manager ", (Throwable)e);
            e.printStackTrace();
            throw new DatabaseServiceException("An error occurred in create new entity manager");
        }
        return null;
    }

    public abstract CriteriaBuilder getCriteriaBuilder() throws DatabaseServiceException;

    public abstract List<T> executeTypedQuery(CriteriaQuery<Object> var1, int var2, int var3) throws DatabaseServiceException;

    public abstract Root<T> rootFrom(CriteriaQuery<Object> var1);

    public abstract List<T> getList(Map<String, String> var1, int var2, int var3) throws DatabaseServiceException;

    public abstract int deleteItemByIdField(String var1) throws DatabaseServiceException;
}

