/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.shared.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.portlets.user.speciesdiscovery.shared.FetchingElement;
import org.gcube.portlets.user.speciesdiscovery.shared.ResultRow;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchResult;
import org.gcube.portlets.user.speciesdiscovery.shared.Taxon;
import org.gcube.portlets.user.speciesdiscovery.shared.cluster.ClusterCommonNameDataSource;
import org.gcube.portlets.user.speciesdiscovery.shared.util.NormalizeString;

public class ClusterStructuresForResultRow
implements Serializable {
    private static final long serialVersionUID = 1205113606387863736L;
    private ArrayList<String> listResultRowID;
    private Map<String, ResultRow> hashResult = new HashMap();
    private ArrayList<String> listFoundDataSources = new ArrayList();
    private HashMap<String, ClusterCommonNameDataSource<ResultRow>> hashClusterCommonNamesDataSources = new HashMap();
    private HashMap<String, ArrayList<String>> hashScientificNameResultRowID = new HashMap();
    private boolean isReduced;
    private int totalRow;

    public ClusterStructuresForResultRow() {
    }

    public ClusterStructuresForResultRow(SearchResult<ResultRow> result, boolean isReduced, int totalRow) {
        for (ResultRow row : result.getResults()) {
            this.hashResult.put(row.getIdToString(), row);
        }
        this.isReduced = isReduced;
        this.totalRow = totalRow;
        this.createStructures(result.getResults());
        this.createStructuresForCommonName();
    }

    public void createStructuresForCommonName() {
        if (this.hashScientificNameResultRowID.size() > 0) {
            for (String scientificName : this.hashScientificNameResultRowID.keySet()) {
                ArrayList listResultRowServiceID = (ArrayList)this.hashScientificNameResultRowID.get(scientificName);
                ClusterCommonNameDataSource cluster = new ClusterCommonNameDataSource();
                int i = 0;
                while (i < listResultRowServiceID.size()) {
                    ResultRow row = (ResultRow)this.hashResult.get(listResultRowServiceID.get(i));
                    cluster.updateHashCommonNamesDataSources((FetchingElement)row);
                    ++i;
                }
                this.hashClusterCommonNamesDataSources.put(scientificName, cluster);
            }
        }
    }

    public void createStructures(ArrayList<ResultRow> arrayListRR) {
        if (arrayListRR.size() > 0) {
            for (ResultRow row : arrayListRR) {
                String dataSource;
                String keyScientificName = "Name not found";
                if (row.getParents().get(0) != null) {
                    keyScientificName = ((Taxon)row.getParents().get(0)).getName();
                    keyScientificName = keyScientificName == null || keyScientificName.isEmpty() ? "Undefined" : NormalizeString.lowerCaseUpFirstChar((String)keyScientificName);
                    this.listResultRowID = this.hashScientificNameResultRowID.get(keyScientificName) == null ? new ArrayList() : (ArrayList)this.hashScientificNameResultRowID.get(keyScientificName);
                }
                if ((dataSource = row.getDataSourceName()) == null || dataSource.isEmpty()) {
                    dataSource = "Data Source not found";
                }
                if (this.listFoundDataSources.indexOf(dataSource) == -1) {
                    this.listFoundDataSources.add(dataSource);
                }
                this.listResultRowID.add(String.valueOf(row.getIdToString()));
                this.hashScientificNameResultRowID.put(keyScientificName, this.listResultRowID);
            }
        }
    }

    public HashMap<String, ArrayList<String>> getHashClusterScientificNameResultRowID() {
        return this.hashScientificNameResultRowID;
    }

    public List<String> getListFoundDataSources() {
        return this.listFoundDataSources;
    }

    public HashMap<String, ClusterCommonNameDataSource<ResultRow>> getHashClusterCommonNamesDataSources() {
        return this.hashClusterCommonNamesDataSources;
    }

    public List<ResultRow> getResult() {
        return new ArrayList<ResultRow>(this.hashResult.values());
    }

    public ResultRow getResultRowByRowID(String key) {
        return (ResultRow)this.hashResult.get(key);
    }

    public boolean isReduced() {
        return this.isReduced;
    }

    public void setReduced(boolean isReduced) {
        this.isReduced = isReduced;
    }

    public int getTotalRow() {
        return this.totalRow;
    }

    public void setTotalRow(int totalRow) {
        this.totalRow = totalRow;
    }
}

