/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.util;

import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.dataaccess.spql.SPQLQueryParser;
import org.gcube.dataaccess.spql.model.Query;
import org.gcube.dataaccess.spql.model.Term;
import org.gcube.dataaccess.spql.model.ret.ReturnType;
import org.gcube.portlets.user.speciesdiscovery.server.util.QueryUtil;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchByQueryParameter;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchFilters;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchResultType;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchType;
import org.gcube.portlets.user.speciesdiscovery.shared.SpeciesCapability;

public class QueryUtil {
    protected static Logger logger = Logger.getLogger(QueryUtil.class);

    public static SearchByQueryParameter getQueryResultType(String queryText) throws SearchServiceException {
        try {
            Query query = SPQLQueryParser.parse((String)queryText);
            HashMap<SearchType, List> terms = new HashMap<SearchType, List>();
            for (Term term : query.getTerms()) {
                switch (1.$SwitchMap$org$gcube$dataaccess$spql$model$TermType[term.getType().ordinal()]) {
                    case 1: {
                        terms.put(SearchType.BY_COMMON_NAME, term.getWords());
                        break;
                    }
                    case 2: {
                        terms.put(SearchType.BY_SCIENTIFIC_NAME, term.getWords());
                    }
                }
            }
            logger.trace((Object)("found terms: " + terms));
            ReturnType returnType = query.getReturnType();
            SearchResultType searchResultType = SearchResultType.SPECIES_PRODUCT;
            switch (1.$SwitchMap$org$gcube$dataaccess$spql$model$ret$ReturnType[returnType.ordinal()]) {
                case 1: {
                    searchResultType = SearchResultType.OCCURRENCE_POINT;
                    break;
                }
                case 2: {
                    searchResultType = SearchResultType.SPECIES_PRODUCT;
                    break;
                }
                case 3: {
                    searchResultType = SearchResultType.TAXONOMY_ITEM;
                }
            }
            logger.trace((Object)("found returnType: " + searchResultType));
            return new SearchByQueryParameter(terms, searchResultType);
        }
        catch (Exception e) {
            logger.warn((Object)"Error parsing the user query", (Throwable)e);
            throw new SearchServiceException("Wrong query: " + e.getMessage());
        }
    }

    public static SearchResultType getResultType(SearchFilters searchFilters) {
        switch (1.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SpeciesCapability[searchFilters.getResultType().ordinal()]) {
            case 1: {
                return SearchResultType.SPECIES_PRODUCT;
            }
            case 2: {
                return SearchResultType.TAXONOMY_ITEM;
            }
        }
        logger.error((Object)("Unknow return type: " + searchFilters.getResultType()));
        return null;
    }

    public static SpeciesCapability getResultType(SearchResultType resultType) {
        switch (1.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SearchResultType[resultType.ordinal()]) {
            case 1: {
                return SpeciesCapability.RESULTITEM;
            }
            case 2: {
                return SpeciesCapability.OCCURRENCESPOINTS;
            }
            case 3: {
                return SpeciesCapability.TAXONOMYITEM;
            }
        }
        return null;
    }
}

