/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.stream;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.speciesdiscovery.server.stream.CloseableIterator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.Converter;

public class ConversionIterator<I, O>
implements CloseableIterator<O> {
    protected Logger logger = Logger.getLogger(ConversionIterator.class);
    protected CloseableIterator<I> source;
    protected Converter<I, O> converter;

    public ConversionIterator(CloseableIterator<I> source, Converter<I, O> converter) {
        this.source = source;
        this.converter = converter;
    }

    public boolean hasNext() {
        return this.source.hasNext();
    }

    public O next() {
        assert (this.hasNext());
        try {
            Object input = this.source.next();
            Object output = this.converter.convert(input);
            return (O)output;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error converting element", (Throwable)e);
            return null;
        }
    }

    public void close() throws IOException {
        this.source.close();
    }

    public void remove() {
    }
}

