/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.windowdetail;

import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.advancedsearch.AdvancedSearchPanelManager;
import org.gcube.portlets.user.speciesdiscovery.client.event.SearchEvent;
import org.gcube.portlets.user.speciesdiscovery.client.externalsystem.OtherInformationSystemsEnum;
import org.gcube.portlets.user.speciesdiscovery.client.externalsystem.OtherMappingSystemsEnum;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.client.windowdetail.CommonDetailComponents;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceModel;
import org.gcube.portlets.user.speciesdiscovery.shared.SpeciesCapability;

public class CommonDetailComponents {
    public static final String FIVEPX = "5px";
    private SearchEvent lastSearchEvent;
    private AbstractImagePrototype imageYes = AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getCheckYes());
    private AbstractImagePrototype imageNo = AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getCheckNo());

    CommonDetailComponents(SearchEvent lastSearchEvent) {
        this.lastSearchEvent = lastSearchEvent;
    }

    private String getSearchType() {
        String searchType = "";
        if (this.lastSearchEvent.getMapTermsSearched() != null) {
            searchType = this.lastSearchEvent.getMapTermsSearched().toString();
        } else {
            switch (5.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SearchType[this.lastSearchEvent.getType().ordinal()]) {
                case 1: {
                    searchType = "by common name";
                    break;
                }
                case 2: {
                    searchType = "by scientific name";
                }
            }
        }
        return searchType;
    }

    public String getSearchTitle() {
        return "<br/><br/><p style=\"font-size:18px;\"><b>" + this.lastSearchEvent.getSearchTerm() + "</b></p>" + "<p style=\"font-family:\"Times New Roman\", Times, serif; font-size:12px; font-style:italic; \">search " + this.getSearchType() + "</p><br/><hr><br/>";
    }

    public String createTableWithCheckCommonNameDataSource(HashMap<String, ArrayList<String>> hashCommonNameDataSources, ArrayList<String> listDataSourceFound) {
        String table;
        ArrayList<String> listCommonNames = new ArrayList<String>(hashCommonNameDataSources.keySet());
        Collections.sort(listCommonNames, String.CASE_INSENSITIVE_ORDER);
        Collections.sort(listDataSourceFound);
        if (listCommonNames.size() > 0) {
            int[][] checkCommonNameDataSources = new int[listCommonNames.size()][listDataSourceFound.size()];
            for (int i = 0; i < listCommonNames.size(); ++i) {
                String commonName = (String)listCommonNames.get(i);
                ArrayList<String> cmDataSources = hashCommonNameDataSources.get(commonName);
                for (String dataSource : cmDataSources) {
                    int index = listDataSourceFound.indexOf(dataSource);
                    checkCommonNameDataSources[i][index] = 1;
                }
            }
            table = "<table class=\"simpletable\"\"><tr><th>Common names / Data Sources</th>";
            for (String dataSource : listDataSourceFound) {
                table = table + "<th>" + dataSource + "</th>";
            }
            table = table + "</tr>";
            for (int i = 0; i < listCommonNames.size(); ++i) {
                table = table + "<tr><td class=\"commonname\">" + (String)listCommonNames.get(i) + "</td>";
                for (int j = 0; j < listDataSourceFound.size(); ++j) {
                    table = checkCommonNameDataSources[i][j] == 1 ? table + "<td>" + this.imageYes.getHTML() + "</td>" : table + "<td>" + this.imageNo.getHTML() + "</td>";
                }
                table = table + "</tr>";
            }
            table = table + "</table>";
        } else {
            table = "Not found";
        }
        return table;
    }

    public VerticalPanel createIndexOfContents(List<String> listScientificName) {
        VerticalPanel verticalPanel = new VerticalPanel();
        verticalPanel.setStyleAttribute("margin", FIVEPX);
        verticalPanel.setStyleAttribute("padding", FIVEPX);
        int i = 0;
        for (String scientificName : listScientificName) {
            Anchor anchor = new Anchor(++i + ". " + scientificName);
            anchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            verticalPanel.add((Widget)anchor);
        }
        return verticalPanel;
    }

    public VerticalPanel createPanelAbout(SpeciesCapability capability, List<String> listDataSourcesFound) {
        VerticalPanel verticalPanel = new VerticalPanel();
        verticalPanel.setStyleAttribute("margin", FIVEPX);
        verticalPanel.setStyleAttribute("padding", FIVEPX);
        verticalPanel.add((Widget)new Html("<p style=\"font-size:12px;\"><b> About Data Sources</b></p><br/>"));
        for (String dataSoruceName : listDataSourcesFound) {
            DataSourceModel dataSource = AdvancedSearchPanelManager.getInstance().findDataSourceByCapabilityAndName(capability, dataSoruceName);
            Anchor createAbout = this.createAbout(dataSource, false);
            if (createAbout == null) continue;
            verticalPanel.add((Widget)createAbout);
        }
        return verticalPanel;
    }

    public Anchor createAbout(DataSourceModel ds, boolean insertAboutCitation) {
        Anchor anchor = null;
        if (ds != null) {
            String anchorValue = "";
            anchorValue = insertAboutCitation ? "<nobr>About " + ds.getName() + "</nobr>" : "<nobr>" + ds.getName() + "</nobr>";
            anchor = new Anchor(anchorValue, true);
            anchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return anchor;
    }

    public VerticalPanel createExternalLinks(String searchValue) {
        VerticalPanel vpExternalLink = new VerticalPanel();
        Html htmlLinkOIS = new Html("<p style=\"font-size:12px;\"><b>Links to Other Information Systems</b></p>");
        VerticalPanel vpOIS = new VerticalPanel();
        vpOIS.setStyleAttribute("margin", FIVEPX);
        vpOIS.setStyleAttribute("padding", FIVEPX);
        for (OtherInformationSystemsEnum infSystem : OtherInformationSystemsEnum.values()) {
            Anchor anchor = new Anchor(infSystem.getName());
            anchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            vpOIS.add((Widget)anchor);
        }
        Html htmlLinkOMS = new Html("<p style=\"font-size:12px;\"><b>Links to Other Mapping Systems</b></p>");
        VerticalPanel vpOMS = new VerticalPanel();
        vpOMS.setStyleAttribute("margin", FIVEPX);
        vpOMS.setStyleAttribute("padding", FIVEPX);
        for (OtherMappingSystemsEnum infSystem : OtherMappingSystemsEnum.values()) {
            Anchor anchor = new Anchor(infSystem.getName());
            anchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            vpOMS.add((Widget)anchor);
        }
        vpExternalLink.add((Widget)htmlLinkOIS);
        vpExternalLink.add((Widget)vpOIS);
        vpExternalLink.add((Widget)htmlLinkOMS);
        vpExternalLink.add((Widget)vpOMS);
        return vpExternalLink;
    }
}

