/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.util.stream;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.SpeciesDiscovery;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.client.util.SpeciesGridFields;
import org.gcube.portlets.user.speciesdiscovery.client.util.Util;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.DataSource;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.StreamState;
import org.gcube.portlets.user.speciesdiscovery.shared.CommonName;
import org.gcube.portlets.user.speciesdiscovery.shared.ResultRow;
import org.gcube.portlets.user.speciesdiscovery.shared.Taxon;
import org.gcube.portlets.user.speciesdiscovery.shared.filter.ResultFilter;
import org.gcube.portlets.user.speciesdiscovery.shared.util.NormalizeString;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResultRowDataSource
implements DataSource {
    protected boolean showOnlySelected = false;
    protected boolean isActiveFilterOnResult = false;

    public void getStreamState(AsyncCallback<StreamState> callback) {
        SpeciesDiscovery.taxonomySearchService.getSearchStatus(this.showOnlySelected, this.isActiveFilterOnResult, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getData(int start, int limit, ResultFilter activeFiltersObject, AsyncCallback<List<ModelData>> callback) {
        SpeciesDiscovery.taxonomySearchService.getSearchResultRows(start, limit, activeFiltersObject, this.showOnlySelected, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected List<ModelData> convertData(ArrayList<ResultRow> rows) {
        ArrayList<ModelData> data = new ArrayList<ModelData>(rows.size());
        for (ResultRow row : rows) {
            data.add((ModelData)this.convertResultRow(row));
        }
        return data;
    }

    public static String getClassification(List<Taxon> listTaxon) {
        StringBuilder sb = new StringBuilder();
        for (int i = listTaxon.size() - 1; i >= 0; --i) {
            Taxon taxon = listTaxon.get(i);
            sb.append("<b>");
            if (!NormalizeString.isUndefined((String)taxon.getRank())) {
                sb.append(taxon.getRank());
            } else {
                sb.append("Rank not found");
            }
            sb.append("</b>: ");
            if (!NormalizeString.isUndefined((String)taxon.getName())) {
                sb.append(taxon.getName());
            } else {
                sb.append("Name not found");
            }
            if (i == 0) continue;
            sb.append(" -> ");
        }
        return sb.toString();
    }

    protected BaseModelData convertResultRow(ResultRow row) {
        BaseModelData data = new BaseModelData();
        String dataSourceName = "";
        String dataProviderName = "";
        String dataSetName = "";
        String dataSetCitation = "";
        String matchingTaxonName = "";
        String matchingAccordionTo = "";
        String matchingRank = "";
        String matchingCredits = "";
        int imagesCount = 0;
        int mapCount = 0;
        int layerCount = 0;
        int occurencesCount = 0;
        String authorship = "";
        List listProperties = new ArrayList();
        if (row.getParents() != null) {
            if (((Taxon)row.getParents().get(0)).getName() != null) {
                matchingTaxonName = ((Taxon)row.getParents().get(0)).getName();
            }
            if (((Taxon)row.getParents().get(0)).getAccordingTo() != null) {
                matchingAccordionTo = ((Taxon)row.getParents().get(0)).getAccordingTo();
            }
            if (((Taxon)row.getParents().get(0)).getRank() != null) {
                matchingRank = ((Taxon)row.getParents().get(0)).getRank();
            }
            String rankHTML = this.getRankHtml(row.getParents());
            data.set(SpeciesGridFields.TAXON.getId(), (Object)rankHTML);
            String classificationString = ResultRowDataSource.getClassification((List)row.getParents());
            data.set(SpeciesGridFields.CLASSIFICATION_STRING.getId(), (Object)classificationString);
        }
        if (row.getDataSourceName() != null) {
            dataSourceName = row.getDataSourceName();
        }
        if (row.getDataProviderName() != null) {
            dataProviderName = row.getDataProviderName();
        }
        if (row.getDataSetName() != null) {
            dataSetName = row.getDataSetName();
        }
        if (row.getDataSetCitation() != null) {
            dataSetCitation = row.getDataSetCitation();
        }
        if (row.getMatchingCredits() != null) {
            matchingCredits = row.getMatchingCredits();
        }
        if (row.getImagesCount() != 0) {
            imagesCount = row.getImagesCount();
        }
        if (row.getMapsCount() != 0) {
            mapCount = row.getMapsCount();
        }
        if (row.getLayersCount() != 0) {
            layerCount = row.getLayersCount();
        }
        if (row.getOccurencesCount() != 0) {
            occurencesCount = row.getOccurencesCount();
        }
        if (row.getScientificNameAuthorship() != null) {
            authorship = row.getScientificNameAuthorship();
        }
        if (row.getProperties() != null) {
            listProperties = row.getProperties();
        }
        data.set(SpeciesGridFields.SELECTION.getId(), (Object)row.isSelected());
        data.set(SpeciesGridFields.DATASOURCE.getId(), (Object)dataSourceName);
        data.set(SpeciesGridFields.DATAPROVIDER.getId(), (Object)dataProviderName);
        data.set(SpeciesGridFields.DATASET.getId(), (Object)dataSetName);
        data.set(SpeciesGridFields.DATASET_CITATION.getId(), (Object)dataSetCitation);
        data.set(SpeciesGridFields.MATCHING_NAME.getId(), (Object)matchingTaxonName);
        data.set(SpeciesGridFields.MATCHING_AUTHOR.getId(), (Object)matchingAccordionTo);
        data.set(SpeciesGridFields.MATCHING_RANK.getId(), (Object)matchingRank);
        data.set(SpeciesGridFields.MATCHING_CREDITS.getId(), (Object)matchingCredits);
        data.set(SpeciesGridFields.PROPERTIES.getId(), listProperties);
        data.set(SpeciesGridFields.SCIENTIFICNAMEAUTHORSHIP.getId(), (Object)authorship);
        List listCommonName = new ArrayList();
        if (row.getCommonNames() != null) {
            listCommonName = row.getCommonNames();
        }
        String commonNames = this.getCommonNamesHTML(matchingTaxonName, matchingAccordionTo, matchingCredits, listCommonName);
        data.set(SpeciesGridFields.COMMON_NAMES.getId(), (Object)commonNames);
        data.set(SpeciesGridFields.PRODUCT_IMAGES.getId(), (Object)imagesCount);
        data.set(SpeciesGridFields.PRODUCT_MAPS.getId(), (Object)mapCount);
        data.set(SpeciesGridFields.PRODUCT_LAYERS.getId(), (Object)layerCount);
        data.set(SpeciesGridFields.PRODUCT_OCCURRENCES.getId(), (Object)occurencesCount);
        String provenance = this.getProvenanceHTML(dataSourceName, dataProviderName, dataSetName, dataSetCitation);
        data.set(SpeciesGridFields.PROVENANCE.getId(), (Object)provenance);
        String products = this.getProdutcsHTML(imagesCount, mapCount, layerCount, occurencesCount);
        data.set(SpeciesGridFields.PRODUCTS.getId(), (Object)products);
        data.set(SpeciesGridFields.ROW.getId(), (Object)row);
        Log.info((String)("Result row on client id: " + row.getId() + " service id: " + row.getServiceId()));
        return data;
    }

    protected String getRankHtml(List<Taxon> listTaxon) {
        String id = Document.get().createUniqueId();
        StringBuilder html = new StringBuilder("<p><br/>");
        int offset = html.length();
        html.append("<table id=\"");
        html.append(id);
        html.append("\">");
        boolean addToggler = false;
        for (Taxon taxon : listTaxon) {
            if (!Util.isMainTaxonomicRank((String)taxon.getRank())) {
                html.append("<tr class=\"");
                html.append("SPECIES_TOGGLE");
                html.append("\" style=\"display:none\"><td><b>");
                addToggler = true;
            } else {
                html.append("<tr><td><b>");
            }
            if (!NormalizeString.isUndefined((String)taxon.getRank())) {
                html.append(taxon.getRank());
            } else {
                html.append("Rank not found");
            }
            html.append(":</b></td><td>{");
            if (!NormalizeString.isUndefined((String)taxon.getName())) {
                html.append(taxon.getName());
            } else {
                html.append("Name not found");
            }
            html.append("}</td></tr>");
        }
        html.append("</table>");
        if (addToggler) {
            StringBuilder toggler = new StringBuilder();
            String idImgExpand = Document.get().createUniqueId();
            String idImgCollapse = Document.get().createUniqueId();
            toggler.append("<a href=\"#\" onclick=\"toggle('");
            toggler.append("SPECIES_TOGGLE");
            toggler.append("','");
            toggler.append(id);
            toggler.append("','tr');toggleSingle('");
            toggler.append(idImgExpand);
            toggler.append("');toggleSingle('");
            toggler.append(idImgCollapse);
            toggler.append("')\">");
            toggler.append("<img id=\"");
            toggler.append(idImgExpand);
            toggler.append("\" src=\"");
            toggler.append(Resources.INSTANCE.getExpand().getSafeUri().asString());
            toggler.append("\" style=\"float:left;\" />");
            toggler.append("<img id=\"");
            toggler.append(idImgCollapse);
            toggler.append("\" src=\"");
            toggler.append(Resources.INSTANCE.getCollapse().getSafeUri().asString());
            toggler.append("\" style=\"float:left;display:none\" />");
            toggler.append("</a>");
            html.insert(offset, toggler.toString());
        } else {
            html.insert(offset, "<div style=\"padding-left:" + Resources.INSTANCE.getExpand().getWidth() + "px\">");
            html.append("</div>");
        }
        html.append("</p>");
        return html.toString();
    }

    protected String getCommonNamesHTML(String scientificName, String author, String credits, List<CommonName> commonNames) {
        StringBuilder html = new StringBuilder("<p><h1 style=\"color: #385F95;\">");
        html.append(scientificName);
        html.append("</h1>");
        if (commonNames.size() > 0) {
            html.append("aka : ");
        }
        html.append("<table>");
        HashSet<String> insertedLanguages = new HashSet<String>();
        for (CommonName commonName : commonNames) {
            if (insertedLanguages.contains(commonName.getLanguage())) continue;
            insertedLanguages.add(commonName.getLanguage());
            html.append("<tr><td><b>");
            html.append(commonName.getLanguage());
            html.append(":</b></td><td>");
            html.append(commonName.getName());
            html.append("</td></tr>");
        }
        html.append("<tr></tr>");
        html.append("<tr><td><b>Inserted by: </b></td><td>");
        html.append(author);
        html.append("</td></tr>");
        html.append("<tr><td><b>Credits: </b></td><td>");
        html.append(credits);
        html.append("</td></tr>");
        html.append("</table>");
        html.append("</p>");
        return html.toString();
    }

    protected String getProvenanceHTML(String datasource, String dataprovider, String dataset, String datasetCitation) {
        StringBuilder html = new StringBuilder("<p><br/><table>");
        html.append("<tr><td><b>Data Source:</b></td><td>");
        html.append(datasource);
        html.append("</td></tr>");
        html.append("<tr><td><b>Data Provider:</b></td><td>");
        html.append(dataprovider);
        html.append("</td></tr>");
        html.append("<tr><td><b>Data Set:</b></td><td>");
        html.append(dataset);
        html.append("</td></tr>");
        html.append("<tr><td><b>Citation:</b></td><td>");
        html.append(datasetCitation);
        html.append("</td></tr>");
        html.append("</table></p>");
        return html.toString();
    }

    protected String getProdutcsHTML(int imagesCount, int mapCounts, int layersCount, int occurencesCount) {
        StringBuilder html = new StringBuilder("<p><br/><table>");
        html.append("<tr><td><b>");
        html.append(SpeciesGridFields.PRODUCT_OCCURRENCES.getName());
        html.append(":</b></td><td>");
        html.append(occurencesCount);
        html.append("</td></tr>");
        html.append("</table></p>");
        return html.toString();
    }

    public boolean isShowOnlySelected() {
        return this.showOnlySelected;
    }

    public void setShowOnlySelected(boolean showOnlySelected) {
        this.showOnlySelected = showOnlySelected;
    }

    public boolean isActiveFilterOnResult() {
        return this.isActiveFilterOnResult;
    }

    public void setActiveFilterOnResult(boolean isActiveFilterOnResult) {
        this.isActiveFilterOnResult = isActiveFilterOnResult;
    }

    public String getInfo() {
        return "ResultRowDataSource";
    }
}

