/**
 * 
 */
package org.gcube.portlets.user.td.columnwidget.client.progress;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnMonitor;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class LabelColumnProgressUpdater extends Timer {

	protected ArrayList<LabelColumnProgressListener> listeners = new ArrayList<LabelColumnProgressListener>();

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void run() {
		Log.debug("requesting operation progress");
		TDGWTServiceAsync.INSTANCE
				.getLabelColumnMonitor(new AsyncCallback<LabelColumnMonitor>() {

					
					public void onFailure(Throwable caught) {
						cancel();
						Log.error("Error retrieving the operation state",
								caught);
						String message = getStack(caught);
						fireOperationFailed(caught,
								"Failed getting operation updates", message);
					}

					public void onSuccess(LabelColumnMonitor result) {
						Log.info("retrieved LabelColumnMonitor: "
								+ result.getStatus());
						switch (result.getStatus()) {
						case INITIALIZING:
							Log.info("Change Label Column Initializing...");
							fireOperationInitializing();
							break;
						case ABORTED:
							cancel();
							Log.info("Change The Column Label Operation Aborted");
							break;
						case IN_PROGRESS:
							fireOperationUpdate(result.getProgress());
							break;
						case VALIDATING_RULES:
							fireOperationUpdate(result.getProgress());
							break;	
						case STOPPED:
							cancel();
							errorMessage(result);
							break;		
						case FAILED:
							cancel();
							errorMessage(result);
							break;
						case SUCCEDED:
							cancel();
							Log.info("Import fisnish TableId :"
									+ result.getTrId());
							fireOperationComplete(result.getTrId());
							break;
						default:
							Log.info("Unknow State");
							break;
						}

					}

					

				});

	}

	protected void errorMessage(LabelColumnMonitor result) {
		Log.info("Change the column label Failed");
		Throwable th = null;
		String failure = null;
		String details = null;
		if (result.getError() != null) {
			th = result.getError();
			failure = "Failed Client Library Changing the column label";
			details = result.getError().getLocalizedMessage();
		} else {
			th = new Throwable("Failed");
			failure = "Failed Client Library Changing the column label";
			details = "Change the column label failed";
		}
		
	
		fireOperationFailed(th, failure, details);
	}

	protected String getStack(Throwable e) {
		String message = e.getLocalizedMessage() + " -> <br>";
		Throwable c = e.getCause();
		if (c != null)
			message += getStack(c);
		return message;
	}

	protected void fireOperationInitializing() {
		for (LabelColumnProgressListener listener : listeners)
			listener.operationInitializing();
	}

	protected void fireOperationUpdate(float elaborated) {
		for (LabelColumnProgressListener listener : listeners)
			listener.operationUpdate(elaborated);
	}

	protected void fireOperationComplete(TRId trId) {
		for (LabelColumnProgressListener listener : listeners)
			listener.operationComplete(trId);
	}

	protected void fireOperationFailed(Throwable caught, String failure,
			String failureDetails) {
		for (LabelColumnProgressListener listener : listeners)
			listener.operationFailed(caught, failure, failureDetails);
	}

	/**
	 * Add a new {@link LabelColumnProgressListener} to this
	 * {@link LabelColumnProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to add.
	 */
	public void addListener(LabelColumnProgressListener listener) {
		listeners.add(listener);
	}

	/**
	 * Removes the specified {@link LabelColumnProgressListener} from this
	 * {@link LabelColumnProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to remove.
	 */
	public void removeListener(LabelColumnProgressListener listener) {
		listeners.remove(listener);
	}
}
