/**
 * 
 */
package org.gcube.portlets.user.td.columnwidget.client.progress;




import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.sencha.gxt.widget.core.client.ProgressBar;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ReplaceBatchColumnProgressBarUpdater implements ReplaceBatchColumnProgressListener {
	
	protected ProgressBar progressBar;
	
	/**
	 * Creates a new {@link ProgressBar} updater.
	 * @param progressBar the {@link ProgressBar} to update.
	 */
	public ReplaceBatchColumnProgressBarUpdater(ProgressBar progressBar) {
		this.progressBar = progressBar;
	}

	
	/**
	 * {@inheritDoc}
	 */
	public void operationComplete(TRId trId) {
		Log.info("Completed");
		progressBar.updateProgress(1, "Completed");	
		
	}

	/**
	 * {@inheritDoc}
	 */
	public void operationFailed(Throwable caught, String reason, String failureDetails) {
		Log.info("Failed");
		progressBar.updateText("Failed");
	}

	public void operationInitializing() {
		Log.info("Inizializing");
		progressBar.updateProgress(0, "Initializing...");
	}

	public void operationUpdate(float elaborated) {
		Log.info("Elaborated: "+elaborated);
		if (elaborated == 0) progressBar.updateProgress(0, "Initializing...");
		if (elaborated>0 && elaborated<1) {
			Log.trace("progress "+elaborated);
			int elab=new Float(elaborated*100).intValue();
			progressBar.updateProgress(elaborated,elab+"% Progress...");
		}
		if (elaborated == 1) progressBar.updateProgress(1, "Completing...");
		
	}
	
	@Override
	public void operationValidate(float elaborated) {
		Log.info("Validation Elaborated: "+elaborated);
		if (elaborated == 0) progressBar.updateProgress(0, "Start Validation...");
		if (elaborated>0 && elaborated<1) {
			Log.trace("Validation progress "+elaborated);
			int elab=new Float(elaborated*100).intValue();
			progressBar.updateProgress(elaborated,elab+"% Validation Progress...");
		}
		if (elaborated == 1) progressBar.updateProgress(1, "Validation...");
	}
	
	@Override
	public void operationStopped(TRId trId,String reason, String details) {
		Log.debug("Operation Stopped: ["+trId.toString()+", "+reason+", "+details+"]");
		progressBar.updateText("Validations failed");
		
	}


	@Override
	public void operationGeneratingView() {
		Log.info("Generating View...");
		progressBar.updateText("Generating View...");
		
	}

}
