package org.gcube.portlets.user.td.columnwidget.client.progress;

import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

public interface ProgressDialogListener {
	
	
	/**
	 * Called when the operation is complete.
	 */
	public void operationComplete(TRId trId);

	/**
	 * Called when the operation is failed.
	 * @param caught the failure exception.
	 * @param reason the failure reason.
	 */
	public void operationFailed(Throwable caught, String reason);
	
	

	/**
	 * Called when the operation is stopped
	 * 
	 * @param trId
	 * @param reason
	 * @param details
	 */
	public void operationStopped(TRId trId, String reason, String details);
	
	
	
}
