/**
 * 
 */
package org.gcube.portlets.user.td.columnwidget.client.progress;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResubmitMonitor;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class TaskResubmitProgressUpdater extends Timer {

	protected ArrayList<TaskResubmitProgressListener> listeners = new ArrayList<TaskResubmitProgressListener>();

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void run() {
		Log.debug("requesting operation progress");
		TDGWTServiceAsync.INSTANCE
				.getTaskResubmitMonitor(new AsyncCallback<TaskResubmitMonitor>() {

					
					public void onFailure(Throwable caught) {
						cancel();
						Log.error("Error retrieving the operation state",
								caught);
						String message = getStack(caught);
						fireOperationFailed(caught,
								"Failed getting operation updates", message);
					}

					public void onSuccess(TaskResubmitMonitor result) {
						Log.info("retrieved TaskResubmitMonitor: "
								+ result.getStatus());
						switch (result.getStatus()) {
						case INITIALIZING:
							Log.info("Initializing...");
							fireOperationInitializing();
							break;
						case ABORTED:
							cancel();
							Log.info("Aborted");
							break;
						case IN_PROGRESS:
							fireOperationUpdate(result.getProgress());
							break;
						case VALIDATING_RULES:
							fireOperationValidate(result.getProgress());
							break;	
						case GENERATING_VIEW:
							Log.info("Generating View...");
							fireOperationGeneratingView();
							break;		
						case STOPPED:
							cancel();
							stopMessage(result);
							break;		
						case FAILED:
							cancel();
							errorMessage(result);
							break;
						case SUCCEDED:
							cancel();
							Log.info("Fisnish TableId :"
									+ result.getTrId());
							fireOperationComplete(result.getTrId());
							break;
						default:
							Log.info("Unknow State");
							break;
						}

					}

					

				});

	}

	protected void errorMessage(TaskResubmitMonitor result) {
		Log.info("Task Resubmit Failed");
		Throwable th = null;
		String failure = null;
		String details = null;
		if (result.getError() != null) {
			th = result.getError();
			failure = "Failed Client Library Task Resubmit";
			details = result.getError().getLocalizedMessage();
		} else {
			th = new Throwable("Failed");
			failure = "Failed Client Library Task Resubmit";
			details = "Task Resubmit failed";
		}
		
		fireOperationFailed(th, failure, details);
	}
	
	protected void stopMessage(TaskResubmitMonitor result) {
		Log.info("Task Resubmit Stopped");
		String failure = null;
		String details = null;
		if (result.getError() != null) {	
			failure = "Stopped task resubmit";
			details = result.getError().getLocalizedMessage();
		} else {
			failure = "Stopped task resubmit";
			details = "Task Resubmit stopped";
		}
	
		fireOperationStopped(result.getTrId(),failure, details);
	}
	

	protected String getStack(Throwable e) {
		String message = e.getLocalizedMessage() + " -> <br>";
		Throwable c = e.getCause();
		if (c != null)
			message += getStack(c);
		return message;
	}

	protected void fireOperationInitializing() {
		for (TaskResubmitProgressListener listener : listeners)
			listener.operationInitializing();
	}
	
	protected void fireOperationGeneratingView() {
		for (TaskResubmitProgressListener listener : listeners)
			listener.operationGeneratingView();
	}

	protected void fireOperationUpdate(float elaborated) {
		for (TaskResubmitProgressListener listener : listeners)
			listener.operationUpdate(elaborated);
	}
	
	protected void fireOperationValidate(float elaborated) {
		for (TaskResubmitProgressListener listener : listeners)
			listener.operationValidate(elaborated);
	}

	protected void fireOperationComplete(TRId trId) {
		for (TaskResubmitProgressListener listener : listeners)
			listener.operationComplete(trId);
	}

	protected void fireOperationFailed(Throwable caught, String failure,
			String failureDetails) {
		for (TaskResubmitProgressListener listener : listeners)
			listener.operationFailed(caught, failure, failureDetails);
	}

	protected void fireOperationStopped(TRId trId, String reason, String details) {
		for (TaskResubmitProgressListener listener : listeners)
			listener.operationStopped(trId,reason, details);
	}
	
	
	/**
	 * Add a new {@link TaskResubmitProgressListener} to this
	 * {@link TaskResubmitProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to add.
	 */
	public void addListener(TaskResubmitProgressListener listener) {
		listeners.add(listener);
	}

	/**
	 * Removes the specified {@link TaskResubmitProgressListener} from this
	 * {@link TaskResubmitProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to remove.
	 */
	public void removeListener(TaskResubmitProgressListener listener) {
		listeners.remove(listener);
	}
}
