package org.gcube.portlets.user.td.columnwidget.client.batch;



import java.util.Date;

import org.gcube.portlets.user.td.columnwidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.columnwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.DimensionRow;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnSession;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutData;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutPack;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer.HBoxLayoutAlign;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.TextField;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class SingleValueReplacePanel extends FramedPanel {
	private DateTimeFormat sdf = DateTimeFormat.getFormat("yyyy-MM-dd");
	
	protected String WIDTH = "500px";
	protected String HEIGHT = "150px";
	protected EventBus eventBus;
	protected SingleValueReplaceDialog parent;
	protected ColumnData column;
	protected String value;
	protected String replaceValue;
	protected DimensionRow dimensionRow;

	protected ReplaceColumnSession replaceColumnSession;

	private TextField valueField;
	private TextField replaceValueField;
	private TextButton btnApply;
	private TextButton btnClose;

	public SingleValueReplacePanel(SingleValueReplaceDialog parent,
			String value, String replaceValue,ColumnData column, EventBus eventBus) {
		this.parent = parent;
		this.value = value;
		this.replaceValue=replaceValue;
		this.eventBus = eventBus;
		this.column = column;
		dimensionRow = null;
		Log.debug("SingleValueReplacePanel:[" + value + "]");
		initPanel();
		create();

	}
	
	

	protected void initPanel() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
	}

	protected void create() {
		valueField = new TextField();
		valueField.setValue(value);
		valueField.setReadOnly(true);

		replaceValueField = new TextField();
		if(replaceValue!=null){
			valueField.setValue(replaceValue);
		}

		btnApply = new TextButton("Replace");
		btnApply.setIcon(ResourceBundle.INSTANCE.replace());
		btnApply.setIconAlign(IconAlign.RIGHT);
		btnApply.setTitle("Replace Value");
		btnApply.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Apply");
				replaceValue();

			}
		});

		btnClose = new TextButton("Close");
		btnClose.setIcon(ResourceBundle.INSTANCE.close());
		btnClose.setIconAlign(IconAlign.RIGHT);
		btnClose.setTitle("Close");
		btnClose.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Close");
				close();

			}
		});

		HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
		flowButton.setHBoxLayoutAlign(HBoxLayoutAlign.MIDDLE);
		flowButton.setPack(BoxLayoutPack.CENTER);

		flowButton.add(btnApply, new BoxLayoutData(new Margins(2, 4, 2, 4)));
		flowButton.add(btnClose, new BoxLayoutData(new Margins(2, 4, 2, 4)));

		VerticalLayoutContainer v = new VerticalLayoutContainer();
		v.add(new FieldLabel(valueField, "Value"),
				new VerticalLayoutData(1, -1));
		v.add(new FieldLabel(replaceValueField, "Replace"),
				new VerticalLayoutData(1, -1));
		v.add(flowButton, new VerticalLayoutData(-1, 36,
				new Margins(5, 2, 5, 2)));
		add(v);

	}

	protected void replaceValue() {
		String rValue = replaceValueField.getCurrentValue();
		if (rValue == null || rValue.isEmpty()) {
			UtilsGXT3.alert("Attention", "Insert a valid replace value");
		} else {
			String checkedValue = checkTypeData(rValue);
			if (checkedValue != null && !checkedValue.isEmpty()) {
				callReplaceValue(rValue);
			} else {
				UtilsGXT3.alert("Attention",
						"Insert a valid replace value for this column");
			}
		}

	}

	protected String checkTypeData(String rValue) {
		String checked = null;
		try {
			if (column.getDataTypeName().compareTo("Boolean") == 0) {
				Boolean b = new Boolean(rValue);
				checked = b.toString();
			} else {
				if (column.getDataTypeName().compareTo("Date") == 0) {
					Date d = null;
					try {
						d = sdf.parse(rValue);
					} catch (Exception e) {
						Log.error("Unparseable using " + sdf);
						return null;
					}
					if (d != null) {
						checked = rValue;
					}
				} else {
					if (column.getDataTypeName().compareTo("Geometry") == 0) {
						checked = rValue;
					} else {
						if (column.getDataTypeName().compareTo("Integer") == 0) {
							Integer in = new Integer(rValue);
							checked = in.toString();
						} else {
							if (column.getDataTypeName().compareTo("Numeric") == 0) {
								Float fl = new Float(rValue);
								checked = fl.toString();
							} else {
								if (column.getDataTypeName().compareTo("Text") == 0) {
									checked = rValue;
								} else {

								}
							}
						}
					}
				}

			}

		} catch (Throwable e) {
			Log.debug("Error no valid type data: " + e.getLocalizedMessage());
		}

		return checked;

	}

	protected void callReplaceValue(String rValue) {
		parent.fireCompleted(rValue);
	}

	protected void close() {
		parent.close();
	}

}
