package org.gcube.portlets.user.td.columnwidget.client.progress;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.ProgressBar;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * ReplaceBatchColumnProgressDialog is a Dialog that show progress of replace
 * batch the column value
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ReplaceBatchColumnProgressDialog extends Window implements
		ReplaceBatchColumnProgressListener {
	protected ArrayList<ProgressDialogListener> listeners = new ArrayList<ProgressDialogListener>();

	public static final int STATUS_POLLING_DELAY = 1000;
	protected String WIDTH = "400px";
	protected String HEIGHT = "120px";
	protected EventBus eventBus;
	protected ReplaceBatchColumnProgressUpdater progressUpdater;
	protected TextButton ok;
	protected TRId trId;
	private String reason;
	private String details;

	public ReplaceBatchColumnProgressDialog(EventBus eventBus) {
		this.eventBus = eventBus;
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(true);
		setModal(true);
		setHeadingText("Replace Batch Progress");

		trId = null;

		FramedPanel panel = new FramedPanel();
		panel.setHeaderVisible(false);
		panel.setBodyBorder(false);

		VerticalLayoutContainer v = new VerticalLayoutContainer();

		ProgressBar progressBar = new ProgressBar();

		ok = new TextButton("OK");
		ok.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				updateInvocation();

			}
		});

		v.add(progressBar,
				new VerticalLayoutData(1, 1, new Margins(5, 5, 5, 5)));

		panel.add(v);
		panel.addButton(ok);
		add(panel);

		progressUpdater = new ReplaceBatchColumnProgressUpdater();
		progressUpdater.addListener(new ReplaceBatchColumnProgressBarUpdater(
				progressBar));

		progressUpdater.addListener(this);
		progressUpdater.scheduleRepeating(STATUS_POLLING_DELAY);
		show();
		ok.setVisible(false);

	}

	
	public void addProgressDialogListener(ProgressDialogListener listener) {
		listeners.add(listener);
	}
	
	public void removeProgressDialogListener(ProgressDialogListener listener) {
		listeners.remove(listener);
	}
	
	public void operationInitializing() {
		// TODO Auto-generated method stub

	}

	public void operationUpdate(float elaborated) {
		// TODO Auto-generated method stub

	}

	public void operationComplete(TRId trId) {
		Log.debug("Operation Complete return: " + trId.toString());
		this.trId = trId;
		fireOperationComplete(trId);
		hide();
	}

	public void operationFailed(Throwable caught, String reason,
			String failureDetails) {
		if (caught instanceof TDGWTSessionExpiredException) {
			eventBus.fireEvent(new SessionExpiredEvent(
					SessionExpiredType.EXPIREDONSERVER));
		} else {
			fireOperationFailed(caught,reason);
			hide();
			
		}
	}

	public void updateInvocation() {
		if (trId != null) {
			fireOperationStopped(trId, reason, details);
		}
		hide();

	}

	@Override
	public void operationStopped(TRId trId, String reason, String details) {
		Log.debug("Operation Stopped: [" + trId.toString() + ", " + reason
				+ ", " + details + "]");
		this.trId = trId;
		this.reason=reason;
		this.details=details;
		ok.setVisible(true);
		
	}

	@Override
	public void operationGeneratingView() {
		// TODO Auto-generated method stub

	}

	@Override
	public void operationValidate(float elaborated) {
		// TODO Auto-generated method stub

	}
	
	protected void fireOperationComplete(TRId trId) {
		for (ProgressDialogListener listener : listeners)
			listener.operationComplete(trId);
	}

	protected void fireOperationFailed(Throwable caught, String reason) {
		for (ProgressDialogListener listener : listeners)
			listener.operationFailed(caught, reason);
	}
	
	protected void fireOperationStopped(TRId trId, String reason, String details) {
		for (ProgressDialogListener listener : listeners)
			listener.operationStopped(trId,reason, details);
	}
	
	
}
