/**
 * 
 */
package org.gcube.portlets.user.td.columnwidget.client.progress;

import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;



/**
 * Defines a listener for operation progress.
 *
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public interface AddColumnProgressListener {
	
	/**
	 * Called when the operation is starting.
	 */
	public void operationInitializing();
	
	/**
	 * Called when there is a progress for the operation.
	 * @param elaborated the elaborated part.
	 */
	public void operationUpdate(float elaborated);
	
	/**
	 * Called when there is a validate for the operation.
	 * @param elaborated the elaborated part.
	 */
	public void operationValidate(float elaborated);	
	
	/**
	 * Called when the operation is complete.
	 */
	public void operationComplete(TRId trId);

	/**
	 * Called when the operation is failed.
	 * @param caught the failure exception.
	 * @param reason the failure reason.
	 */
	public void operationFailed(Throwable caught, String reason, String failureDetails);
	
	/**
	 * Called when the operation is stopped
	 * 
	 * @param trId
	 * @param reason
	 * @param details
	 */
	public void operationStopped(TRId trId, String reason, String details);
	
	/**
	 *  Called when the operation is generating the view
	 */
	public void operationGeneratingView();
	
}
