package org.gcube.portlets.user.td.columnwidget.client;

import java.util.ArrayList;
import java.util.HashMap;

import org.gcube.portlets.user.td.columnwidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.columnwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsFinalException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsLockedException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnSession;
import org.gcube.portlets.user.td.monitorwidget.client.MonitorDialog;
import org.gcube.portlets.user.td.monitorwidget.client.MonitorDialogListener;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ChangeTableRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableWhy;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.core.client.dom.ScrollSupport.ScrollMode;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.TextField;

/**
 * 
 * LabelColumnPanel is the panel for change columns labels
 * 
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class LabelColumnPanel extends FramedPanel implements
		MonitorDialogListener {
	protected static final String WIDTH = "640px";
	protected static final String HEIGHT = "520px";
	protected static final int LABELWIDTH = 140;

	protected EventBus eventBus;
	protected ChangeColumnTypeDialog parent;
	protected TextField label = null;
	protected TRId trId;
	protected String columnName;

	protected ArrayList<ColumnData> columns;
	protected SimpleContainer columnsContainer;
	protected VerticalLayoutContainer columnsLayoutContainer;

	protected TextButton change;

	protected LabelColumnSession labelColumnSession;
	private boolean updateStatus;

	public LabelColumnPanel(TRId trId, String columnName, EventBus eventBus) {
		this.trId = trId;
		this.columnName = columnName;
		this.eventBus = eventBus;
		updateStatus = false;
		Log.debug("LabelColumnPanel(): [" + trId + " columnName: " + columnName
				+ "]");
		init();
		retrieveColumns();

	}

	protected void retrieveColumns() {
		TDGWTServiceAsync.INSTANCE.getColumns(trId,
				new AsyncCallback<ArrayList<ColumnData>>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							if (caught instanceof TDGWTIsLockedException) {
								Log.error(caught.getLocalizedMessage());
								UtilsGXT3.alert("Error Locked",
										caught.getLocalizedMessage());
							} else {
								if (caught instanceof TDGWTIsFinalException) {
									Log.error(caught.getLocalizedMessage());
									UtilsGXT3.alert("Error Final",
											caught.getLocalizedMessage());
								} else {
									Log.error("load combo failure:"
											+ caught.getLocalizedMessage());
									UtilsGXT3.alert("Error",
											"Error retrieving columns of tabular resource:"
													+ trId.getId());
								}
							}
						}

					}

					public void onSuccess(ArrayList<ColumnData> result) {
						Log.trace("loaded " + result.size() + " ColumnData");
						ArrayList<ColumnData> removables = new ArrayList<ColumnData>();
						for (ColumnData c : result) {
							if (c.getTypeCode().compareTo("DIMENSION") == 0
									|| c.getTypeCode().compareTo(
											"TIMEDIMENSION") == 0) {
								removables.add(c);
							}
						}
						if (removables.size() > 0) {
							result.removeAll(removables);
						}
						columns = result;
						startCreate();

					}

				});
	}

	protected void startCreate() {
		if (updateStatus) {
			updatePanel();
		} else {
			create();
		}
	}

	protected void create() {
		Log.debug("Create LabelColunmPanel");
		SimpleContainer columnsContainer = new SimpleContainer();
		// columnsContainer.setHeight(getOffsetHeight(true)-50);

		columnsLayoutContainer = new VerticalLayoutContainer();
		columnsLayoutContainer.setScrollMode(ScrollMode.AUTO);
		columnsContainer.add(columnsLayoutContainer);

		addFields();
		columnsContainer.forceLayout();

		change = new TextButton("Change");
		change.setIcon(ResourceBundle.INSTANCE.columnLabel());
		change.setIconAlign(IconAlign.RIGHT);
		change.setTitle("Change Column Label");

		change.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				changeLabelColumns();

			}
		});

		VerticalLayoutContainer v = new VerticalLayoutContainer();
		v.setScrollMode(ScrollMode.AUTO);

		v.add(columnsContainer, new VerticalLayoutData(1, -1, new Margins(1)));
		v.add(change, new VerticalLayoutData(-1, -1, new Margins(10, 0, 10, 0)));
		add(v, new VerticalLayoutData(-1, -1, new Margins()));

		forceLayout();

	}

	protected void addFields() {
		VerticalLayoutData layoutData = new VerticalLayoutData(1, -1,
				new Margins(1));

		ArrayList<FieldLabel> fields = generateFields();
		for (FieldLabel fl : fields) {
			columnsLayoutContainer.add(fl, layoutData);

		}
		columnsLayoutContainer.onResize();
	}

	protected ArrayList<FieldLabel> generateFields() {
		ArrayList<FieldLabel> fields = new ArrayList<FieldLabel>();

		for (ColumnData col : columns) {
			if (col != null) {
				FieldLabel textLabel;
				if (col.getLabel() != null && !col.getLabel().isEmpty()) {
					TextField text = new TextField();
					text.setValue(col.getLabel());
					textLabel = new FieldLabel(text, col.getLabel());
					textLabel.setLabelWidth(LABELWIDTH);
					textLabel.setId(col.getColumnId());
				} else {
					TextField text = new TextField();
					text.setValue("nolabel");
					textLabel = new FieldLabel(text, "nolabel");
					textLabel.setLabelWidth(LABELWIDTH);
					textLabel.setId(col.getColumnId());
				}
				fields.add(textLabel);
			}

		}
		Log.debug("Fields: " + fields.size());
		return fields;
	}

	protected void init() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
	}

	public void update(TRId trId, String columnName) {
		this.trId = trId;
		this.columnName = columnName;

		updateStatus = true;
		retrieveColumns();
	}

	protected void updatePanel() {
		columnsLayoutContainer.clear();
		addFields();
		forceLayout();
	}

	protected void changeLabelColumns() {
		int i = 0;
		int lenght = columnsLayoutContainer.getWidgetCount();
		HashMap<ColumnData, String> maps = new HashMap<ColumnData, String>();

		for (; i < lenght; i++) {
			FieldLabel fieldLabel = (FieldLabel) columnsLayoutContainer
					.getWidget(i);
			String columnId = fieldLabel.getId();
			ColumnData colCurrent = null;
			for (ColumnData col : columns) {
				if (col.getColumnId().compareTo(columnId) == 0) {
					colCurrent = col;
					break;
				}
			}
			if (colCurrent == null) {
				continue;
			}

			TextField text = (TextField) fieldLabel.getWidget();
			String val = text.getCurrentValue();
			if (val == null || val.isEmpty()) {
				continue;
			}
			maps.put(colCurrent, val);

		}

		if (maps.size() > 0) {
			labelColumnSession = new LabelColumnSession(trId, maps);
			callLabelColumn();
		} else {
			UtilsGXT3.alert("Attention", "Insert valid labels!");
		}

	}

	private void callLabelColumn() {
		TDGWTServiceAsync.INSTANCE.startLabelColumn(labelColumnSession,
				new AsyncCallback<String>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							if (caught instanceof TDGWTIsLockedException) {
								Log.error(caught.getLocalizedMessage());
								UtilsGXT3.alert("Error Locked",
										caught.getLocalizedMessage());
							} else {
								if (caught instanceof TDGWTIsFinalException) {
									Log.error(caught.getLocalizedMessage());
									UtilsGXT3.alert("Error Final",
											caught.getLocalizedMessage());
								} else {
									Log.debug("Change The Column Label Error: "
											+ caught.getLocalizedMessage());
									UtilsGXT3
											.alert("Error Changing The Column Label",
													"Error in invocation of Change The Column Label operation!");
								}
							}
						}
					}

					public void onSuccess(String taskId) {
						openMonitorDialog(taskId);
					}

				});

	}

	public void close() {
		if (parent != null) {
			parent.close();
		}
	}

	// /
	protected void openMonitorDialog(String taskId) {
		MonitorDialog monitorDialog = new MonitorDialog(taskId, eventBus);
		monitorDialog.addProgressDialogListener(this);
		monitorDialog.show();
	}

	@Override
	public void operationComplete(TRId trId) {
		ChangeTableWhy why = ChangeTableWhy.TABLEUPDATED;
		ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
				ChangeTableRequestType.CHANGECOLUMNLABEL, trId, why);
		eventBus.fireEvent(changeTableRequestEvent);
		close();
	}

	@Override
	public void operationFailed(Throwable caught, String reason, String details) {
		UtilsGXT3.alert(reason, details);
		close();

	}

	@Override
	public void operationStopped(TRId trId, String reason, String details) {
		ChangeTableWhy why = ChangeTableWhy.TABLECURATION;
		ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
				ChangeTableRequestType.CHANGECOLUMNLABEL, trId, why);
		eventBus.fireEvent(changeTableRequestEvent);
		close();

	}

	@Override
	public void operationAborted() {
		close();

	}

	@Override
	public void operationPutInBackground() {
		close();

	}

}
