package org.gcube.portlets.user.td.columnwidget.client;

import java.util.ArrayList;

import org.gcube.portlets.user.td.columnwidget.client.dimension.CodelistSelectionDialog;
import org.gcube.portlets.user.td.columnwidget.client.dimension.CodelistSelectionListener;
import org.gcube.portlets.user.td.columnwidget.client.mapping.ColumnMappingDialog;
import org.gcube.portlets.user.td.columnwidget.client.mapping.ColumnMappingListProperties;
import org.gcube.portlets.user.td.columnwidget.client.mapping.ColumnMappingListener;
import org.gcube.portlets.user.td.columnwidget.client.properties.ColumnDataPropertiesCombo;
import org.gcube.portlets.user.td.columnwidget.client.properties.ColumnDataTypeProperties;
import org.gcube.portlets.user.td.columnwidget.client.properties.ColumnTypeCodeProperties;
import org.gcube.portlets.user.td.columnwidget.client.properties.LocaleTypeProperties;
import org.gcube.portlets.user.td.columnwidget.client.properties.TabResourceProperties;
import org.gcube.portlets.user.td.columnwidget.client.properties.TimeDimensionTypeProperties;
import org.gcube.portlets.user.td.columnwidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.columnwidget.client.store.ColumnDataTypeElement;
import org.gcube.portlets.user.td.columnwidget.client.store.ColumnDataTypeStore;
import org.gcube.portlets.user.td.columnwidget.client.store.ColumnTypeCodeElement;
import org.gcube.portlets.user.td.columnwidget.client.store.ColumnTypeCodeStore;
import org.gcube.portlets.user.td.columnwidget.client.store.LocaleTypeElement;
import org.gcube.portlets.user.td.columnwidget.client.store.TimeDimensionTypeElement;
import org.gcube.portlets.user.td.columnwidget.client.store.TimeDimensionTypeStore;
import org.gcube.portlets.user.td.columnwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsFinalException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsLockedException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.mapping.ColumnMappingList;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeSession;
import org.gcube.portlets.user.td.monitorwidget.client.MonitorDialog;
import org.gcube.portlets.user.td.monitorwidget.client.MonitorDialogListener;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ChangeTableRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableWhy;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.TimeDimensionType;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.client.loader.RpcProxy;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.loader.ListLoadConfig;
import com.sencha.gxt.data.shared.loader.ListLoadConfigBean;
import com.sencha.gxt.data.shared.loader.ListLoadResult;
import com.sencha.gxt.data.shared.loader.ListLoadResultBean;
import com.sencha.gxt.data.shared.loader.ListLoader;
import com.sencha.gxt.data.shared.loader.LoadResultListStoreBinding;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.event.TriggerClickEvent;
import com.sencha.gxt.widget.core.client.event.TriggerClickEvent.TriggerClickHandler;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.info.Info;

/**
 * 
 * ChangeColumnTypePanel is the panel for change column type
 * 
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ChangeColumnTypePanel extends FramedPanel implements
		CodelistSelectionListener, ColumnMappingListener, MonitorDialogListener {
	protected String WIDTH = "640px";
	protected String HEIGHT = "520px";
	protected EventBus eventBus;
	protected ChangeColumnTypeDialog parent;
	protected TextField label = null;
	protected TRId trId;
	protected String columnName;
	protected ColumnData column;
	protected ComboBox<ColumnData> comboColumn = null;
	protected ComboBox<ColumnTypeCodeElement> comboColumnTypeCode = null;

	protected ComboBox<ColumnDataTypeElement> comboMeasureType = null;
	protected FieldLabel comboMeasureTypeLabel;

	protected ComboBox<ColumnDataTypeElement> comboAttributeType = null;
	protected FieldLabel comboAttributeTypeLabel;

	protected ComboBox<TabResource> comboDimensionType = null;
	protected FieldLabel comboDimensionTypeLabel;
	protected ListStore<TabResource> storeComboDimensionType;

	protected ComboBox<ColumnData> comboColumnReferenceType = null;
	protected FieldLabel comboColumnReferenceTypeLabel;
	protected ListStore<ColumnData> storeComboColumnReferenceType;

	protected ComboBox<ColumnMappingList> comboColumnMapping = null;
	protected FieldLabel comboColumnMappingLabel;
	protected ListStore<ColumnMappingList> storeComboColumnMapping;

	protected ComboBox<TimeDimensionTypeElement> comboTimeDimensionType = null;
	protected FieldLabel comboTimeDimensionTypeLabel;

	protected ComboBox<LocaleTypeElement> comboLocaleType = null;
	protected FieldLabel comboLocaleTypeLabel;
	protected ListStore<LocaleTypeElement> storeComboLocaleType;

	protected ListLoader<ListLoadConfig, ListLoadResult<ColumnData>> loader;

	protected TextButton change;

	protected ChangeColumnTypeSession changeColumnTypeSession;

	public ChangeColumnTypePanel(TRId trId, String columnName, EventBus eventBus) {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
		this.trId = trId;
		this.columnName = columnName;
		this.eventBus = eventBus;
		create();
	}

	protected void create() {

		Log.debug("Create ChangeColumnTypePanel(): [" + trId.toString()
				+ " columnName: " + columnName + "]");

		// Column Data
		ColumnDataPropertiesCombo propsColumnData = GWT
				.create(ColumnDataPropertiesCombo.class);
		ListStore<ColumnData> storeCombo = new ListStore<ColumnData>(
				propsColumnData.id());

		Log.trace("StoreCombo created");

		RpcProxy<ListLoadConfig, ListLoadResult<ColumnData>> proxy = new RpcProxy<ListLoadConfig, ListLoadResult<ColumnData>>() {

			public void load(ListLoadConfig loadConfig,
					final AsyncCallback<ListLoadResult<ColumnData>> callback) {
				loadData(loadConfig, callback);
			}
		};

		loader = new ListLoader<ListLoadConfig, ListLoadResult<ColumnData>>(
				proxy) {
			@Override
			protected ListLoadConfig newLoadConfig() {
				return (ListLoadConfig) new ListLoadConfigBean();
			}

		};

		// loader.setRemoteSort(false);
		loader.addLoadHandler(new LoadResultListStoreBinding<ListLoadConfig, ColumnData, ListLoadResult<ColumnData>>(
				storeCombo));
		Log.trace("LoaderCombo created");

		comboColumn = new ComboBox<ColumnData>(storeCombo,
				propsColumnData.label()) {

			protected void onAfterFirstAttach() {
				super.onAfterFirstAttach();
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {
					public void execute() {
						loader.load();
					}
				});
			}
		};
		Log.trace("Combo ColumnData created");

		// addHandlersForEventObservation(comboColumn, propsColumnData.label());
		addHandlersForComboColumn(propsColumnData.label());

		comboColumn.setLoader(loader);
		comboColumn.setEmptyText("Select a column...");
		comboColumn.setWidth(191);
		comboColumn.setTypeAhead(false);
		comboColumn.setEditable(false);
		comboColumn.setTriggerAction(TriggerAction.ALL);

		// comboColumnTypeCode
		ColumnTypeCodeProperties propsColumnTypeCode = GWT
				.create(ColumnTypeCodeProperties.class);
		ListStore<ColumnTypeCodeElement> storeComboTypeCode = new ListStore<ColumnTypeCodeElement>(
				propsColumnTypeCode.id());
		storeComboTypeCode.addAll(ColumnTypeCodeStore.getColumnTypeCodes(trId));

		comboColumnTypeCode = new ComboBox<ColumnTypeCodeElement>(
				storeComboTypeCode, propsColumnTypeCode.label());
		Log.trace("ComboColumnTypeCode created");

		addHandlersForComboColumnTypeCode(propsColumnTypeCode.label());

		comboColumnTypeCode.setEmptyText("Select a column type...");
		comboColumnTypeCode.setWidth(191);
		comboColumnTypeCode.setTypeAhead(true);
		comboColumnTypeCode.setTriggerAction(TriggerAction.ALL);

		// comboMeasureType
		ColumnDataTypeProperties propsMeasureType = GWT
				.create(ColumnDataTypeProperties.class);
		ListStore<ColumnDataTypeElement> storeComboMeasureType = new ListStore<ColumnDataTypeElement>(
				propsMeasureType.id());
		storeComboMeasureType.addAll(ColumnDataTypeStore.getMeasureType());

		comboMeasureType = new ComboBox<ColumnDataTypeElement>(
				storeComboMeasureType, propsMeasureType.label());
		Log.trace("ComboMeasureType created");

		addHandlersForComboMeasureType(propsMeasureType.label());

		comboMeasureType.setEmptyText("Select a measure type...");
		comboMeasureType.setWidth(191);
		comboMeasureType.setTypeAhead(true);
		comboMeasureType.setTriggerAction(TriggerAction.ALL);

		comboMeasureTypeLabel = new FieldLabel(comboMeasureType, "Measure Type");

		// comboAttributeType
		ColumnDataTypeProperties propsAttributeType = GWT
				.create(ColumnDataTypeProperties.class);
		ListStore<ColumnDataTypeElement> storeComboAttributeType = new ListStore<ColumnDataTypeElement>(
				propsAttributeType.id());
		storeComboAttributeType.addAll(ColumnDataTypeStore.getAttributeType());

		comboAttributeType = new ComboBox<ColumnDataTypeElement>(
				storeComboAttributeType, propsAttributeType.label());
		Log.trace("ComboAttributeType created");

		addHandlersForComboAttributeType(propsAttributeType.label());

		comboAttributeType.setEmptyText("Select a column type...");
		comboAttributeType.setWidth(191);
		comboAttributeType.setTypeAhead(true);
		comboAttributeType.setTriggerAction(TriggerAction.ALL);

		comboAttributeTypeLabel = new FieldLabel(comboAttributeType,
				"Attribute Type");

		// comboLocaleType
		LocaleTypeProperties propsLocaleType = GWT
				.create(LocaleTypeProperties.class);
		storeComboLocaleType = new ListStore<LocaleTypeElement>(
				propsLocaleType.id());

		comboLocaleType = new ComboBox<LocaleTypeElement>(storeComboLocaleType,
				propsLocaleType.label()) {

			protected void onAfterFirstAttach() {
				super.onAfterFirstAttach();
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {
					public void execute() {
						retriveLocales();
					}
				});
			}
		};
		Log.trace("ComboLocaleType created");

		addHandlersForComboLocaleType(propsLocaleType.label());

		comboLocaleType.setEmptyText("Select a locale type...");
		comboLocaleType.setWidth(191);
		comboLocaleType.setTypeAhead(true);
		comboLocaleType.setTriggerAction(TriggerAction.ALL);

		comboLocaleTypeLabel = new FieldLabel(comboLocaleType, "Locale");

		// comboDimensionType
		TabResourceProperties propsDimensionType = GWT
				.create(TabResourceProperties.class);
		storeComboDimensionType = new ListStore<TabResource>(
				propsDimensionType.id());

		comboDimensionType = new ComboBox<TabResource>(storeComboDimensionType,
				propsDimensionType.label());
		Log.trace("ComboDimensionType created");

		addHandlersForComboDimensionType(propsDimensionType.label());

		comboDimensionType.setEmptyText("Select a Dimension...");
		comboDimensionType.setWidth(191);
		comboDimensionType.setEditable(false);
		comboDimensionType.setTriggerAction(TriggerAction.ALL);

		comboDimensionTypeLabel = new FieldLabel(comboDimensionType, "Codelist");

		// ColumnReferenceType
		ColumnDataPropertiesCombo propsColumnReferenceType = GWT
				.create(ColumnDataPropertiesCombo.class);
		storeComboColumnReferenceType = new ListStore<ColumnData>(
				propsColumnReferenceType.id());

		comboColumnReferenceType = new ComboBox<ColumnData>(
				storeComboColumnReferenceType, propsColumnReferenceType.label());
		Log.trace("ComboColumnReferenceType created");

		addHandlersForComboColumnReferenceType(propsColumnReferenceType.label());

		comboColumnReferenceType.setEmptyText("Select a Column Reference...");
		comboColumnReferenceType.setWidth(191);
		comboColumnReferenceType.setEditable(false);
		comboColumnReferenceType.setTriggerAction(TriggerAction.ALL);

		comboColumnReferenceTypeLabel = new FieldLabel(
				comboColumnReferenceType, "Column");

		// TODO
		// ColumnMapping
		ColumnMappingListProperties propsColumnMapping = GWT
				.create(ColumnMappingListProperties.class);
		storeComboColumnMapping = new ListStore<ColumnMappingList>(
				propsColumnMapping.id());

		comboColumnMapping = new ComboBox<ColumnMappingList>(
				storeComboColumnMapping, propsColumnMapping.name());
		Log.trace("ComboColumnMapping created");

		addHandlersForComboColumnMapping(propsColumnMapping.name());

		comboColumnMapping.setEmptyText("Select optional mapping...");
		comboColumnMapping.setWidth(191);
		comboColumnMapping.setEditable(false);
		comboColumnMapping.setTriggerAction(TriggerAction.ALL);

		comboColumnMappingLabel = new FieldLabel(comboColumnMapping, "Mapping");

		// comboTimeDimensionType
		TimeDimensionTypeProperties propsTimeDimensionType = GWT
				.create(TimeDimensionTypeProperties.class);
		ListStore<TimeDimensionTypeElement> storeComboTimeDimensionType = new ListStore<TimeDimensionTypeElement>(
				propsTimeDimensionType.id());
		storeComboTimeDimensionType.addAll(TimeDimensionTypeStore
				.getTimeDimensionType());

		/*
		 * ListView<TimeDimensionTypeElement, String> view = new
		 * ListView<TimeDimensionTypeElement,
		 * String>(storeComboTimeDimensionType,
		 * propsTimeDimensionType.viewLabel()); view.setWidth("150px");
		 */
		comboTimeDimensionType = new ComboBox<TimeDimensionTypeElement>(
				storeComboTimeDimensionType, propsTimeDimensionType.label());
		Log.trace("ComboTimeDimensionType created");

		addHandlersForComboTimeDimensionType(propsTimeDimensionType.label());

		comboTimeDimensionType.setEmptyText("Select a time dimension type...");
		comboTimeDimensionType.setWidth(191);
		comboTimeDimensionType.setTypeAhead(true);
		comboTimeDimensionType.setTriggerAction(TriggerAction.ALL);
		// comboTimeDimensionType.getListView().getElement().applyStyles("width:170px;");

		comboTimeDimensionTypeLabel = new FieldLabel(comboTimeDimensionType,
				"Time Type");

		// Change
		change = new TextButton("Change");
		change.setIcon(ResourceBundle.INSTANCE.columnType());
		change.setIconAlign(IconAlign.RIGHT);
		change.setTitle("Change Column Type");

		SelectHandler changeHandler = new SelectHandler() {

			public void onSelect(SelectEvent event) {
				onChangeTypeColumn();

			}
		};
		change.addSelectHandler(changeHandler);

		VerticalLayoutContainer v = new VerticalLayoutContainer();
		v.add(new FieldLabel(comboColumn, "Column"), new VerticalLayoutData(1,
				-1, new Margins(1)));
		v.add(new FieldLabel(comboColumnTypeCode, "Column Type"),
				new VerticalLayoutData(1, -1, new Margins(1)));
		v.add(comboLocaleTypeLabel, new VerticalLayoutData(1, -1,
				new Margins(1)));
		v.add(comboMeasureTypeLabel, new VerticalLayoutData(1, -1, new Margins(
				1)));
		v.add(comboAttributeTypeLabel, new VerticalLayoutData(1, -1,
				new Margins(1)));
		v.add(comboDimensionTypeLabel, new VerticalLayoutData(1, -1,
				new Margins(1)));
		v.add(comboColumnReferenceTypeLabel, new VerticalLayoutData(1, -1,
				new Margins(1)));
		/*
		 * v.add(comboColumnMappingLabel, new VerticalLayoutData(1, -1, new
		 * Margins(1)));
		 */
		v.add(comboTimeDimensionTypeLabel, new VerticalLayoutData(1, -1,
				new Margins(1)));
		v.add(change, new VerticalLayoutData(-1, -1, new Margins(10, 0, 10, 0)));
		add(v, new VerticalLayoutData(-1, -1, new Margins(0)));

		comboMeasureTypeLabel.setVisible(false);
		comboAttributeTypeLabel.setVisible(false);
		comboDimensionTypeLabel.setVisible(false);
		comboColumnReferenceTypeLabel.setVisible(false);
		comboColumnMappingLabel.setVisible(false);
		comboTimeDimensionTypeLabel.setVisible(false);
		comboLocaleTypeLabel.setVisible(false);

		// addButton();
	}

	protected void addHandlersForComboColumn(
			final LabelProvider<ColumnData> labelProvider) {
		comboColumn.addSelectionHandler(new SelectionHandler<ColumnData>() {
			public void onSelection(SelectionEvent<ColumnData> event) {
				Info.display(
						"Column Type Selected",
						"You selected "
								+ (event.getSelectedItem() == null ? "nothing"
										: labelProvider.getLabel(event
												.getSelectedItem()) + "!"));
				Log.debug("ComboColumn selected: " + event.getSelectedItem());
				ColumnData columnData = event.getSelectedItem();
				updateComboStatus(columnData);
			}

		});
	}

	// TODO
	protected void addHandlersForComboColumnTypeCode(
			final LabelProvider<ColumnTypeCodeElement> labelProvider) {
		comboColumnTypeCode
				.addSelectionHandler(new SelectionHandler<ColumnTypeCodeElement>() {
					public void onSelection(
							SelectionEvent<ColumnTypeCodeElement> event) {
						Info.display(
								"Column Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboColumnTypeCode selected: "
								+ event.getSelectedItem());
						ColumnTypeCodeElement columnType = event
								.getSelectedItem();
						updateColumnType(columnType.getCode());
					}

				});
	}

	protected void addHandlersForComboMeasureType(
			final LabelProvider<ColumnDataTypeElement> labelProvider) {
		comboMeasureType
				.addSelectionHandler(new SelectionHandler<ColumnDataTypeElement>() {
					public void onSelection(
							SelectionEvent<ColumnDataTypeElement> event) {
						Info.display(
								"Measure Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboMeasureType selected: "
								+ event.getSelectedItem());
						ColumnDataTypeElement measureType = event
								.getSelectedItem();
						updateMeasureType(measureType.getType());
					}

				});
	}

	protected void addHandlersForComboAttributeType(
			final LabelProvider<ColumnDataTypeElement> labelProvider) {
		comboAttributeType
				.addSelectionHandler(new SelectionHandler<ColumnDataTypeElement>() {
					public void onSelection(
							SelectionEvent<ColumnDataTypeElement> event) {
						Info.display(
								"Attribute Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboAttributeType selected: "
								+ event.getSelectedItem());
						ColumnDataTypeElement attributeType = event
								.getSelectedItem();
						updateAttributeType(attributeType.getType());
					}

				});
	}

	protected void addHandlersForComboLocaleType(
			final LabelProvider<LocaleTypeElement> labelProvider) {
		comboLocaleType
				.addSelectionHandler(new SelectionHandler<LocaleTypeElement>() {
					public void onSelection(
							SelectionEvent<LocaleTypeElement> event) {
						Info.display(
								"Locale Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboLocaleType selected: "
								+ event.getSelectedItem());
						LocaleTypeElement localeType = event.getSelectedItem();
						updateLocaleType(localeType);
					}

				});
	}

	protected void addHandlersForComboDimensionType(
			final LabelProvider<TabResource> labelProvider) {

		comboDimensionType.addTriggerClickHandler(new TriggerClickHandler() {

			@Override
			public void onTriggerClick(TriggerClickEvent event) {
				Log.debug("ComboDimension TriggerClickEvent");
				callDialogCodelistSelection();
				comboDimensionType.collapse();

			}

		});

	}

	protected void addHandlersForComboColumnReferenceType(
			final LabelProvider<ColumnData> labelProvider) {

		comboColumnReferenceType
				.addSelectionHandler(new SelectionHandler<ColumnData>() {
					public void onSelection(SelectionEvent<ColumnData> event) {
						Info.display(
								"Column Reference Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboColumnReferenceType selected: "
								+ event.getSelectedItem());

						// TODO Mapping fix
						/*
						 * comboColumnMapping.reset();
						 * storeComboColumnMapping.clear();
						 * storeComboColumnMapping.commitChanges();
						 * comboColumnMappingLabel.setVisible(true);
						 * forceLayout();
						 */

					}

				});

	}

	protected void addHandlersForComboColumnMapping(
			final LabelProvider<ColumnMappingList> labelProvider) {

		comboColumnMapping.addTriggerClickHandler(new TriggerClickHandler() {

			@Override
			public void onTriggerClick(TriggerClickEvent event) {
				Log.debug("ComboColumnMapping TriggerClickEvent");
				callColumnMappingDialog();
				comboColumnMapping.collapse();

			}

		});

	}

	protected void addHandlersForComboTimeDimensionType(
			final LabelProvider<TimeDimensionTypeElement> labelProvider) {
		comboTimeDimensionType
				.addSelectionHandler(new SelectionHandler<TimeDimensionTypeElement>() {
					public void onSelection(
							SelectionEvent<TimeDimensionTypeElement> event) {
						Info.display(
								"Time Dimension Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboTimeDimensionType selected: "
								+ event.getSelectedItem());
						TimeDimensionTypeElement timeDimensionType = event
								.getSelectedItem();
						updateTimeDimensionType(timeDimensionType.getType());
					}

				});
	}

	// TODO
	protected void updateColumnType(ColumnTypeCode type) {
		Log.debug("Update ColumnTypeCode: " + type);
		switch (type) {
		case CODENAME:
			comboLocaleTypeLabel.setVisible(true);
			comboMeasureTypeLabel.setVisible(false);
			comboAttributeTypeLabel.setVisible(false);
			comboDimensionTypeLabel.setVisible(false);
			comboColumnReferenceTypeLabel.setVisible(false);
			comboColumnMappingLabel.setVisible(false);
			comboTimeDimensionTypeLabel.setVisible(false);
			break;
		case ATTRIBUTE:
			comboLocaleTypeLabel.setVisible(false);
			comboMeasureTypeLabel.setVisible(false);
			comboAttributeTypeLabel.setVisible(true);
			comboDimensionTypeLabel.setVisible(false);
			comboColumnReferenceTypeLabel.setVisible(false);
			comboColumnMappingLabel.setVisible(false);
			comboTimeDimensionTypeLabel.setVisible(false);
			break;
		case DIMENSION:
			comboLocaleTypeLabel.setVisible(false);
			comboMeasureTypeLabel.setVisible(false);
			comboAttributeTypeLabel.setVisible(false);
			comboDimensionTypeLabel.setVisible(true);
			comboColumnReferenceTypeLabel.setVisible(false);
			comboColumnMappingLabel.setVisible(false);
			comboTimeDimensionTypeLabel.setVisible(false);
			break;
		case MEASURE:
			comboLocaleTypeLabel.setVisible(false);
			comboMeasureTypeLabel.setVisible(true);
			comboAttributeTypeLabel.setVisible(false);
			comboDimensionTypeLabel.setVisible(false);
			comboColumnReferenceTypeLabel.setVisible(false);
			comboColumnMappingLabel.setVisible(false);
			comboTimeDimensionTypeLabel.setVisible(false);
			break;
		case TIMEDIMENSION:
			comboLocaleTypeLabel.setVisible(false);
			comboMeasureTypeLabel.setVisible(false);
			comboAttributeTypeLabel.setVisible(false);
			comboDimensionTypeLabel.setVisible(false);
			comboColumnReferenceTypeLabel.setVisible(false);
			comboColumnMappingLabel.setVisible(false);
			comboTimeDimensionTypeLabel.setVisible(true);
			break;
		default:
			comboLocaleTypeLabel.setVisible(false);
			comboMeasureTypeLabel.setVisible(false);
			comboAttributeTypeLabel.setVisible(false);
			comboDimensionTypeLabel.setVisible(false);
			comboColumnReferenceTypeLabel.setVisible(false);
			comboColumnMappingLabel.setVisible(false);
			comboTimeDimensionTypeLabel.setVisible(false);
			break;
		}

		// Reset comboDimensionType
		comboDimensionType.reset();
		comboDimensionType.clear();
		storeComboDimensionType.commitChanges();
		forceLayout();
	}

	protected void updateMeasureType(ColumnDataType type) {

	}

	protected void updateAttributeType(ColumnDataType type) {

	}

	protected void updateLocaleType(LocaleTypeElement type) {

	}

	protected void updateTimeDimensionType(TimeDimensionType type) {

	}

	protected void loadData(ListLoadConfig loadConfig,
			final AsyncCallback<ListLoadResult<ColumnData>> callback) {
		TDGWTServiceAsync.INSTANCE.getColumns(trId,
				new AsyncCallback<ArrayList<ColumnData>>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							if (caught instanceof TDGWTIsLockedException) {
								Log.error(caught.getLocalizedMessage());
								UtilsGXT3.alert("Error Locked",
										caught.getLocalizedMessage());
							} else {
								if (caught instanceof TDGWTIsFinalException) {
									Log.error(caught.getLocalizedMessage());
									UtilsGXT3.alert("Error Final",
											caught.getLocalizedMessage());
								} else {
									Log.error("load combo failure:"
											+ caught.getLocalizedMessage());
									UtilsGXT3.alert("Error",
											"Error retrieving columns of tabular resource:"
													+ trId.getId());
								}
							}
						}
						callback.onFailure(caught);
					}

					public void onSuccess(ArrayList<ColumnData> result) {
						Log.trace("loaded " + result.size() + " ColumnData");
						setComboStatus(result);
						callback.onSuccess(new ListLoadResultBean<ColumnData>(
								result));

					}

				});

	}

	protected void setComboStatus(ArrayList<ColumnData> result) {
		Log.debug("ColumnName:" + columnName);
		if (columnName != null) {
			for (ColumnData cd : result) {
				Log.debug("ColumnData name:" + cd.getName());
				if (cd.getName().compareTo(columnName) == 0) {

					updateComboStatus(cd);
				}
			}
		}
	}

	protected void updateComboStatus(ColumnData cd) {
		Log.debug("ColumnData: " + cd.toString());
		changeColumnTypeSession = new ChangeColumnTypeSession();
		changeColumnTypeSession.setColumnData(cd);
		comboColumn.setValue(cd);
		comboColumnTypeCode.setValue(ColumnTypeCodeStore.selectedElement(cd
				.getTypeCode()));
		ColumnTypeCode type = ColumnTypeCodeStore.selected(cd.getTypeCode());
		changeColumnTypeSession.setColumnTypeCode(type);
		updateColumnType(type);
		if (type == ColumnTypeCode.MEASURE) {
			changeColumnTypeSession.setColumnDataType(ColumnDataTypeStore
					.selectedMeasure(cd.getDataTypeName()));
			comboMeasureType.setValue(ColumnDataTypeStore
					.selectedMeasureElement(cd.getDataTypeName()));

		} else {
			if (type == ColumnTypeCode.ATTRIBUTE) {
				changeColumnTypeSession.setColumnDataType(ColumnDataTypeStore
						.selectedAttribute(cd.getDataTypeName()));
				comboAttributeType.setValue(ColumnDataTypeStore
						.selectedAttributeElement(cd.getDataTypeName()));
			} else {
				if (type == ColumnTypeCode.CODENAME) {
					setLocale(cd.getLocale());
				} else {
					// TODO Add TimeDimension and Dimension information to
					// ColumnData
					/*
					 * if (type == ColumnTypeCode.TIMEDIMENSION) {
					 * changeColumnTypeSession
					 * .setColumnDataType(ColumnDataTypeStore
					 * .selectedAttribute(cd.getDataTypeName()));
					 * comboTimeDimensionType.setValue(TimeDimensionTypeStore
					 * .selectedAttributeElement(cd.getDataTypeName())); } else
					 * {
					 * 
					 * }
					 */
				}
			}

		}
	}

	public void update(TRId trId, String columnName) {
		this.trId = trId;
		this.columnName = columnName;
		loader.load();
	}

	protected void onChangeTypeColumn() {

		ColumnData columnData = comboColumn.getCurrentValue();
		if (columnData != null) {
			ColumnTypeCodeElement columnTypeCodeElement = comboColumnTypeCode
					.getCurrentValue();
			if (columnTypeCodeElement != null) {
				ColumnTypeCode type = columnTypeCodeElement.getCode();
				ColumnDataTypeElement columnDataTypeElement;
				switch (type) {
				case MEASURE:
					changeColumnTypeSession.setColumnTypeCodeTarget(type);
					columnDataTypeElement = comboMeasureType.getCurrentValue();
					if (columnDataTypeElement != null) {
						ColumnDataType dataType = columnDataTypeElement
								.getType();
						if (dataType != null) {
							changeColumnTypeSession
									.setColumnDataTypeTarget(dataType);
							callChangeColumnType();
						} else {
							UtilsGXT3.alert("Attention",
									"Column data type not selected!");
						}

					} else {
						UtilsGXT3.alert("Attention",
								"Column data type not selected!");
					}
					break;
				case ATTRIBUTE:
					changeColumnTypeSession.setColumnTypeCodeTarget(type);
					columnDataTypeElement = comboAttributeType
							.getCurrentValue();
					if (columnDataTypeElement != null) {
						ColumnDataType dataType = columnDataTypeElement
								.getType();
						if (dataType != null) {
							changeColumnTypeSession
									.setColumnDataTypeTarget(dataType);
							callChangeColumnType();
						} else {
							UtilsGXT3.alert("Attention",
									"Column data type not selected!");
						}
					} else {
						UtilsGXT3.alert("Attention",
								"Column data type not selected!");
					}
					break;
				case CODE:
					changeColumnTypeSession.setColumnTypeCodeTarget(type);
					callChangeColumnType();
					break;
				case CODENAME:
					changeColumnTypeSession.setColumnTypeCodeTarget(type);
					LocaleTypeElement locale = comboLocaleType
							.getCurrentValue();
					if (locale != null) {
						changeColumnTypeSession.setLocale(locale
								.getLocaleName());
						callChangeColumnType();
					} else {
						UtilsGXT3.alert("Attention", "No locale selected!");
					}
					break;
				case CODEDESCRIPTION:
					changeColumnTypeSession.setColumnTypeCodeTarget(type);
					callChangeColumnType();
					break;
				case ANNOTATION:
					changeColumnTypeSession.setColumnTypeCodeTarget(type);
					callChangeColumnType();
					break;
				case DIMENSION:
					changeColumnTypeSession.setColumnTypeCodeTarget(type);
					ColumnData columnReference = comboColumnReferenceType
							.getCurrentValue();
					if (columnReference != null) {
						ColumnMappingList mapping = comboColumnMapping
								.getValue();
						if (mapping != null) {
							changeColumnTypeSession
									.setColumnMappingList(mapping);
						}
						changeColumnTypeSession
								.setCodelistColumnReference(columnReference);
						callChangeColumnType();
					} else {
						UtilsGXT3.alert("Attention",
								"No column reference selected!");
					}
					break;
				case TIMEDIMENSION:
					changeColumnTypeSession.setColumnTypeCodeTarget(type);
					TimeDimensionTypeElement timeDimensionTypeElement = comboTimeDimensionType
							.getCurrentValue();
					if (timeDimensionTypeElement != null) {
						TimeDimensionType timeDimensionType = timeDimensionTypeElement
								.getType();
						if (timeDimensionType != null) {
							changeColumnTypeSession
									.setTimeDimensionType(timeDimensionType);
							callChangeColumnType();
						} else {
							UtilsGXT3.alert("Attention",
									"Time Dimension type not selected!");
						}

					} else {
						UtilsGXT3.alert("Attention",
								"Time Dimension type not selected!");
					}
					break;
				default:
					UtilsGXT3.alert("Attention",
							"This column type is not supported now!");
					break;
				}
			} else {
				UtilsGXT3.alert("Attention", "Select a column type!");
			}
		} else {
			UtilsGXT3.alert("Attention", "Select a column!");
		}
	}

	private void callChangeColumnType() {
		TDGWTServiceAsync.INSTANCE.startChangeColumnType(
				changeColumnTypeSession, new AsyncCallback<String>() {
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							if (caught instanceof TDGWTIsLockedException) {
								Log.error(caught.getLocalizedMessage());
								UtilsGXT3.alert("Error Locked",
										caught.getLocalizedMessage());
							} else {
								if (caught instanceof TDGWTIsFinalException) {
									Log.error(caught.getLocalizedMessage());
									UtilsGXT3.alert("Error Final",
											caught.getLocalizedMessage());
								} else {
									Log.debug("Change Column Type Error: "
											+ caught.getLocalizedMessage());
									UtilsGXT3
											.alert("Change Column Type Error ",
													"Error in invocation of  change column type operation!");
								}
							}
						}
					}

					public void onSuccess(String taskId) {
						openMonitorDialog(taskId);

					}

				});

	}

	protected void callDialogCodelistSelection() {
		CodelistSelectionDialog dialogCodelistSelection = new CodelistSelectionDialog(
				eventBus);
		dialogCodelistSelection.addListener(this);
		dialogCodelistSelection.show();
	}

	@Override
	public void selected(TabResource tabResource) {
		Log.debug("Selected Codelist: " + tabResource);
		comboDimensionType.setValue(tabResource, true);

		retrieveColumnData(tabResource);
	}

	@Override
	public void aborted() {
		Log.debug("Select Codelist Aborted");

	}

	@Override
	public void failed(String reason, String detail) {
		Log.error("Select Codelist Failed[reason: " + reason + " , detail:"
				+ detail + "]");

	}

	protected void retrieveColumnData(TabResource tabResource) {
		TDGWTServiceAsync.INSTANCE.getColumnsForDimension(
				tabResource.getTrId(),
				new AsyncCallback<ArrayList<ColumnData>>() {

					@Override
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							if (caught instanceof TDGWTIsLockedException) {
								Log.error(caught.getLocalizedMessage());
								UtilsGXT3.alert("Error Locked",
										caught.getLocalizedMessage());
							} else {
								if (caught instanceof TDGWTIsFinalException) {
									Log.error(caught.getLocalizedMessage());
									UtilsGXT3.alert("Error Final",
											caught.getLocalizedMessage());
								} else {
									Log.debug("Error retrieving columns: "
											+ caught.getLocalizedMessage());
									UtilsGXT3
											.alert("Error retrieving columns",
													"Error retrieving columns on server!");
								}
							}
						}
					}

					@Override
					public void onSuccess(ArrayList<ColumnData> result) {
						comboColumnReferenceType.reset();
						storeComboColumnReferenceType.clear();
						storeComboColumnReferenceType.addAll(result);
						storeComboColumnReferenceType.commitChanges();
						comboColumnReferenceTypeLabel.setVisible(true);
						forceLayout();
					}
				});

	}

	protected void retriveLocales() {
		TDGWTServiceAsync.INSTANCE
				.getLocales(new AsyncCallback<ArrayList<String>>() {

					@Override
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							if (caught instanceof TDGWTIsLockedException) {
								Log.error(caught.getLocalizedMessage());
								UtilsGXT3.alert("Error Locked",
										caught.getLocalizedMessage());
							} else {
								if (caught instanceof TDGWTIsFinalException) {
									Log.error(caught.getLocalizedMessage());
									UtilsGXT3.alert("Error Final",
											caught.getLocalizedMessage());
								} else {
									Log.debug(caught.getLocalizedMessage());
									UtilsGXT3.alert("Error retrieving locales",
											caught.getLocalizedMessage());
								}
							}
						}
					}

					@Override
					public void onSuccess(ArrayList<String> result) {
						storeComboLocaleType.clear();
						ArrayList<LocaleTypeElement> locales = new ArrayList<LocaleTypeElement>();
						LocaleTypeElement locale;
						for (String local : result) {
							locale = new LocaleTypeElement(local);
							locales.add(locale);
						}
						storeComboLocaleType.addAll(locales);
						storeComboLocaleType.commitChanges();
						// comboColumnReferenceTypeLabel.setVisible(true);

					}
				});

	}

	protected void setLocale(String locale) {
		for (LocaleTypeElement loc : storeComboLocaleType.getAll()) {
			if (loc.getLocaleName().compareTo(locale) == 0) {
				comboLocaleType.setValue(loc);
				break;
			}
		}
	}

	// TODO
	protected void callColumnMappingDialog() {
		ColumnData selectedColumn = comboColumn.getCurrentValue();
		if (selectedColumn == null) {
			UtilsGXT3.alert("Attention", "Column not selected!");
			return;
		}

		TabResource dimensionTR = comboDimensionType.getValue();
		if (dimensionTR == null) {
			UtilsGXT3.alert("Attention", "Codelist not selected!");
			return;
		}

		ColumnData referenceColumn = comboColumnReferenceType.getValue();
		if (referenceColumn == null) {
			UtilsGXT3.alert("Attention", "Reference column not selected!");
			return;
		}

		ColumnMappingDialog columnMappingDialog = new ColumnMappingDialog(trId,
				selectedColumn, dimensionTR, referenceColumn, eventBus);
		columnMappingDialog.addColumnMappingListener(this);
		columnMappingDialog.show();
	}

	@Override
	public void selectedColumnMapping(ColumnMappingList columnMappingList) {
		Log.debug("Selected ColumnMapping: " + columnMappingList);
		comboColumnMapping.setValue(columnMappingList, true);

	}

	@Override
	public void abortedColumnMapping() {
		Log.debug("Column Mapping selection Aborted");

	}

	@Override
	public void failedColumnMapping(String reason, String detail) {
		Log.error("Error selecting Column Mapping:" + reason + " " + detail);

	}

	public void close() {
		if (parent != null) {
			parent.close();
		}
	}

	// /
	protected void openMonitorDialog(String taskId) {
		MonitorDialog monitorDialog = new MonitorDialog(taskId, eventBus);
		monitorDialog.addProgressDialogListener(this);
		monitorDialog.show();
	}

	@Override
	public void operationComplete(TRId trId) {
		ChangeTableWhy why = ChangeTableWhy.TABLEUPDATED;
		ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
				ChangeTableRequestType.CHANGECOLUMNTYPE, trId, why);
		eventBus.fireEvent(changeTableRequestEvent);
		close();
	}

	@Override
	public void operationFailed(Throwable caught, String reason, String details) {
		UtilsGXT3.alert(reason, details);
		close();

	}

	@Override
	public void operationStopped(TRId trId, String reason, String details) {
		ChangeTableWhy why = ChangeTableWhy.TABLECURATION;
		ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
				ChangeTableRequestType.CHANGECOLUMNTYPE, trId, why);
		eventBus.fireEvent(changeTableRequestEvent);
		close();

	}

	@Override
	public void operationAborted() {
		close();

	}

	@Override
	public void operationPutInBackground() {
		close();

	}

}
