package org.gcube.portlets.user.td.columnwidget.client.create;

import java.util.ArrayList;

import org.gcube.portlets.user.td.columnwidget.client.properties.ColumnTypeCodeProperties;
import org.gcube.portlets.user.td.columnwidget.client.properties.LocaleTypeProperties;
import org.gcube.portlets.user.td.columnwidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.columnwidget.client.store.ColumnTypeCodeElement;
import org.gcube.portlets.user.td.columnwidget.client.store.ColumnTypeCodeStore;
import org.gcube.portlets.user.td.columnwidget.client.store.LocaleTypeElement;
import org.gcube.portlets.user.td.columnwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsFinalException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsLockedException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.DefNewColumn;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.TableType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.dom.ScrollSupport.ScrollMode;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutData;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutPack;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer.HBoxLayoutAlign;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.info.Info;

/**
 * 
 * @author "Giancarlo Panichi"
 * 
 */
public class CreateDefColumnPanel extends FramedPanel {
	protected static final String WIDTH = "448px";
	protected static final String HEIGHT = "180px";
	protected static final String FIELDWIDTH = "436px";
	protected static final String FIELDSHEIGHT = "130px";

	protected ArrayList<CreateDefColumnListener> listeners;

	protected EventBus eventBus;
	protected CreateDefColumnDialog parent;
	protected TableType tableType;

	protected ComboBox<ColumnTypeCodeElement> comboColumnTypeCode = null;
	protected FieldLabel comboColumnTypeCodeLabel;

	protected ComboBox<LocaleTypeElement> comboLocaleType = null;
	protected FieldLabel comboLocaleTypeLabel;
	protected ListStore<LocaleTypeElement> storeComboLocaleType;

	private TextButton btnSave;
	private TextButton btnClose;
	private SimpleContainer form;
	private VerticalLayoutContainer formLayout;
	private TextField label;
	private TextField defaultValue;

	/**
	 * 
	 * @param parent
	 * @param eventBus
	 */
	public CreateDefColumnPanel(CreateDefColumnDialog parent,
			TableType tableType, EventBus eventBus) {
		super();
		Log.debug("CreateDefColumnPanel[parent: " + parent + ", tableType: "
				+ tableType);
		this.parent = parent;
		this.eventBus = eventBus;
		this.tableType = tableType;
		initListeners();
		init();
		create();
	}

	protected void init() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
	}

	protected void initListeners() {
		listeners = new ArrayList<CreateDefColumnListener>();
	}

	protected void create() {
		// Label
		label = new TextField();
		FieldLabel nameLabel = new FieldLabel(label, "Column Label");

		// Default Value
		defaultValue = new TextField();
		FieldLabel defaultValueLabel = new FieldLabel(defaultValue,
				"Default Value");

		// comboColumnTypeCode
		ColumnTypeCodeProperties propsColumnTypeCode = GWT
				.create(ColumnTypeCodeProperties.class);
		ListStore<ColumnTypeCodeElement> storeComboTypeCode = new ListStore<ColumnTypeCodeElement>(
				propsColumnTypeCode.id());

		switch (tableType) {
		case CODELIST:
			storeComboTypeCode.addAll(ColumnTypeCodeStore
					.getColumnTypeCodesForCodelist());
			break;
		case DATASET:
			storeComboTypeCode.addAll(ColumnTypeCodeStore
					.getColumnTypeCodesForDataset());
			break;
		case GENERIC:
			storeComboTypeCode.addAll(ColumnTypeCodeStore
					.getColumnTypeCodesForGeneric());
			break;
		default:
			break;

		}

		comboColumnTypeCode = new ComboBox<ColumnTypeCodeElement>(
				storeComboTypeCode, propsColumnTypeCode.label());
		Log.trace("ComboColumnTypeCode created");

		addHandlersForComboColumnTypeCode(propsColumnTypeCode.label());

		comboColumnTypeCode.setEmptyText("Select a column type...");
		comboColumnTypeCode.setWidth(191);
		comboColumnTypeCode.setEditable(false);
		comboColumnTypeCode.setTypeAhead(false);
		comboColumnTypeCode.setTriggerAction(TriggerAction.ALL);

		comboColumnTypeCodeLabel = new FieldLabel(comboColumnTypeCode,
				"Column Type");

		// comboLocaleType
		LocaleTypeProperties propsLocaleType = GWT
				.create(LocaleTypeProperties.class);
		storeComboLocaleType = new ListStore<LocaleTypeElement>(
				propsLocaleType.id());

		comboLocaleType = new ComboBox<LocaleTypeElement>(storeComboLocaleType,
				propsLocaleType.label()) {

			protected void onAfterFirstAttach() {
				super.onAfterFirstAttach();
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {
					public void execute() {
						retriveLocales();
					}
				});
			}
		};
		Log.trace("ComboLocaleType created");

		addHandlersForComboLocaleType(propsLocaleType.label());

		comboLocaleType.setEmptyText("Select a locale type...");
		comboLocaleType.setWidth(191);
		comboLocaleType.setTypeAhead(true);
		comboLocaleType.setTriggerAction(TriggerAction.ALL);

		comboLocaleTypeLabel = new FieldLabel(comboLocaleType, "Locale");

		//
		form = new SimpleContainer();
		form.setWidth(FIELDWIDTH);
		form.setHeight(FIELDSHEIGHT);

		formLayout = new VerticalLayoutContainer();
		formLayout.setScrollMode(ScrollMode.AUTO);

		formLayout
				.add(nameLabel, new VerticalLayoutData(1, -1, new Margins(0)));
		formLayout.add(comboColumnTypeCodeLabel, new VerticalLayoutData(1, -1,
				new Margins(0)));
		formLayout.add(comboLocaleTypeLabel, new VerticalLayoutData(1, -1,
				new Margins(0)));
		formLayout.add(defaultValueLabel, new VerticalLayoutData(1, -1,
				new Margins(0)));

		form.add(formLayout);

		btnSave = new TextButton("Save");
		btnSave.setIcon(ResourceBundle.INSTANCE.save());
		btnSave.setIconAlign(IconAlign.RIGHT);
		btnSave.setTitle("Save");
		btnSave.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Save");
				btnSave.disable();
				save();

			}
		});

		btnClose = new TextButton("Close");
		btnClose.setIcon(ResourceBundle.INSTANCE.close());
		btnClose.setIconAlign(IconAlign.RIGHT);
		btnClose.setTitle("Close");
		btnClose.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Close");
				close();
			}
		});

		HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
		flowButton.setHBoxLayoutAlign(HBoxLayoutAlign.MIDDLE);
		flowButton.setPack(BoxLayoutPack.CENTER);

		flowButton.add(btnSave, new BoxLayoutData(new Margins(2, 4, 2, 4)));
		flowButton.add(btnClose, new BoxLayoutData(new Margins(2, 4, 2, 4)));

		VerticalLayoutContainer vPanel = new VerticalLayoutContainer();
		vPanel.add(form, new VerticalLayoutData(1, -1));
		vPanel.add(flowButton, new VerticalLayoutData(1, -1, new Margins(1)));
		add(vPanel);

		comboLocaleTypeLabel.setVisible(false);

	}

	protected void save() {
		ColumnTypeCode currentType = null;
		String localeName = null;

		String lab = label.getCurrentValue();
		ColumnTypeCodeElement typeElement = comboColumnTypeCode
				.getCurrentValue();
		LocaleTypeElement localeElement = comboLocaleType.getCurrentValue();
		String valueDefault = defaultValue.getCurrentValue();

		Log.debug("CheckValue: label: " + lab + ", type: " + typeElement
				+ ", locale: " + localeElement + ", default: " + valueDefault);
		if (lab == null || lab.isEmpty()) {
			UtilsGXT3.alert("Attention", "Add a label");
			return;
		}

		if (typeElement == null) {
			UtilsGXT3.alert("Attention", "No type selected");
			return;
		} else {
			if (typeElement.getCode() == null) {
				UtilsGXT3.alert("Attention", "No type selected");
				return;
			} else {
				currentType = typeElement.getCode();
			}
		}
		if (currentType != null && currentType == ColumnTypeCode.CODENAME) {
			if (localeElement == null) {
				UtilsGXT3.alert("Attention", "No locale selected");
				return;
			} else {
				if (localeElement.getLocaleName() == null
						|| localeElement.getLocaleName().isEmpty()) {
					UtilsGXT3.alert("Attention", "No locale selected");
					return;
				} else {
					localeName = localeElement.getLocaleName();
				}
			}
		}

		DefNewColumn defNewColumn = new DefNewColumn(lab, currentType,
				localeName, valueDefault);
		Log.debug("DefNewColumn:" + defNewColumn);
		fireCompleted(defNewColumn);

	}

	public void close() {
		if (parent != null) {
			parent.close();
		}
	}

	protected void addHandlersForComboColumnTypeCode(
			final LabelProvider<ColumnTypeCodeElement> labelProvider) {
		comboColumnTypeCode
				.addSelectionHandler(new SelectionHandler<ColumnTypeCodeElement>() {
					public void onSelection(
							SelectionEvent<ColumnTypeCodeElement> event) {
						Info.display(
								"Column Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboColumnTypeCode selected: "
								+ event.getSelectedItem());
						ColumnTypeCodeElement columnType = event
								.getSelectedItem();
						updateColumnType(columnType.getCode());
					}

				});
	}

	protected void addHandlersForComboLocaleType(
			final LabelProvider<LocaleTypeElement> labelProvider) {
		comboLocaleType
				.addSelectionHandler(new SelectionHandler<LocaleTypeElement>() {
					public void onSelection(
							SelectionEvent<LocaleTypeElement> event) {
						Info.display(
								"Locale Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboLocaleType selected: "
								+ event.getSelectedItem());
						LocaleTypeElement localeType = event.getSelectedItem();
						updateLocaleType(localeType);
					}

				});
	}

	protected void updateColumnType(ColumnTypeCode type) {
		Log.debug("Update ColumnTypeCode " + type.toString());
		switch (type) {
		case CODENAME:
			comboLocaleTypeLabel.setVisible(true);
			forceLayout();
			break;
		default:
			comboLocaleTypeLabel.setVisible(false);
			forceLayout();
			break;
		}
	}

	protected void updateLocaleType(LocaleTypeElement type) {

	}

	protected void retriveLocales() {
		TDGWTServiceAsync.INSTANCE
				.getLocales(new AsyncCallback<ArrayList<String>>() {

					@Override
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							if (caught instanceof TDGWTIsLockedException) {
								Log.error(caught.getLocalizedMessage());
								UtilsGXT3.alert("Error Locked",
										caught.getLocalizedMessage());
							} else {
								if (caught instanceof TDGWTIsFinalException) {
									Log.error(caught.getLocalizedMessage());
									UtilsGXT3.alert("Error Final",
											caught.getLocalizedMessage());
								} else {
									Log.debug(caught.getLocalizedMessage());
									UtilsGXT3.alert("Error retrieving locales",
											caught.getLocalizedMessage());
								}
							}
						}
					}

					@Override
					public void onSuccess(ArrayList<String> result) {
						storeComboLocaleType.clear();
						ArrayList<LocaleTypeElement> locales = new ArrayList<LocaleTypeElement>();
						LocaleTypeElement locale;
						for (String local : result) {
							locale = new LocaleTypeElement(local);
							locales.add(locale);
						}
						storeComboLocaleType.addAll(locales);
						storeComboLocaleType.commitChanges();

					}
				});

	}

	public void addListener(CreateDefColumnListener listener) {
		Log.debug("Add Listener:" + listener);
		listeners.add(listener);
	}

	public void removeListener(CreateDefColumnListener listener) {
		Log.debug("Remove Listener:" + listener);
		listeners.remove(listener);
	}

	public void fireCompleted(DefNewColumn defNewColumn) {
		for (CreateDefColumnListener listener : listeners)
			listener.completedDefColumnCreation(defNewColumn);
		close();
	}

	public void fireAborted() {
		for (CreateDefColumnListener listener : listeners)
			listener.abortedDefColumnCreation();
		close();
	}

	public void fireFailed(String reason, String details) {
		for (CreateDefColumnListener listener : listeners)
			listener.failedDefColumnCreation(reason, details);
		close();
	}

}
