package org.gcube.portlets.user.td.columnwidget.client.replace;

import org.gcube.portlets.user.td.columnwidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.widgetcommonevent.shared.CellData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ReplaceAllDialog extends Window {
	protected String WIDTH = "500px";
	protected String HEIGHT = "150px";
	protected ReplaceAllPanel ReplacePanel;
	protected CellData cellData;
	protected TRId trId;
	protected EventBus eventBus;

	
	public ReplaceAllDialog(CellData cellData, TRId trId, EventBus eventBus) {
		initWindow();
		this.cellData = cellData;
		this.trId = trId;
		this.eventBus = eventBus;
		create();

	}

	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("Replace All");
		setClosable(true);
		getHeader().setIcon(ResourceBundle.INSTANCE.replaceAll());

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}

	protected void create() {
		ReplaceAllPanel replacePanel = new ReplaceAllPanel(this, trId, cellData,
				eventBus);
		add(replacePanel);
	}

	protected void close() {
		hide();
	}

	

}
