package org.gcube.portlets.user.td.expressionwidget.shared.model;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.comparable.C_Equals;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.comparable.C_GreaterOrEquals;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.comparable.C_GreaterThan;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.comparable.C_LessOrEquals;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.comparable.C_LessThan;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.comparable.C_NotEquals;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.comparable.C_NotGreater;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.comparable.C_NotLess;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.text.C_TextBeginsWith;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.text.C_TextContains;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.text.C_TextEndsWith;
import org.gcube.portlets.user.td.expressionwidget.shared.model.composite.text.C_TextMatchSQLRegexp;
import org.gcube.portlets.user.td.expressionwidget.shared.model.leaf.C_ColumnReferencePlaceholder;
import org.gcube.portlets.user.td.expressionwidget.shared.model.leaf.C_ConstantList;
import org.gcube.portlets.user.td.expressionwidget.shared.model.leaf.C_Range;
import org.gcube.portlets.user.td.expressionwidget.shared.model.leaf.C_TypedColumnReference;
import org.gcube.portlets.user.td.expressionwidget.shared.model.leaf.TD_Value;
import org.gcube.portlets.user.td.expressionwidget.shared.model.logical.C_And;
import org.gcube.portlets.user.td.expressionwidget.shared.model.logical.C_Between;
import org.gcube.portlets.user.td.expressionwidget.shared.model.logical.C_IsNotNull;
import org.gcube.portlets.user.td.expressionwidget.shared.model.logical.C_IsNull;
import org.gcube.portlets.user.td.expressionwidget.shared.model.logical.C_Not;
import org.gcube.portlets.user.td.expressionwidget.shared.model.logical.C_Or;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeMap;

import com.allen_sauer.gwt.log.client.Log;



/**
 * OperatorTypeMap creates a C_Expression usable client-side
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class OperatorTypeMap {
	private String readableExpression;
	
	public OperatorTypeMap(){
		
	}
	
	public C_Expression map(ColumnData column,C_OperatorType operatorType, String firstArg, String secondArg){
		Log.debug("OperatorTypeMap Map");
		C_Expression exp=null;
		readableExpression=new String();
		if(column.getTrId()==null){
			exp=mapPlaceHolder(column,operatorType,firstArg,secondArg);
		} else {
			exp=mapTypedColumnReference(column,operatorType,firstArg,secondArg);
		}
		return exp;
	}
		
	public C_Expression mapPlaceHolder(ColumnData column,C_OperatorType operatorType, String firstArg, String secondArg){
		Log.debug("OperatorTypeMap Map Place Holder");
		C_Expression exp = null;
		Log.debug("Column Data Type Name:"+column.getDataTypeName());
		ColumnDataType dataType=ColumnTypeMap.getColumnDataType(column.getDataTypeName());
		Log.debug("Data Type:"+dataType);	
		C_ColumnReferencePlaceholder placeHolder=new C_ColumnReferencePlaceholder(dataType
				, column.getColumnId());
		Log.debug("placeHolder:"+placeHolder);
		String readablePlaceHolder=column.getColumnId();
		
		List<TD_Value> arguments=new ArrayList<TD_Value>();
		TD_Value fArg;
		TD_Value sArg;
		C_Range range;
		int separator;
		
		switch (operatorType) {
		case ADDITION:
			break;
		case ALL:
			break;
		case AND:
			break;
		case ANY:
			break;
		case BEGINS_WITH:
			exp=new C_TextBeginsWith(placeHolder,new TD_Value(dataType,firstArg));
			readableExpression="Begins("+readablePlaceHolder+", "+firstArg+")";
			break;
		case BETWEEN:
			fArg=new TD_Value(dataType,firstArg);
			sArg=new TD_Value(dataType,secondArg);
			range=new C_Range(fArg,sArg);
			exp=new C_Between(placeHolder,range);
			readableExpression="Between("+readablePlaceHolder+", Range("+firstArg+", "+secondArg+"))";
			break;
		case CONTAINS:
			separator=firstArg.indexOf(",");
			if(separator==-1|| firstArg.length()==1){
				arguments.add(new TD_Value(dataType,firstArg));
			} else {
				String arg;
				boolean end=false;
				while(!end){
					arg=firstArg.substring(0, separator);
					arguments.add(new TD_Value(dataType,arg));
					separator++;
					if(separator<firstArg.length()){
						firstArg=firstArg.substring(separator,firstArg.length());
						separator=firstArg.indexOf(",");
						if(separator==-1){
							arguments.add(new TD_Value(dataType,firstArg));
							end=true;
						} 
					} else {
						end=true;
					}
				}
			}
			exp=new C_TextContains(placeHolder,new C_ConstantList(arguments));
			readableExpression="Contains("+readablePlaceHolder;
			for(TD_Value v:arguments){
				readableExpression+=", "+v.getValue();
			}
			readableExpression+=")";
			break;
		case DIVISION:
			break;
		case ENDS_WITH:
			exp=new C_TextEndsWith(placeHolder,new TD_Value(dataType,firstArg));
			readableExpression="TextEndsWith("+readablePlaceHolder+","+firstArg+")";
			break;
		case EQUALS:
			exp=new C_Equals(placeHolder,new TD_Value(dataType,firstArg));
			readableExpression="Equals("+readablePlaceHolder+","+firstArg+")";
			break;
		case EXISTS:
			//exp=new C_Exi(placeHolder,new C_ConstantList(arguments));
			break;
		case GREATER:
			exp=new C_GreaterThan(placeHolder,new TD_Value(dataType,firstArg));
			readableExpression="GreaterThan("+readablePlaceHolder+","+firstArg+")";
			break;
		case GREATER_OR_EQUALS:
			exp=new C_GreaterOrEquals(placeHolder,new TD_Value(dataType,firstArg));
			readableExpression="GreaterOrEquals("+readablePlaceHolder+","+firstArg+")";
			break;
		case IN:
			break;
		case IS_NOT_NULL:
			exp=new C_IsNotNull(placeHolder);
			readableExpression="IsNotNull("+readablePlaceHolder+")";	
			break;
		case IS_NULL:
			exp=new C_IsNull(placeHolder);
			readableExpression="IsNull("+readablePlaceHolder+")";
			break;
		case LESSER:
			exp=new C_LessThan(placeHolder,new TD_Value(dataType,firstArg));
			readableExpression="LessThan("+readablePlaceHolder+","+firstArg+")";
			break;
		case LESSER_OR_EQUALS:
			exp=new C_LessOrEquals(placeHolder,new TD_Value(dataType,firstArg));	
			readableExpression="LessOrEquals("+readablePlaceHolder+","+firstArg+")";
			break;
		case LIKE:
			break;
		case MATCH_REGEX:
			exp=new C_TextMatchSQLRegexp(placeHolder,new TD_Value(dataType,firstArg));
			readableExpression="TextMatchSQLRegexp("+readablePlaceHolder+","+firstArg+")";
			break;
		case MODULUS:
			break;
		case MULTIPLICATION:
			break;
		case NOT:
			break;
		case NOT_BEGINS_WITH:
			exp=new C_TextBeginsWith(placeHolder, new TD_Value(dataType,firstArg));
			exp=new C_Not(exp);
			readableExpression="Not(TextBeginsWith("+readablePlaceHolder+","+firstArg+"))";
			break;
		case NOT_BETWEEN:
			fArg=new TD_Value(dataType,firstArg);
			sArg=new TD_Value(dataType,secondArg);
			range=new C_Range(fArg,sArg);
			exp=new C_Between(placeHolder,range);
			exp=new C_Not(exp);
			readableExpression="Not(Between("+readablePlaceHolder+", Range("+firstArg+", "+secondArg+")))";
			break;
		case NOT_CONTAINS:
			separator=firstArg.indexOf(",");
			if(separator==-1|| firstArg.length()==1){
				arguments.add(new TD_Value(dataType,firstArg));
			} else {
				String arg;
				boolean end=false;
				while(!end){
					arg=firstArg.substring(0, separator);
					arguments.add(new TD_Value(dataType,arg));
					separator++;
					if(separator<firstArg.length()){
						firstArg=firstArg.substring(separator,firstArg.length());
						separator=firstArg.indexOf(",");
						if(separator==-1){
							arguments.add(new TD_Value(dataType,firstArg));
							end=true;
						} 
					} else {
						end=true;
					}
				}
			}
			exp=new C_TextContains(placeHolder,new C_ConstantList(arguments));
			exp=new C_Not(exp);
			readableExpression="Not(Contains("+readablePlaceHolder;
			for(TD_Value v:arguments){
				readableExpression+=", "+v.getValue();
			}
			readableExpression+="))";
			break;
		case NOT_ENDS_WITH:
			exp=new C_TextEndsWith(placeHolder,new TD_Value(dataType,firstArg));
			exp=new C_Not(exp);
			readableExpression="Not(TextEndsWith("+readablePlaceHolder+","+firstArg+"))";
			break;
		case NOT_EQUALS:
			exp=new C_NotEquals(placeHolder,new TD_Value(dataType,firstArg));
			readableExpression="NotEquals("+readablePlaceHolder+","+firstArg+")";
			break;
		case NOT_GREATER:
			exp=new C_NotGreater(placeHolder,new TD_Value(dataType,firstArg));
			readableExpression="NotGreater("+readablePlaceHolder+","+firstArg+")";
			break;
		case NOT_IN:
			break;
		case NOT_LESSER:
			exp=new C_NotLess(placeHolder,new TD_Value(dataType,firstArg));
			readableExpression="NotLess("+readablePlaceHolder+","+firstArg+")";
			break;
		case NOT_LIKE:
			break;
		case NOT_MATCH_REGEX:
			exp=new C_TextMatchSQLRegexp(placeHolder,new TD_Value(dataType,firstArg));
			exp=new C_Not(exp);
			readableExpression="Not(TextMatchSQLRegexp("+readablePlaceHolder+","+firstArg+"))";
			break;
		case OR:
			break;
		case SELECT_IN:
			break;
		case SUBTRACTION:
			break;
		case UNIQUE:
			break;
		default:
			break;
		}
		
		return exp;
	}
	
	
	
	
	public C_Expression mapTypedColumnReference(ColumnData column,C_OperatorType operatorType, String firstArg, String secondArg){
		Log.debug("OperatorTypeMap Map Typed Column Reference");
		C_Expression exp = null;
		
		Log.debug("Column Data Type Name:"+column.getDataTypeName());
		ColumnDataType dataType=ColumnTypeMap.getColumnDataType(column.getDataTypeName());
		Log.debug("Data Type:"+dataType);
		C_TypedColumnReference columnReference=new C_TypedColumnReference(column.getTrId(), dataType
				, column.getColumnId());
		Log.debug("Typed Column Reference:"+columnReference);
		String readableColumnReference=column.getLabel();
		
		List<TD_Value> arguments=new ArrayList<TD_Value>();
		TD_Value fArg;
		TD_Value sArg;
		C_Range range;
		int separator;
		
		switch (operatorType) {
		case ADDITION:
			break;
		case ALL:
			break;
		case AND:
			break;
		case ANY:
			break;
		case BEGINS_WITH:
			exp=new C_TextBeginsWith(columnReference,new TD_Value(dataType,firstArg));
			readableExpression="TextBeginsWith("+readableColumnReference+","+firstArg+")";		
			break;
		case BETWEEN:
			fArg=new TD_Value(dataType,firstArg);
			sArg=new TD_Value(dataType,secondArg);
			range=new C_Range(fArg,sArg);
			exp=new C_Between(columnReference,range);
			readableExpression="Between("+readableColumnReference+", Range("+firstArg+", "+secondArg+"))";
			break;
		case CONTAINS:
			separator=firstArg.indexOf(",");
			if(separator==-1|| firstArg.length()==1){
				arguments.add(new TD_Value(dataType,firstArg));
			} else {
				String arg;
				boolean end=false;
				while(!end){
					arg=firstArg.substring(0, separator);
					arguments.add(new TD_Value(dataType,arg));
					separator++;
					if(separator<firstArg.length()){
						firstArg=firstArg.substring(separator,firstArg.length());
						separator=firstArg.indexOf(",");
						if(separator==-1){
							arguments.add(new TD_Value(dataType,firstArg));
							end=true;
						} 
					} else {
						end=true;
					}
				}
			}
			exp=new C_TextContains(columnReference,new C_ConstantList(arguments));
			readableExpression="Contains("+readableColumnReference;
			for(TD_Value v:arguments){
				readableExpression+=", "+v.getValue();
			}
			readableExpression+=")";
			break;
		case DIVISION:
			break;
		case ENDS_WITH:
			exp=new C_TextEndsWith(columnReference,new TD_Value(dataType,firstArg));
			readableExpression="TextEndsWith("+readableColumnReference+", "+firstArg+")";	
			break;
		case EQUALS:
			exp=new C_Equals(columnReference,new TD_Value(dataType,firstArg));
			readableExpression="Equals("+readableColumnReference+", "+firstArg+")";
			break;
		case EXISTS:
			//exp=new C_Exi(placeHolder,new C_ConstantList(arguments));
			break;
		case GREATER:
			exp=new C_GreaterThan(columnReference,new TD_Value(dataType,firstArg));
			readableExpression="GreaterThan("+readableColumnReference+", "+firstArg+")";
			break;
		case GREATER_OR_EQUALS:
			exp=new C_GreaterOrEquals(columnReference,new TD_Value(dataType,firstArg));
			readableExpression="GreaterOrEquals("+readableColumnReference+", "+firstArg+")";
			break;
		case IN:
			break;
		case IS_NOT_NULL:
			exp=new C_IsNotNull(columnReference);
			readableExpression="IsNotNull("+readableColumnReference+")";
			break;
		case IS_NULL:
			exp=new C_IsNull(columnReference);
			readableExpression="IsNull("+readableColumnReference+")";
			break;
		case LESSER:
			exp=new C_LessThan(columnReference,new TD_Value(dataType,firstArg));
			readableExpression="LessThan("+readableColumnReference+", "+firstArg+")";
			break;
		case LESSER_OR_EQUALS:
			exp=new C_LessOrEquals(columnReference,new TD_Value(dataType,firstArg));	
			readableExpression="LessOrEquals("+readableColumnReference+", "+firstArg+")";
			break;
		case LIKE:
			break;
		case MATCH_REGEX:
			exp=new C_TextMatchSQLRegexp(columnReference,new TD_Value(dataType,firstArg));
			readableExpression="TextMatchSQLRegexp("+readableColumnReference+", "+firstArg+")";
			break;
		case MODULUS:
			break;
		case MULTIPLICATION:
			break;
		case NOT:
			break;
		case NOT_BEGINS_WITH:
			exp=new C_TextBeginsWith(columnReference,new TD_Value(dataType,firstArg));
			exp=new C_Not(exp);
			readableExpression="Not(TextBeginsWith("+readableColumnReference+", "+firstArg+"))";
			break;
		case NOT_BETWEEN:
			fArg=new TD_Value(dataType,firstArg);
			sArg=new TD_Value(dataType,secondArg);
			range=new C_Range(fArg,sArg);
			exp=new C_Between(columnReference,range);
			exp=new C_Not(exp);
			readableExpression="Not(Between("+readableColumnReference+", Range("+firstArg+", "+secondArg+")))";
			break;
		case NOT_CONTAINS:
			separator=firstArg.indexOf(",");
			if(separator==-1|| firstArg.length()==1){
				arguments.add(new TD_Value(dataType,firstArg));
			} else {
				String arg;
				boolean end=false;
				while(!end){
					arg=firstArg.substring(0, separator);
					arguments.add(new TD_Value(dataType,arg));
					separator++;
					if(separator<firstArg.length()){
						firstArg=firstArg.substring(separator,firstArg.length());
						separator=firstArg.indexOf(",");
						if(separator==-1){
							arguments.add(new TD_Value(dataType,firstArg));
							end=true;
						} 
					} else {
						end=true;
					}
				}
			}
			exp=new C_TextContains(columnReference,new C_ConstantList(arguments));
			exp=new C_Not(exp);
			readableExpression="Not(Contains("+readableColumnReference;
			for(TD_Value v:arguments){
				readableExpression+=", "+v.getValue();
			}
			readableExpression+="))";
			break;
		case NOT_ENDS_WITH:
			exp=new C_TextEndsWith(columnReference,new TD_Value(dataType,firstArg));
			exp=new C_Not(exp);
			readableExpression="Not(TextEndsWith("+readableColumnReference+","+firstArg+"))";
			break;
		case NOT_EQUALS:
			exp=new C_NotEquals(columnReference,new TD_Value(dataType,firstArg));
			readableExpression="NotEquals("+readableColumnReference+","+firstArg+")";
			break;
		case NOT_GREATER:
			exp=new C_NotGreater(columnReference,new TD_Value(dataType,firstArg));
			readableExpression="NotGreater("+readableColumnReference+","+firstArg+")";	
			break;
		case NOT_IN:
			break;
		case NOT_LESSER:
			exp=new C_NotLess(columnReference,new TD_Value(dataType,firstArg));
			readableExpression="NotLess("+readableColumnReference+","+firstArg+")";	
			break;
		case NOT_LIKE:
			break;
		case NOT_MATCH_REGEX:
			exp=new C_TextMatchSQLRegexp(columnReference,new TD_Value(dataType,firstArg));
			exp=new C_Not(exp);
			readableExpression="Not(TextMatchSQLRegexp("+readableColumnReference+","+firstArg+"))";
			break;
		case OR:
			break;
		case SELECT_IN:
			break;
		case SUBTRACTION:
			break;
		case UNIQUE:
			break;
		default:
			break;
		}
		
		return exp;
	}
	
	public C_Expression createC_Or(List<C_Expression> arguments){
		C_Or or=new C_Or(arguments);
		return or;
	}
	
	public C_Expression createC_And(List<C_Expression> arguments){
		C_And or=new C_And(arguments);
		return or;
	}
	
	public String getReadableExpression() {
		return readableExpression;
	}

	
}
