package org.gcube.portlets.user.td.expressionwidget.client;

import org.gcube.portlets.user.td.expressionwidget.client.resources.ExpressionResources;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ExpressionEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ExpressionType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.box.AlertMessageBox;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ColumnExpressionDialog extends Window {
	protected String WIDTH = "660px";
	protected String HEIGHT = "426px";
	protected ColumnExpressionPanel columnExpressionPanel;
	protected C_Expression exp = null;
	protected ColumnData column = null;
	protected TRId trId;
	protected String columnName = null;
	protected EventBus eventBus;

	public ColumnExpressionDialog(String columnId,
			ColumnTypeCode columnTypeCode, ColumnDataType dataTypeName,
			EventBus eventBus) {
		initWindow();
		this.eventBus = eventBus;
		column = new ColumnData();
		column.setColumnId(columnId);
		column.setDataTypeName(dataTypeName.toString());
		column.setTypeCode(columnTypeCode.toString());
		create();

	}

	public ColumnExpressionDialog(TRId trId, String columnName,
			EventBus eventBus) {
		initWindow();
		this.eventBus = eventBus;
		this.trId = trId;
		this.columnName = columnName;
		load(trId, columnName);

	}

	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("New Rule");
		setClosable(true);
		setModal(true);
		forceLayoutOnResize = true;
		getHeader().setIcon(ExpressionResources.INSTANCE.rule());

	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			
			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}
	
	protected void close (){
		ExpressionEvent expressionEvent = new ExpressionEvent(
				ExpressionType.EXPRESSIONNULL);
		Log.debug(expressionEvent.toString());
		hide();
		eventBus.fireEvent(expressionEvent);
	}
	

	protected void create() {
		if (column.getTypeCode()
				.compareTo(ColumnTypeCode.ANNOTATION.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.ATTRIBUTE.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.CODE.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.CODEDESCRIPTION.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.CODENAME.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.MEASURE.toString()) == 0) {
			columnExpressionPanel = new ColumnExpressionPanel(this, column,
					eventBus);
			add(columnExpressionPanel);
		} else {
			HTML errorMessage = new HTML(
					"This type of column is not supported for now!");
			add(errorMessage);
			AlertMessageBox d = new AlertMessageBox("Error",
					"This type of column is not supported for now!");
			d.addHideHandler(new HideHandler() {
				public void onHide(HideEvent event) {
					hide();
				}
			});
			d.show();
		}
	}

	public C_Expression getExpression() {
		return exp;
	}

	protected void setExpression(C_Expression exp) {
		Log.debug("New Expression set:" + exp.toString());
		this.exp = exp;

	}

	protected void load(TRId trId, String columnName) {
		TDGWTServiceAsync.INSTANCE.getColumn(trId, columnName,
				new AsyncCallback<ColumnData>() {

					public void onFailure(Throwable caught) {
						Log.error("Error retrieving column: "
								+ caught.getMessage());

					}

					public void onSuccess(ColumnData result) {
						Log.debug("Retrived column: " + result);
						column = result;
						create();
					}

				});

	}

}
