package org.gcube.portlets.user.td.expressionwidget.client;

import org.gcube.portlets.user.td.expressionwidget.client.resources.ExpressionResources;
import org.gcube.portlets.user.td.expressionwidget.shared.exception.OperatorTypeMapException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.monitorwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ExpressionEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ExpressionType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_ExpressionContainer;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutData;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutPack;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer.HBoxLayoutAlign;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.FieldSet;
import com.sencha.gxt.widget.core.client.form.TextField;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ColumnExpressionPanel extends FramedPanel {
	private enum ColumnExpressionPanelType {
		MultiColumnFilter, ColumnFilter, Template;
	}

	private String WIDTH_MULTI = "642px";
	private String HEIGHT_MULTI = "290px";
	private String WIDTH = "648px";
	private String HEIGHT = "364px";
	
	private ColumnExpressionPanelType type;
	private EventBus eventBus;

	private ColumnExpressionDialog parentRuleDialog;
	private ColumnFilterDialog parentFilterDialog;
	private MultiColumnFilterTabPanel parentMultiColumnFilterTabPanel;

	private ColumnData column;
	
	private TextButton btnApply;
	private TextButton btnSearch;
	private TextButton btnSave;
	private TextButton btnClose;

	private FieldSet conditionsField;
	private ConditionWidget conditionWidget;

	public ColumnExpressionPanel(
			MultiColumnFilterTabPanel parentMultiColumnFilterTabPanel,
			ColumnData column, EventBus eventBus) {
		super();
		setWidth(WIDTH_MULTI);
		setHeight(HEIGHT_MULTI);
		type = ColumnExpressionPanelType.MultiColumnFilter;
		this.parentMultiColumnFilterTabPanel = parentMultiColumnFilterTabPanel;
		this.column = column;
		this.eventBus = eventBus;
		Log.debug(column.toString());

		create();
	}

	public ColumnExpressionPanel(ColumnFilterDialog parentFilterDialog,
			ColumnData column, EventBus eventBus) {
		super();
		setWidth(WIDTH);
		setHeight(HEIGHT);
		type = ColumnExpressionPanelType.ColumnFilter;
		this.parentFilterDialog = parentFilterDialog;
		this.column = column;
		this.eventBus = eventBus;
		Log.debug(column.toString());

		create();
	}

	/**
	 * 
	 * @param trId
	 * @param columnName
	 */
	public ColumnExpressionPanel(ColumnExpressionDialog parent,
			ColumnData column, EventBus eventBus) {
		super();
		setWidth(WIDTH);
		setHeight(HEIGHT);
		type = ColumnExpressionPanelType.Template;
		this.parentRuleDialog = parent;
		this.column = column;
		this.eventBus = eventBus;
		Log.debug(column.toString());

		create();
	}

	protected void create() {
		//Important: fixed rendering of widgets
		forceLayoutOnResize = true;
		
		setBodyBorder(false);
		setHeaderVisible(false);

		VerticalLayoutContainer basicLayout = new VerticalLayoutContainer();
		basicLayout.setAdjustForScroll(true);
		//basicLayout.setScrollMode(ScrollMode.AUTO); Set In GXT 3.0.1

		FieldSet properties = null;
		VerticalLayoutContainer propertiesLayout;
		TextField columnName;

		HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
		flowButton.setHBoxLayoutAlign(HBoxLayoutAlign.MIDDLE);
		flowButton.setPack(BoxLayoutPack.CENTER);

		switch (type) {
		case Template:
			properties = new FieldSet();
			properties.setHeadingText("Properties");
			properties.setCollapsible(false);

			propertiesLayout = new VerticalLayoutContainer();
			properties.add(propertiesLayout);

			TextField columnType = new TextField();
			columnType.setToolTip("The type of column");
			columnType.setReadOnly(true);
			columnType.setValue(column.getTypeCode());
			propertiesLayout.add(new FieldLabel(columnType, "Column Type"),
					new VerticalLayoutData(1, -1));

			TextField dataType = new TextField();
			dataType.setToolTip("The data type");
			dataType.setReadOnly(true);
			dataType.setValue(column.getDataTypeName());
			propertiesLayout.add(new FieldLabel(dataType, "Data Type"),
					new VerticalLayoutData(1, -1));

			conditionsField = new FieldSet();
			conditionsField.setHeadingText("Conditions");
			conditionsField.setCollapsible(false);

			conditionWidget = new ConditionWidget(column);
			Log.debug("ConditionWidget" + conditionWidget);
			conditionsField.add(conditionWidget);
			
			btnApply = new TextButton("Apply");
			btnApply.setIcon(ExpressionResources.INSTANCE.apply());
			btnApply.setIconAlign(IconAlign.RIGHT);
			btnApply.setTitle("Apply rule");
			btnApply.addSelectHandler(new SelectHandler() {

				public void onSelect(SelectEvent event) {
					Log.debug("Pressed Apply");
					applyRule();

				}
			});

			btnSearch = new TextButton("Search");
			btnSearch.setIcon(ExpressionResources.INSTANCE.search());
			btnSearch.setIconAlign(IconAlign.RIGHT);
			btnSearch.setTitle("Search rule");
			btnSearch.addSelectHandler(new SelectHandler() {

				public void onSelect(SelectEvent event) {
					Log.debug("Pressed Search");
					searchRule();

				}
			});

			btnSave = new TextButton("Save");
			btnSave.setIcon(ExpressionResources.INSTANCE.save());
			btnSave.setIconAlign(IconAlign.RIGHT);
			btnSave.setTitle("Save rule");
			btnSave.addSelectHandler(new SelectHandler() {

				public void onSelect(SelectEvent event) {
					Log.debug("Pressed Save");
					saveRule();

				}
			});

			btnClose = new TextButton("Close");
			btnClose.setIcon(ExpressionResources.INSTANCE.close());
			btnClose.setIconAlign(IconAlign.RIGHT);
			btnClose.setTitle("Cancel rule");
			btnClose.addSelectHandler(new SelectHandler() {

				public void onSelect(SelectEvent event) {
					Log.debug("Pressed Close");
					close();
				}
			});

			flowButton
					.add(btnApply, new BoxLayoutData(new Margins(2, 4, 2, 4)));
			//flowButton.add(btnSave, new BoxLayoutData(new Margins(2, 4, 2, 4)));
			/*flowButton.add(btnSearch,
					new BoxLayoutData(new Margins(2, 4, 2, 4)));*/
			flowButton
					.add(btnClose, new BoxLayoutData(new Margins(2, 4, 2, 4)));
			break;
		case ColumnFilter:
			properties = new FieldSet();
			properties.setHeadingText("Properties");
			properties.setCollapsible(false);

			propertiesLayout = new VerticalLayoutContainer();
			properties.add(propertiesLayout);

			columnName = new TextField();
			columnName.setToolTip("Column");
			columnName.setReadOnly(true);
			columnName.setValue(column.getLabel());
			propertiesLayout.add(new FieldLabel(columnName, "Column"),
					new VerticalLayoutData(1, -1));
			conditionsField = new FieldSet();
			conditionsField.setHeadingText("Conditions");
			conditionsField.setCollapsible(false);

			conditionWidget = new ConditionWidget(column);
			Log.debug("ConditionWidget" + conditionWidget);
			conditionsField.add(conditionWidget);

			btnApply = new TextButton("Apply");
			btnApply.setIcon(ExpressionResources.INSTANCE.applyFilter());
			btnApply.setIconAlign(IconAlign.RIGHT);
			btnApply.setTitle("Apply Filter");
			btnApply.addSelectHandler(new SelectHandler() {

				public void onSelect(SelectEvent event) {
					Log.debug("Pressed Apply");
					applyRule();

				}
			});

			btnClose = new TextButton("Close");
			btnClose.setIcon(ExpressionResources.INSTANCE.close());
			btnClose.setIconAlign(IconAlign.RIGHT);
			btnClose.setTitle("Cancel filter");
			btnClose.addSelectHandler(new SelectHandler() {

				public void onSelect(SelectEvent event) {
					Log.debug("Pressed Close");
					close();
				}
			});
			flowButton
					.add(btnApply, new BoxLayoutData(new Margins(2, 4, 2, 4)));
			flowButton
					.add(btnClose, new BoxLayoutData(new Margins(2, 4, 2, 4)));

			break;
		case MultiColumnFilter:
			properties = new FieldSet();
			properties.setHeadingText("Properties");
			properties.setCollapsible(false);

			propertiesLayout = new VerticalLayoutContainer();
			properties.add(propertiesLayout);

			columnName = new TextField();
			columnName.setToolTip("Column");
			columnName.setReadOnly(true);
			columnName.setValue(column.getLabel());
			propertiesLayout.add(new FieldLabel(columnName, "Column"),
					new VerticalLayoutData(1, -1));

			conditionsField = new FieldSet();
			conditionsField.setHeadingText("Conditions");
			conditionsField.setCollapsible(false);

			conditionWidget = new ConditionWidget(column,"612px", "110px");
			Log.debug("ConditionWidget" + conditionWidget);
			conditionsField.add(conditionWidget);

			btnApply = new TextButton("Add");
			btnApply.setIcon(ExpressionResources.INSTANCE.applyFilter());
			btnApply.setIconAlign(IconAlign.RIGHT);
			btnApply.setTitle("Add Filter");
			btnApply.addSelectHandler(new SelectHandler() {

				public void onSelect(SelectEvent event) {
					Log.debug("Pressed Add Filter");
					applyRule();

				}
			});
			
			flowButton
					.add(btnApply, new BoxLayoutData(new Margins(2, 4, 2, 4)));
			break;
		default:
			break;
		}

		basicLayout.add(properties, new VerticalLayoutData(1, -1, new Margins(
				1)));
		basicLayout.add(conditionsField, new VerticalLayoutData(1, -1,
				new Margins(1)));
		basicLayout.add(flowButton, new VerticalLayoutData(1, 36, new Margins(
				5, 2, 5, 2)));
		add(basicLayout);
		
	}

	protected void applyRule() {
		C_Expression exp;
		try {
			exp = conditionWidget.getExpression();
		} catch (OperatorTypeMapException e) {
			Log.debug(e.getLocalizedMessage());
			UtilsGXT3.alert("Attention", e.getLocalizedMessage());
			return;
		}
		
		switch (type) {
		case Template:
			parentRuleDialog.setExpression(exp);
			ExpressionEvent expressionEvent = new ExpressionEvent(
					ExpressionType.COLUMNEXPRESSION);
			C_ExpressionContainer container = new C_ExpressionContainer();
			container.setId(C_ExpressionContainer.Contains.C_Expression);
			container.setExp(exp);
			container.setReadableExpression(conditionWidget
					.getReadableExpression());
			expressionEvent.setC_ConditionExpressionContainer(container);
			expressionEvent.setTrId(column.getTrId());
			expressionEvent.setColumnId(column.getColumnId());
			expressionEvent.setColumnName(column.getName());
			Log.debug(expressionEvent.toString());
			parentRuleDialog.hide();
			eventBus.fireEvent(expressionEvent);
			break;
		case ColumnFilter:
			parentFilterDialog.applyFilter(exp);
			break;
		case MultiColumnFilter:
			parentMultiColumnFilterTabPanel.applyFilter(column, exp);
			break;
		default:
			break;
		}

	}

	protected void saveRule() {

	}

	protected void searchRule() {

	}

	protected void close() {
		switch (type) {
		case Template:
			ExpressionEvent expressionEvent = new ExpressionEvent(
					ExpressionType.EXPRESSIONNULL);
			Log.debug(expressionEvent.toString());
			parentRuleDialog.hide();
			eventBus.fireEvent(expressionEvent);
			break;
		case ColumnFilter:
			parentFilterDialog.close();
			break;
		case MultiColumnFilter:
			break;
		default:
			break;
		}

	}

}
