package org.gcube.portlets.user.td.gwtservice.shared.tr.column;

import java.io.Serializable;

import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class MergeColumnSession implements Serializable {

	private static final long serialVersionUID = -1896235499708614266L;

	protected ColumnData columnData;
	protected String label;
	protected Expression expression;
	protected ColumnTypeCode mergeColumnType;
	protected ColumnDataType mergeColumnDataType;

	public MergeColumnSession() {

	}

	/**
	 * 
	 * @param columnData
	 * @param label
	 * @param mergeColumnType
	 * @param mergeColumnDataType
	 * @param expression
	 */
	public MergeColumnSession(ColumnData columnData,
			String label, 
			ColumnTypeCode mergeColumnType,
			ColumnDataType mergeColumnDataType,
			Expression expression) {
		this.columnData = columnData;
		this.label = label;
		this.expression = expression;
		this.mergeColumnType=mergeColumnType;
		this.mergeColumnDataType=mergeColumnDataType;

	}

	public ColumnData getColumnData() {
		return columnData;
	}

	public void setColumnData(ColumnData columnData) {
		this.columnData = columnData;
	}

	public Expression getExpression() {
		return expression;
	}

	public void setExpression(Expression expression) {
		this.expression = expression;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public ColumnTypeCode getMergeColumnType() {
		return mergeColumnType;
	}

	public void setMergeColumnType(ColumnTypeCode mergeColumnType) {
		this.mergeColumnType = mergeColumnType;
	}

	public ColumnDataType getMergeColumnDataType() {
		return mergeColumnDataType;
	}

	public void setMergeColumnDataType(ColumnDataType mergeColumnDataType) {
		this.mergeColumnDataType = mergeColumnDataType;
	}

	@Override
	public String toString() {
		return "MergeColumnSession [columnData=" + columnData + ", label="
				+ label + ", expression=" + expression + ", mergeColumnType="
				+ mergeColumnType + ", mergeColumnDataType="
				+ mergeColumnDataType + "]";
	}

	

	

}
