package org.gcube.portlets.user.td.gwtservice.server.trservice;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ColumnDataTypeMap {
		
	public static DataType map(ColumnDataType columnDataType){
		if(columnDataType==ColumnDataType.Integer){
			return new IntegerType() ;
		} else {
			if(columnDataType==ColumnDataType.Numeric){
				return new NumericType();
			} else {
				if(columnDataType==ColumnDataType.Boolean){
					return new BooleanType();
				} else {
					if(columnDataType==ColumnDataType.Geometry){
						return new GeometryType();
					} else {
						if(columnDataType==ColumnDataType.Text){
							return new TextType();
						} else {
							if(columnDataType==ColumnDataType.Date){
								return new DateType();
							} else {
								return null;
							}
						}
					}
				}
			}
		}
	}
	
	
}
