/**
 * 
 */
package org.gcube.portlets.user.td.client;

import java.util.ArrayList;

import org.gcube.portlets.user.td.client.logs.TDMLogs;
import org.gcube.portlets.user.td.client.template.TemplateApplyDialog;
import org.gcube.portlets.user.td.client.template.TemplateDeleteDialog;
import org.gcube.portlets.user.td.client.template.TemplateOpenDialog;
import org.gcube.portlets.user.td.codelistmappingimportwidget.client.CodelistMappingImportWizardTD;
import org.gcube.portlets.user.td.columnwidget.client.batch.ReplaceBatchDialog;
import org.gcube.portlets.user.td.columnwidget.client.replace.ReplaceDialog;
import org.gcube.portlets.user.td.csvexportwidget.client.CSVExportWizardTD;
import org.gcube.portlets.user.td.csvimportwidget.client.CSVImportWizardTD;
import org.gcube.portlets.user.td.expressionwidget.client.ColumnFilterDialog;
import org.gcube.portlets.user.td.expressionwidget.client.MultiColumnFilterDialog;
import org.gcube.portlets.user.td.expressionwidget.client.ReplaceColumnByExpressionDialog;
import org.gcube.portlets.user.td.extractcodelistwidget.client.ExtractCodelistWizardTD;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.jsonexportwidget.client.JSONExportWidgetTD;
import org.gcube.portlets.user.td.openwidget.client.TDOpen;
import org.gcube.portlets.user.td.sdmxexportwidget.client.SDMXExportWizardTD;
import org.gcube.portlets.user.td.sdmximportwidget.client.SDMXImportWizardTD;
import org.gcube.portlets.user.td.sharewidget.client.TRShare;
import org.gcube.portlets.user.td.tablewidget.client.CloneTabularResource;
import org.gcube.portlets.user.td.tablewidget.client.history.HistoryDiscard;
import org.gcube.portlets.user.td.tablewidget.client.rows.DeleteRows;
import org.gcube.portlets.user.td.tablewidget.client.rows.EditRowDialog;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;
import org.gcube.portlets.user.td.taskswidget.client.TdTaskController;
import org.gcube.portlets.user.td.unionwizardwidget.client.UnionWizardTD;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.BackgroundRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ChangeTableRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.GridContextMenuItemEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.GridHeaderColumnMenuItemEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.RibbonEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.TasksMonitorEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.UIStateEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.WidgetRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.BackgroundRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.RibbonType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.TaskType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.UIStateType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.WidgetRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.CellData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.GridHeaderOperationId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.GridOperationId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.RequestProperties;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.grid.model.RowRaw;
import org.gcube.portlets.user.td.wizardwidget.client.WizardListener;
import org.gcube.portlets.user.tdtemplate.client.TdTemplateController;
import org.gcube.portlets.user.tdwx.client.TabularDataX;
import org.gcube.portlets.user.tdwx.shared.model.TableId;
import org.gcube.portlets.widgets.sessionchecker.client.CheckSession;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.sencha.gxt.widget.core.client.ContentPanel;
import com.sencha.gxt.widget.core.client.Dialog.PredefinedButton;
import com.sencha.gxt.widget.core.client.box.ConfirmMessageBox;
import com.sencha.gxt.widget.core.client.container.BorderLayoutContainer.BorderLayoutData;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;

//import org.gcube.portlets.user.tdtemplate.client.TdTemplateController;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class TabularDataController {
	// implements HasCloseHandlers<Long>, HasOpenHandlers<Long> {

	protected SimpleEventBus eventBus;
	protected TabularDataX tabularData;
	protected UIStateType uiState = UIStateType.START;

	private boolean taskManagerInit = false;
	protected TdTaskController tdTaskController;

	protected ContentPanel toolBoxPanel;
	protected BorderLayoutData westData;

	/**
	 * Tabular Resource Id
	 */
	protected TRId trId;

	/**
	 * Grid TableId
	 */
	protected TableId tableOpening;

	public TabularDataController() {
		eventBus = new SimpleEventBus();
		callHello();
		checkSession();
		bindToEvents();
	}

	protected void checkSession() {
		// if you do not need to something when the session expire
		CheckSession.getInstance().startPolling();
	}

	protected void sessionExpiredShow() {
		CheckSession.showLogoutDialog();
	}

	/**
	 * @return the eventBus
	 */
	public EventBus getEventBus() {
		return eventBus;
	}

	public void setTabularData(TabularDataX tabularData) {
		this.tabularData = tabularData;
	}

	public ContentPanel getToolBoxPanel() {
		return toolBoxPanel;
	}

	public void setToolBoxPanel(ContentPanel toolBoxPanel) {
		this.toolBoxPanel = toolBoxPanel;
	}

	public BorderLayoutData getWestData() {
		return westData;
	}

	public void setWestData(BorderLayoutData westData) {
		this.westData = westData;
	}

	protected void callHello() {
		TDGWTServiceAsync.INSTANCE.hello(new AsyncCallback<String>() {

			@Override
			public void onFailure(Throwable caught) {
				Log.info("No valid user found: " + caught.getMessage());
				if (caught instanceof TDGWTSessionExpiredException) {
					UtilsGXT3.alert("Error", "No user found");
					sessionExpiredShowDelayed();
				} else {
					UtilsGXT3.alert("Error", "No user found");
				}
			}

			@Override
			public void onSuccess(String result) {
				Log.info("Hello: " + result);

			}

		});

	}

	protected void sessionExpiredShowDelayed() {
		Timer timeoutTimer = new Timer() {
			public void run() {
				sessionExpiredShow();

			}
		};
		int TIMEOUT = 5; // 3 second timeout

		timeoutTimer.schedule(TIMEOUT * 1000); // timeout is in milliseconds

	}

	// Bind Controller to events on bus
	protected void bindToEvents() {
		eventBus.addHandler(SessionExpiredEvent.TYPE,
				new SessionExpiredEvent.SessionExpiredEventHandler() {

					@Override
					public void onSessionExpired(SessionExpiredEvent event) {
						Log.debug("Catch Event SessionExpiredEvent");
						doSessionExpiredCommand(event);

					}
				});

		eventBus.addHandler(
				GridHeaderColumnMenuItemEvent.TYPE,
				new GridHeaderColumnMenuItemEvent.GridHeaderColumnMenuItemEventHandler() {

					public void onGridHeaderColumnMenuItemEvent(
							GridHeaderColumnMenuItemEvent event) {
						Log.debug("Catch Event GridHeaderColumnMenuItemEvent");
						doGridHeaderColumnMenuCommand(event);

					}
				});

		eventBus.addHandler(GridContextMenuItemEvent.TYPE,
				new GridContextMenuItemEvent.GridContextMenuItemEventHandler() {

					public void onGridContextMenuItemEvent(
							GridContextMenuItemEvent event) {
						Log.debug("Catch Event ContextMenuItemEvent");
						doGridContextMenuCommand(event);

					}
				});

		eventBus.addHandler(ChangeTableRequestEvent.TYPE,
				new ChangeTableRequestEvent.ChangeTableRequestEventHandler() {

					public void onChangeTableRequestEvent(
							ChangeTableRequestEvent event) {
						Log.debug("Catch Event ChangeTableRequestEvent");
						doChangeTableRequestEventCommand(event);

					}
				});

		eventBus.addHandler(RibbonEvent.TYPE,
				new RibbonEvent.RibbonEventHandler() {

					public void onRibbon(RibbonEvent event) {
						Log.debug("Catch Event RibbonEvent");
						doRibbonCommand(event);

					}
				});

		eventBus.addHandler(TasksMonitorEvent.TYPE,
				new TasksMonitorEvent.TasksMonitorEventHandler() {

					public void onTasksMonitorEvent(TasksMonitorEvent event) {
						Log.debug("Catch Event TasksMonitorEvent");
						doTasksMonitorCommand(event);

					}

				});

		eventBus.addHandler(WidgetRequestEvent.TYPE,
				new WidgetRequestEvent.WidgetRequestEventHandler() {

					@Override
					public void onWidgetRequest(WidgetRequestEvent event) {
						Log.debug("Catch Event WidgetRequestEvent");
						doWidgetRequestCommand(event);

					}

				});

		eventBus.addHandler(BackgroundRequestEvent.TYPE,
				new BackgroundRequestEvent.BackgroundRequestEventHandler() {

					@Override
					public void onBackgroundRequest(BackgroundRequestEvent event) {
						Log.debug("Catch Event BackgroundRequestEvent");
						doBackgroundRequestCommand(event);

					}

				});

		eventBus.fireEvent(new UIStateEvent(UIStateType.START));

	}

	//
	public void restoreUISession() {
		TDGWTServiceAsync.INSTANCE
		.getCurrentTRId(new AsyncCallback<TRId>() {

			public void onFailure(Throwable caught) {
			
			}

			public void onSuccess(TRId trId) {
				if(trId!=null){
					if(trId.getId()!=null && !trId.getId().isEmpty()){
						openTable(trId);
					}
				}
				
			}

		});

	}

	//
	protected void putInBackgroundUIState() {
		try {
			closeTabularResource();
			openBackgroundMonitor();
			openTabularResource(true);

		} catch (Exception e) {
			Log.debug("Put In Background :" + e.getLocalizedMessage());
		}
	}

	// Resume state of user interface
	protected void resumeUIState() {
		try {
			UIStateEvent uiStateEvent;
			switch (uiState) {
			case START:
				eventBus.fireEvent(new UIStateEvent(UIStateType.START));
				break;
			case TABLECURATION:
				uiStateEvent = new UIStateEvent(UIStateType.TABLECURATION);
				uiStateEvent.setTrId(trId);
				eventBus.fireEvent(uiStateEvent);
				break;
			case TABLEUPDATE:
				uiStateEvent = new UIStateEvent(UIStateType.TABLEUPDATE);
				uiStateEvent.setTrId(trId);
				eventBus.fireEvent(uiStateEvent);
				break;
			case TR_CLOSE:
				eventBus.fireEvent(new UIStateEvent(UIStateType.TR_CLOSE));
				break;
			case TR_OPEN:
				uiStateEvent = new UIStateEvent(UIStateType.TR_OPEN);
				uiStateEvent.setTrId(trId);
				eventBus.fireEvent(uiStateEvent);
				break;
			case TR_READONLY:
				uiStateEvent = new UIStateEvent(UIStateType.TR_READONLY);
				uiStateEvent.setTrId(trId);
				eventBus.fireEvent(uiStateEvent);
				break;
			case WIZARD_OPEN:
				break;
			default:
				break;

			}

		} catch (Exception e) {
			Log.debug("Resume :" + e.getLocalizedMessage());
		}
	}

	// Open Table
	protected void openTable(TRId tabularResourceId) {
		Log.debug("openTable: " + tabularResourceId);
		trId = tabularResourceId;
		tableOpening = new TableId(Constants.TDX_DATASOURCE_FACTORY_ID,
				trId.getTableId());
		tabularData.openTable(tableOpening);
		uiState = UIStateType.TR_OPEN;
		UIStateEvent uiStateEvent = new UIStateEvent(UIStateType.TR_OPEN);
		uiStateEvent.setTrId(tabularResourceId);
		eventBus.fireEvent(uiStateEvent);
	}

	// Update Table
	protected void updateTable(TRId tabularResourceId) {
		Log.debug("updateTable: " + tabularResourceId);
		trId = tabularResourceId;
		tableOpening = new TableId(Constants.TDX_DATASOURCE_FACTORY_ID,
				trId.getTableId());
		tabularData.openTable(tableOpening);
		uiState = UIStateType.TABLEUPDATE;
		UIStateEvent uiStateEvent = new UIStateEvent(UIStateType.TABLEUPDATE);
		uiStateEvent.setTrId(tabularResourceId);
		eventBus.fireEvent(uiStateEvent);
	}

	// Update Table For Curation
	protected void updateTableForCuration(TRId tabularResourceId) {
		Log.debug("updateTableForCuration: " + tabularResourceId);
		trId = tabularResourceId;
		tableOpening = new TableId(Constants.TDX_DATASOURCE_FACTORY_ID,
				trId.getTableId());
		tabularData.openTable(tableOpening);
		uiState = UIStateType.TABLECURATION;
		UIStateEvent uiStateEvent = new UIStateEvent(UIStateType.TABLECURATION);
		uiStateEvent.setTrId(tabularResourceId);
		eventBus.fireEvent(uiStateEvent);
	}

	// Close Tabular Resource
	protected void closeTabularResource() {
		switch (uiState) {
		case START:
			break;
		case TABLECURATION:
		case TABLEUPDATE:
		case TR_OPEN:
		case TR_READONLY:
		case WIZARD_OPEN:
			Log.debug("CloseTabularResource");
			tabularData.closeTable();
			trId = null;
			tableOpening = null;
			uiState = UIStateType.TR_CLOSE;
			Log.debug("fireEvent TR_CLOSE");
			try {
				eventBus.fireEvent(new UIStateEvent(UIStateType.TR_CLOSE));
			} catch (Exception e) {
				Log.debug("Bus Error: " + e.getMessage());
			}
			closeTabularResourceOnServer();
			break;
		case TR_CLOSE:
			break;
		default:
			break;

		}

	}

	protected void closeTabularResourceOnServer() {
		TDGWTServiceAsync.INSTANCE
				.closeTabularResource(new AsyncCallback<Void>() {

					public void onFailure(Throwable caught) {
						UtilsGXT3.alert("Error closing tabular resource",
								caught.getLocalizedMessage());
					}

					public void onSuccess(Void result) {
						
					}

				});

	}

	protected void deleteTabularResource() {

		final ConfirmMessageBox mb = new ConfirmMessageBox("Confirm",
				"Are you sure you want to delete the taular resource?");
		mb.addHideHandler(new HideHandler() {
			public void onHide(HideEvent event) {
				if (mb.getHideButton() == mb.getButtonById(PredefinedButton.YES
						.name())) {
					Log.debug("Remove TR:" + trId);
					TDGWTServiceAsync.INSTANCE.removeTabularResource(trId,
							new AsyncCallback<Void>() {

								public void onFailure(Throwable caught) {
									UtilsGXT3.alert("Error on Delete",
											caught.getLocalizedMessage());
								}

								public void onSuccess(Void result) {
									closeTabularResource();
								}

							});

					mb.hide();
				} else if (mb.getHideButton() == mb
						.getButtonById(PredefinedButton.NO.name())) {
					mb.hide();
				}
			}
		});
		mb.setWidth(300);
		mb.show();

	}

	protected void openWizard() {
		eventBus.fireEvent(new UIStateEvent(UIStateType.WIZARD_OPEN));
	}

	public void doRibbonCommand(RibbonEvent event) {
		RibbonType type = event.getRibbonType();
		Log.trace("doRibbonEvent ribbonType: " + type);
		try {
			switch (type) {
			case OPEN:
				openTabularResource(false);
				break;
			case CLONE:
				cloneTabularResource();
				break;
			case CLOSE:
				closeTabularResource();
				break;
			case DELETE:
				deleteTabularResource();
				break;
			case PROPERTIES:
				break;
			case IMPORTSDMX:
				openSDMXImportWizard();
				break;
			case IMPORTCSV:
				openCSVImportWizard();
				break;
			case IMPORTJSON:
				break;
			case EXPORTSDMX:
				openSDMXExportWizard();
				break;
			case EXPORTCSV:
				openCSVExportWizard();
				break;
			case EXPORTJSON:
				openJSONExportWizard();
				break;
			case TEMPLATEOPEN:
				openTemplateOpen();
				break;
			case TEMPLATENEW:
				openTemplateNew();
				break;
			case TEMPLATEDELETE:
				openTemplateDelete();
				break;
			case SHARE:
				openShareWindow();
				break;
			case TIMELINE:
				openTasksManagerWizard();
				break;
			case BACKGROUNDTASKS:
				openBackgroundMonitor();
				break;
			case HISTORY:
				break;
			case UNDO:
				callDiscard();
				break;
			case DISCARDALL:
				break;
			case HELP:
				break;
			case LOGS:
				openLogsWindow();
				break;
			case RULENEW:
				break;
			case RULEMANAGE:
				break;
			case DUPLICATEDETECTION:
				openDuplicatesRows();
				break;
			case TEMPLATEAPPLY:
				openTemplateApply();
				break;
			case TABLETYPE:
				openTableType();
				break;
			case COLUMNLABEL:
				openColumnLabel();
				break;
			case COLUMNTYPE:
				openColumnType();
				break;
			case COLUMNADD:
				openColumnAdd();
				break;
			case COLUMNDELETE:
				openColumnDelete();
				break;
			case COLUMNSPLIT:
				openColumnSplit();
				break;
			case COLUMNMERGE:
				openColumnMerge();
				break;
			case DENORMALIZE:
				openDenormalize();
				break;
			case NORMALIZE:
				openNormalize();
				break;
			case EXTRACTCODELIST:
				openExtractCodelistWizard();
				break;
			case CODELISTMAPPING:
				openCodelistMappingWizard();
				break;
			case GENERATESUMMARY:
				break;
			case TABLEFILTER:
				break;
			case TABLEUNION:
				openTableUnionWizard();
				break;
			case TABLEGROUPBY:
				openGroupBy();
				break;
			case TABLEAGGREAGETE:
				break;
			case ROWADD:
				doRowAdd();
				break;
			case ROWDELETE:
				doRowsDelete();
				break;
			case DUPLICATEDELETE:
				openDuplicatesRows();
				break;
			case ANNOTATIONADD:
				break;
			case COLUMNFILTER:
				openMultiColumnFilter();
				break;
			case COLUMNBATCHREPLACE:
				break;
			case ANALYSETABLEFILTER:
				break;
			case ANALYSETABLEUNION:
				break;
			case ANALYSETABLEGROUPBY:
				break;
			case ANALYSETABLEAGGREAGETE:
				break;
			case ANALYSEROWADD:
				break;
			case ANALYSEROWDELETE:
				break;
			case ANALYSEDUPLICATEDELETE:
				break;
			case ANALYSEANNOTATIONADD:
				break;
			case ANALYSECOLUMNFILTER:
				break;
			case ANALYSECOLUMNEDIT:
				break;
			case CHARTPIE:
				break;
			case CHARTBAR:
				break;
			case CHARTCURVE:
				break;
			case CHARTBULLS:
				break;
			case RSTUDIO:
				break;
			case STATISTICAL:
				break;
			case SPREAD:
				break;
			case GIS:
				break;
			default:
				break;
			}
		} catch (Throwable e) {
			Log.error("doRibbonCommand Error : " + e.getLocalizedMessage());
			e.printStackTrace();
		}
	}

	protected void doTasksMonitorCommand(TasksMonitorEvent event) {
		TaskType taskType = event.getTaskType();
		Log.debug("Received TaskMonitorEvent: " + taskType);
		switch (taskType) {
		case OPENTABLE:
			// openTable(event.getTrId());
			break;
		default:
			break;
		}
	}

	// TODO
	protected void doWidgetRequestCommand(WidgetRequestEvent event) {
		WidgetRequestType widgetRequestType = event.getWidgetRequestType();
		switch (widgetRequestType) {
		case CHANGECOLUMNTYPEPANEL:
			break;
		case CHANGETABLETYPEPANEL:
			break;
		case CURATIONBYREPLACEBATCHDIALOG:
			openBatchReplace(event.getTrId(), event.getRequestProperties());
			break;
		case DELETECOLUMNPANEL:
			break;
		case DUPLICATESROWSPANEL:
			break;
		case LABELCOLUNPANEL:
			break;
		case VALIDATIONSTASKSPANEL:
			break;
		default:
			break;

		}

	}

	// TODO
	public void doBackgroundRequestCommand(BackgroundRequestEvent event) {
		BackgroundRequestType type = event.getBackgroundRequestType();
		Log.trace("doBackgroundRequestEvent BackgroundRequestType: " + type);
		try {
			switch (type) {
			case BACKGROUND:
				putInBackgroundUIState();
				break;
			default:
				break;
			}
		} catch (Throwable e) {
			Log.error("doBackgroundRequestCommand Error : "
					+ e.getLocalizedMessage());
			e.printStackTrace();
		}
	}

	protected void openLogsWindow() {
		Log.debug("Request Open Logs Window");
		TDMLogs tdmLogs = new TDMLogs(eventBus);
		tdmLogs.show();
	}

	protected void openBatchReplace(TRId trId,
			RequestProperties requestProperties) {
		Log.debug("Request Open Batch Replace Dialog: " + trId + " "
				+ requestProperties);
		if (trId != null) {
			ReplaceBatchDialog dialog = new ReplaceBatchDialog(trId,
					requestProperties, eventBus);
			dialog.show();
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No tabular resource present");
		}
	}

	protected void openSDMXImportWizard() {
		GWT.runAsync(new RunAsyncCallback() {

			public void onSuccess() {
				openWizard();
				SDMXImportWizardTD importWizard = new SDMXImportWizardTD(
						"SDMX Import", eventBus);
				importWizard.addListener(new WizardListener() {

					@Override
					public void completed(TRId tabularResourceId) {
						openTable(tabularResourceId);
					}

					@Override
					public void putInBackground() {
						Log.debug("PutInBakground");
					}

					@Override
					public void aborted() {
						resumeUIState();
					}

					@Override
					public void failed(String title, String message,
							Throwable throwable) {
						UtilsGXT3.alert(title, message);
						resumeUIState();
					}

				});

				importWizard.show();
			}

			public void onFailure(Throwable reason) {
				asyncCodeLoadingFailed(reason);
			}
		});

	}

	protected void openCSVExportWizard() {
		GWT.runAsync(new RunAsyncCallback() {

			public void onSuccess() {
				openWizard();
				CSVExportWizardTD exportWizard = new CSVExportWizardTD(
						"CSV Export", eventBus);

				exportWizard.addListener(new WizardListener() {

					@Override
					public void completed(TRId id) {
						resumeUIState();

					}

					@Override
					public void putInBackground() {
						Log.debug("PutInBakground");
					}

					@Override
					public void aborted() {
						resumeUIState();
					}

					@Override
					public void failed(String title, String message,
							Throwable throwable) {
						UtilsGXT3.alert(title, message);
						resumeUIState();
					}

				});

				exportWizard.show();
			}

			public void onFailure(Throwable reason) {
				asyncCodeLoadingFailed(reason);
			}
		});

	}

	protected void openJSONExportWizard() {
		GWT.runAsync(new RunAsyncCallback() {

			public void onSuccess() {
				openWizard();
				JSONExportWidgetTD exportWizard = new JSONExportWidgetTD(
						"JSON Export", eventBus);

				exportWizard.addListener(new WizardListener() {

					@Override
					public void completed(TRId id) {
						resumeUIState();

					}

					@Override
					public void putInBackground() {
						Log.debug("PutInBakground");
					}

					@Override
					public void aborted() {
						resumeUIState();
					}

					@Override
					public void failed(String title, String message,
							Throwable throwable) {
						UtilsGXT3.alert(title, message);
						resumeUIState();
					}

				});

				exportWizard.show();
			}

			public void onFailure(Throwable reason) {
				asyncCodeLoadingFailed(reason);
			}
		});

	}

	protected void openSDMXExportWizard() {
		GWT.runAsync(new RunAsyncCallback() {

			public void onSuccess() {
				openWizard();
				SDMXExportWizardTD exportWizard = new SDMXExportWizardTD(
						"SDMX Export", eventBus);

				exportWizard.addListener(new WizardListener() {
					public void failed(String title, String message,
							Throwable throwable) {
						UtilsGXT3.alert(title, message);
						resumeUIState();
					}

					public void completed(TRId id) {
						resumeUIState();

					}

					@Override
					public void putInBackground() {
						Log.debug("PutInBakground");
					}

					public void aborted() {
						resumeUIState();
					}
				});

				exportWizard.show();
			}

			public void onFailure(Throwable reason) {
				asyncCodeLoadingFailed(reason);
			}
		});

	}

	protected void openExtractCodelistWizard() {
		GWT.runAsync(new RunAsyncCallback() {

			public void onSuccess() {
				openWizard();
				ExtractCodelistWizardTD extractCodelistWizard = new ExtractCodelistWizardTD(
						trId, "Extract Codelist", eventBus);

				extractCodelistWizard.addListener(new WizardListener() {
					public void failed(String title, String message,
							Throwable throwable) {
						UtilsGXT3.alert(title, message);
						resumeUIState();
					}

					public void completed(TRId id) {
						openTable(id);

					}

					@Override
					public void putInBackground() {
						Log.debug("PutInBakground");
					}

					public void aborted() {
						resumeUIState();
					}
				});

				extractCodelistWizard.show();
			}

			public void onFailure(Throwable reason) {
				asyncCodeLoadingFailed(reason);
			}
		});

	}

	protected void openCodelistMappingWizard() {
		GWT.runAsync(new RunAsyncCallback() {

			public void onSuccess() {
				openWizard();
				CodelistMappingImportWizardTD codelistMappingWizard = new CodelistMappingImportWizardTD(
						trId, "Codelist Mapping Import", eventBus);

				codelistMappingWizard.addListener(new WizardListener() {
					public void failed(String title, String message,
							Throwable throwable) {
						UtilsGXT3.alert(title, message);
						resumeUIState();
					}

					public void completed(TRId id) {
						openTable(id);

					}

					@Override
					public void putInBackground() {
						Log.debug("PutInBakground");
					}

					public void aborted() {
						resumeUIState();
					}
				});

				codelistMappingWizard.show();
			}

			public void onFailure(Throwable reason) {
				asyncCodeLoadingFailed(reason);
			}
		});

	}

	protected void openTableUnionWizard() {
		GWT.runAsync(new RunAsyncCallback() {

			public void onSuccess() {
				openWizard();
				UnionWizardTD unionWizard = new UnionWizardTD(trId, "Union",
						eventBus);

				unionWizard.addListener(new WizardListener() {
					public void failed(String title, String message,
							Throwable throwable) {
						UtilsGXT3.alert(title, message);
						resumeUIState();
					}

					public void completed(TRId id) {
						openTable(id);

					}

					@Override
					public void putInBackground() {
						Log.debug("PutInBakground");
					}

					public void aborted() {
						resumeUIState();
					}
				});

				unionWizard.show();
			}

			public void onFailure(Throwable reason) {
				asyncCodeLoadingFailed(reason);
			}
		});

	}

	/**
	 * @param switchState
	 * 
	 */
	protected void openTabularResource(final boolean switchState) {
		Log.info("Open Tabular Resources");

		GWT.runAsync(new RunAsyncCallback() {

			public void onSuccess() {
				openWizard();
				String title;
				if (switchState) {
					title = "Switches Tabular Resource";
				} else {
					title = "Open Tabular Resource";
				}
				TDOpen tdOpen = new TDOpen(trId, title, eventBus);
				tdOpen.addListener(new WizardListener() {

					@Override
					public void putInBackground() {
						Log.debug("PutInBakground");
					}

					public void aborted() {
						resumeUIState();
					}

					public void failed(String title, String message,
							Throwable throwable) {
						UtilsGXT3.alert(title, message);
						resumeUIState();
					}

					public void completed(TRId tabularResourceId) {
						openTable(tabularResourceId);

					}

				});
				Log.info("TDOpen add Listener");
				tdOpen.show();
			}

			public void onFailure(Throwable reason) {
				asyncCodeLoadingFailed(reason);
			}
		});

	}

	protected void openCSVImportWizard() {
		GWT.runAsync(new RunAsyncCallback() {

			public void onSuccess() {
				openWizard();
				CSVImportWizardTD importWizard = new CSVImportWizardTD(
						"CSV Import", eventBus);

				importWizard.addListener(new WizardListener() {

					public void failed(String title, String message,
							Throwable throwable) {
						UtilsGXT3.alert(title, message);
						resumeUIState();
					}

					public void completed(TRId id) {
						openTable(id);

					}

					@Override
					public void putInBackground() {
						Log.debug("PutInBakground");
					}

					public void aborted() {
						resumeUIState();
					}
				});

				importWizard.show();
			}

			public void onFailure(Throwable reason) {
				asyncCodeLoadingFailed(reason);
			}
		});

	}

	protected com.extjs.gxt.ui.client.widget.Window tdTaskMainWindow;

	protected void openTasksManagerWizard() {
		initTaskManager();
		tdTaskMainWindow.setPosition((Window.getClientWidth() / 2) - 200,
				(Window.getClientHeight() / 2) - 300);
		tdTaskController.updateTasks(true);
		tdTaskMainWindow.show();
	}

	protected void initTaskManager() {
		if (!taskManagerInit) {
			taskManagerInit = true;
			tdTaskController = TdTaskController.getInstance();
			TdTaskController.bindCommonBus(eventBus);
			tdTaskMainWindow = tdTaskController.getWindowTaskMonitor();
		} else {

		}
	}

	protected void openTemplateNew() {
		TdTemplateController tdTemplateController = new TdTemplateController();
		TdTemplateController.bindCommonBus(eventBus);
		tdTemplateController.getWindowTemplatePanel().show();

	}

	protected void openTemplateDelete() {
		TemplateDeleteDialog tdDialog = new TemplateDeleteDialog(eventBus);
		tdDialog.show();

	}

	protected void openTemplateOpen() {
		Log.debug("Template Open call");
		TemplateOpenDialog tdDialog = new TemplateOpenDialog(eventBus);
		tdDialog.show();

	}

	protected void openShareWindow() {
		Log.debug("Open Share Window");
		@SuppressWarnings("unused")
		TRShare trShare = new TRShare(trId, eventBus);
	}

	protected void callDiscard() {
		HistoryDiscard historyDiscard = new HistoryDiscard(eventBus);
		historyDiscard.discard();
	}

	protected void openTemplateApply() {
		Log.debug("Template Apply call");
		if (trId != null) {
			TemplateApplyDialog taDialog = new TemplateApplyDialog(trId,
					eventBus);
			taDialog.show();
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No current tabular resource present");
		}

	}

	protected void openMultiColumnFilter() {
		Log.debug("Request Open Multi Column Filter Dialog");
		if (trId != null) {
			MultiColumnFilterDialog mcfDialog = new MultiColumnFilterDialog(
					trId, eventBus);
			mcfDialog.show();
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No current tabular resource present");
		}
	}

	protected void openColumnFilter(String columnName) {
		Log.debug("Request Open Column Filter Dialog");
		if (trId != null) {
			ColumnFilterDialog cfDialog = new ColumnFilterDialog(trId,
					columnName, eventBus);
			cfDialog.show();
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No current tabular resource present");
		}
	}

	protected void openReplaceColumnByExpression(String columnName) {
		Log.debug("Request Open Replace Column By Expression Dialog");
		if (trId != null) {
			ReplaceColumnByExpressionDialog rceDialog = new ReplaceColumnByExpressionDialog(
					trId, columnName, eventBus);
			rceDialog.show();
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No current tabular resource present");
		}
	}

	protected void openColumnType() {
		openColumnType(null);
	}

	protected void openColumnType(String columnName) {
		Log.debug("Request Open Change Column Tab");
		if (trId != null) {
			WidgetRequestEvent e = new WidgetRequestEvent(
					WidgetRequestType.CHANGECOLUMNTYPEPANEL);
			e.setTrId(trId);
			e.setColumnName(columnName);
			eventBus.fireEvent(e);
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No current tabular resource present");
		}
	}

	protected void openNormalize() {
		openNormalize(null);
	}

	protected void openNormalize(String columnName) {
		Log.debug("Request Open Normalize Tab");
		if (trId != null) {
			WidgetRequestEvent e = new WidgetRequestEvent(
					WidgetRequestType.NORMALIZEPANEL);
			e.setTrId(trId);
			e.setColumnName(columnName);
			eventBus.fireEvent(e);
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No current tabular resource present");
		}
	}

	protected void openDenormalize() {
		openDenormalize(null);
	}

	protected void openDenormalize(String columnName) {
		Log.debug("Request Open Denormalize Tab");
		if (trId != null) {
			WidgetRequestEvent e = new WidgetRequestEvent(
					WidgetRequestType.DENORMALIZEPANEL);
			e.setTrId(trId);
			e.setColumnName(columnName);
			eventBus.fireEvent(e);
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No current tabular resource present");
		}
	}

	protected void cloneTabularResource() {
		CloneTabularResource cloneTR = new CloneTabularResource(trId, eventBus);
		cloneTR.cloneTR();
	}

	protected void openColumnBatchReplace() {
		openColumnDelete(null);
	}

	protected void openColumnBatchReplace(String columnName) {
		Log.debug("Request Open Batch Replace Dialog");
		if (trId != null) {
			ReplaceBatchDialog dialog = new ReplaceBatchDialog(trId,
					columnName, eventBus);
			dialog.show();
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No tabular resource present");
		}
	};

	protected void openColumnAdd() {
		openColumnAdd(null);
	}

	protected void openColumnAdd(String columnName) {
		Log.debug("Request Add Column Tab");
		if (trId != null) {
			WidgetRequestEvent e = new WidgetRequestEvent(
					WidgetRequestType.ADDCOLUMNPANEL);
			e.setTrId(trId);
			eventBus.fireEvent(e);
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No tabular resource present");
		}
	}

	protected void openColumnDelete() {
		openColumnDelete(null);
	}

	protected void openColumnDelete(String columnName) {
		Log.debug("Request Delete Column Tab");
		if (trId != null) {
			WidgetRequestEvent e = new WidgetRequestEvent(
					WidgetRequestType.DELETECOLUMNPANEL);
			e.setTrId(trId);
			e.setColumnName(columnName);
			eventBus.fireEvent(e);
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No tabular resource present");
		}
	}

	protected void openColumnSplit() {
		openColumnSplit(null);
	}

	protected void openColumnSplit(String columnName) {
		Log.debug("Request Split Column Tab");
		if (trId != null) {
			WidgetRequestEvent e = new WidgetRequestEvent(
					WidgetRequestType.SPLITCOLUMNPANEL);
			e.setTrId(trId);
			e.setColumnName(columnName);
			eventBus.fireEvent(e);
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No tabular resource present");
		}
	}

	protected void openColumnMerge() {
		openColumnMerge(null);
	}

	protected void openColumnMerge(String columnName) {
		Log.debug("Request Merge Column Tab");
		if (trId != null) {
			WidgetRequestEvent e = new WidgetRequestEvent(
					WidgetRequestType.MERGECOLUMNPANEL);
			e.setTrId(trId);
			e.setColumnName(columnName);
			eventBus.fireEvent(e);
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No tabular resource present");
		}
	}

	protected void openGroupBy() {
		openGroupBy(null);
	}

	protected void openGroupBy(String columnName) {
		Log.debug("Request Group By Tab");
		if (trId != null) {
			WidgetRequestEvent e = new WidgetRequestEvent(
					WidgetRequestType.GROUPBYPANEL);
			e.setTrId(trId);
			e.setColumnName(columnName);
			eventBus.fireEvent(e);
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No tabular resource present");
		}
	}

	protected void openColumnLabel() {
		openColumnLabel(null);
	}

	protected void openColumnLabel(String columnName) {
		Log.debug("Request Column Label Tab");
		if (trId != null) {
			WidgetRequestEvent e = new WidgetRequestEvent(
					WidgetRequestType.LABELCOLUNPANEL);
			e.setTrId(trId);
			e.setColumnName(columnName);
			eventBus.fireEvent(e);
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No tabular resource present");
		}
	}

	protected void openTableType() {
		Log.debug("Request Change Table Type Tab");
		if (trId != null) {
			WidgetRequestEvent e = new WidgetRequestEvent(
					WidgetRequestType.CHANGETABLETYPEPANEL);
			e.setTrId(trId);
			eventBus.fireEvent(e);
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No tabular resource present");
		}
	}

	protected void openDuplicatesRows() {
		Log.debug("Request Duplicates Rows Tab");
		if (trId != null) {
			WidgetRequestEvent e = new WidgetRequestEvent(
					WidgetRequestType.DUPLICATESROWSPANEL);
			e.setTrId(trId);
			eventBus.fireEvent(e);
		} else {
			Log.error("TRId is null");
			UtilsGXT3.alert("Error", "No tabular resource present");
		}
	}

	protected void openBackgroundMonitor() {
		Log.debug("Request Open Monitor Background Tab");
		WidgetRequestEvent e = new WidgetRequestEvent(
				WidgetRequestType.MONITORBACKGROUNDPANEL);
		eventBus.fireEvent(e);

	}

	protected void doChangeTableRequestEventCommand(
			ChangeTableRequestEvent event) {
		Log.debug("Change Table Request: " + event);
		switch (event.getWhy()) {
		case TABLECURATION:
			updateTableForCuration(event.getTrId());
			break;
		case TABLEUPDATED:
			updateTable(event.getTrId());
			break;
		default:
			break;

		}

	};

	protected void doRowAdd() {
		onRowAdd();
	}

	protected void doRowsDelete() {
		ArrayList<String> rows = tabularData.getGridPanel().getSelectedRowsId();
		onRowsDelete(rows);
	}

	/**
	 * Delete Rows
	 * 
	 * @param rows
	 */
	private void onRowsDelete(ArrayList<String> rows) {
		if (rows == null || rows.size() == 0) {
			UtilsGXT3.alert("No rows selected", "No rows selected");
		} else {
			DeleteRows deleteRows = new DeleteRows(trId, rows, eventBus);
			deleteRows.delete();
		}
	}

	/**
	 * Replace Row
	 * 
	 * @param cellData
	 */
	private void onReplace(CellData cellData) {
		if (cellData == null) {
			UtilsGXT3.alert("No cell selected", "No cell selected");
		} else {
			ReplaceDialog replaceDialog = new ReplaceDialog(cellData, trId,
					eventBus);
			replaceDialog.show();
		}
	}

	/**
	 * Edit Row
	 * 
	 * @param rowRaw
	 */
	private void onRowEdit(RowRaw rowRaw) {
		if (rowRaw == null) {
			UtilsGXT3.alert("No rows selected", "No rows selected");
		} else {
			EditRowDialog editRowDialog = new EditRowDialog(trId, rowRaw,
					eventBus);
			editRowDialog.show();
		}
	}

	/**
	 * Add Row
	 */
	private void onRowAdd() {
		EditRowDialog editRowDialog = new EditRowDialog(trId, eventBus);
		editRowDialog.show();

	}

	protected void doGridContextMenuCommand(GridContextMenuItemEvent event) {
		Log.debug("GridContextMenu Fire Event",
				"OperationId: " + event.getGridOperationId());
		GridOperationId gridOperationId = event.getGridOperationId();
		ArrayList<String> rows = event.getRows();
		RowRaw rowRaw = event.getRowRaw();
		CellData cellData = event.getCellData();

		switch (gridOperationId) {
		case ROWADD:
			onRowAdd();
			break;
		case ROWEDIT:
			onRowEdit(rowRaw);
			break;
		case ROWDELETE:
			onRowsDelete(rows);
			break;
		case REPLACE:
			onReplace(cellData);
		default:
			break;
		}

	}

	protected void doSessionExpiredCommand(SessionExpiredEvent event) {
		Log.debug("Session Expired Event: " + event.getSessionExpiredType());
		sessionExpiredShow();

	}

	protected void doGridHeaderColumnMenuCommand(
			GridHeaderColumnMenuItemEvent event) {
		Log.debug("GridHeaderColumnMenu Fire Event",
				"OperationId: " + event.getOperationId() + " Column: \n"
						+ event.getColumnSelected());
		String opId = event.getOperationId();
		String columnName = tabularData.getColumnId(event.getColumnSelected());
		Log.debug("GridColumnName: " + columnName);

		if (opId.compareTo(GridHeaderOperationId.COLUMNLABEL.toString()) == 0) {
			openColumnLabel(columnName);
		} else {
			if (opId.compareTo(GridHeaderOperationId.COLUMNADD.toString()) == 0) {
				openColumnAdd(columnName);
			} else {
				if (opId.compareTo(GridHeaderOperationId.COLUMNBATCHREPLACE
						.toString()) == 0) {
					openColumnBatchReplace(columnName);
				} else {
					if (opId.compareTo(GridHeaderOperationId.COLUMNDELETE
							.toString()) == 0) {
						openColumnDelete(columnName);
					} else {
						if (opId.compareTo(GridHeaderOperationId.COLUMNTYPE
								.toString()) == 0) {
							openColumnType(columnName);
						} else {
							if (opId.compareTo(GridHeaderOperationId.COLUMNFILTER
									.toString()) == 0) {
								openColumnFilter(columnName);
							} else {
								if (opId.compareTo(GridHeaderOperationId.ANNOTATIONADD
										.toString()) == 0) {

								} else {
									if (opId.compareTo(GridHeaderOperationId.DUPLICATEDETECTION
											.toString()) == 0) {

									} else {
										if (opId.compareTo(GridHeaderOperationId.COLUMNSPLIT
												.toString()) == 0) {
											openColumnSplit(columnName);
										} else {
											if (opId.compareTo(GridHeaderOperationId.COLUMNMERGE
													.toString()) == 0) {
												openColumnMerge(columnName);
											} else {
												if (opId.compareTo(GridHeaderOperationId.COLUMNREPLACEBYEXPRESSION
														.toString()) == 0) {
													// TODO
													openReplaceColumnByExpression(columnName);
												} else {

												}
											}
										}
									}

								}

							}

						}

					}
				}

			}

		}

	}

	protected void asyncCodeLoadingFailed(Throwable reason) {
		Log.error("Async code loading failed", reason);
		eventBus.fireEvent(new SessionExpiredEvent(
				SessionExpiredType.EXPIREDONSERVER));

	}

}
