package org.gcube.portlets.user.td.client.grid;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.td.client.resource.TabularDataResources;
import org.gcube.portlets.user.td.widgetcommonevent.shared.GridHeaderOperationId;

import com.sencha.gxt.widget.core.client.menu.MenuItem;

/**
 * Defines the menu for column on the grid
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class GridHeaderColumnMenu {

	protected final ArrayList<MenuItem> menuItems;

	public GridHeaderColumnMenu() {
		menuItems = new ArrayList<MenuItem>();
		
		
		MenuItem changeLabelItem = new MenuItem("Labels");
		changeLabelItem.setId(GridHeaderOperationId.COLUMNLABEL
				.toString());
		changeLabelItem.setIcon(TabularDataResources.INSTANCE.columnLabel());
		menuItems.add(changeLabelItem);
		
	
		MenuItem addColumnItem = new MenuItem("Add Column");
		addColumnItem.setId(GridHeaderOperationId.COLUMNADD.toString());
		addColumnItem.setIcon(TabularDataResources.INSTANCE.columnAdd());	
		menuItems.add(addColumnItem);

		
		MenuItem deleteColumnItem = new MenuItem("Delete Column");
		deleteColumnItem.setId(GridHeaderOperationId.COLUMNDELETE.toString());
		deleteColumnItem.setIcon(TabularDataResources.INSTANCE.columnDelete());	
		menuItems.add(deleteColumnItem);
		
		MenuItem splitColumnItem = new MenuItem("Split Column");
		splitColumnItem.setId(GridHeaderOperationId.COLUMNSPLIT.toString());
		splitColumnItem.setIcon(TabularDataResources.INSTANCE.columnSplit());	
		menuItems.add(splitColumnItem);
	
		
		MenuItem mergeColumnItem = new MenuItem("Merge Column");
		mergeColumnItem.setId(GridHeaderOperationId.COLUMNMERGE.toString());
		mergeColumnItem.setIcon(TabularDataResources.INSTANCE.columnMerge());	
		menuItems.add(mergeColumnItem);
		
		
		
		MenuItem changeToTypeItem = new MenuItem("Change Type");
		changeToTypeItem.setId(GridHeaderOperationId.COLUMNTYPE.toString());
		changeToTypeItem.setIcon(TabularDataResources.INSTANCE.columnType());	
		menuItems.add(changeToTypeItem);

		MenuItem filterItem = new MenuItem("Filter");
		filterItem.setId(GridHeaderOperationId.COLUMNFILTER.toString());
		filterItem.setIcon(TabularDataResources.INSTANCE.columnFilter());	
		menuItems.add(filterItem);
		
	
		MenuItem replaceValueBatchItem = new MenuItem("Replace Batch");
		replaceValueBatchItem.setId(GridHeaderOperationId.COLUMNBATCHREPLACE.toString());
		replaceValueBatchItem.setIcon(TabularDataResources.INSTANCE.columnReplaceBatch());	
		menuItems.add(replaceValueBatchItem);
		

		MenuItem replaceValueOnConditionItem = new MenuItem("Replace By Expression");
		replaceValueOnConditionItem.setId(GridHeaderOperationId.COLUMNREPLACEBYEXPRESSION.toString());
		replaceValueOnConditionItem.setIcon(TabularDataResources.INSTANCE.columnReplaceByExpression());	
		menuItems.add(replaceValueOnConditionItem);
		
		
		/*MenuItem newAnnotationColumnItem = new MenuItem("Annotation");
		newAnnotationColumnItem.setId(GridHeaderOperationId.ANNOTATIONADD.toString());
		newAnnotationColumnItem.setIcon(TabularDataResources.INSTANCE.annotationAdd());	
		menuItems.add(newAnnotationColumnItem);*/
		
		/*MenuItem columnDuplicateValidationItem = new MenuItem("Duplicate Detection");
		columnDuplicateValidationItem.setId(GridHeaderOperationId.DUPLICATEDETECTION.toString());
		columnDuplicateValidationItem.setIcon(TabularDataResources.INSTANCE.tableDuplicateRows());	
		menuItems.add(columnDuplicateValidationItem);*/
		
	}

	/**
	 * 
	 * @return the list of menu items to be added
	 */
	public List<MenuItem> getMenu() {
		return menuItems;
	}
}
