/**
 * 
 */
package org.gcube.portlets.user.td.client.ribbon;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.TabPanel;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class TabularDataRibbon {

	protected TabPanel ribbon;
	
	//protected PlainTabPanel ribbon;
	    
	protected FileToolBar fileToolBar;
	protected CurationToolBar curationToolBar;
	protected ModifyToolBar modifyToolBar;
	protected AnalyseToolBar analyseToolBar;

	public TabularDataRibbon(EventBus eventBus) {
		try {
			ribbon = new TabPanel();
			ribbon.setId("Ribbon");
			ribbon.setHeight("102px");
			
			VerticalLayoutData vldata=new VerticalLayoutData(1, -1);
			
			fileToolBar = new FileToolBar(eventBus);
			VerticalLayoutContainer con = new VerticalLayoutContainer();
			con.add(fileToolBar.getToolBar(), vldata);
			ribbon.add(con, "Home");
			
			curationToolBar = new CurationToolBar(eventBus);
			con = new VerticalLayoutContainer();
			
			con.add(curationToolBar.getToolBar(), vldata);
			ribbon.add(con, "Curation");

			modifyToolBar = new ModifyToolBar(eventBus);
			con = new VerticalLayoutContainer();
			con.add(modifyToolBar.getToolBar(), vldata);
			ribbon.add(con, "Modify");

			analyseToolBar = new AnalyseToolBar(eventBus);
			con = new VerticalLayoutContainer();
			con.add(analyseToolBar.getToolBar(), vldata);
			ribbon.add(con, "Analyse");
			
		} catch (Exception e) {
			e.printStackTrace();
			Log.error("Ribbon error:" + e.getLocalizedMessage());
		}

	}

	/**
	 * @return the container
	 */
	public TabPanel getContainer() {
		return ribbon;
	}

}
