/**
 * 
 */
package org.gcube.portlets.user.td.client.toolbar;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.ui.FlexTable;
import com.sencha.gxt.core.client.dom.XElement;
import com.sencha.gxt.widget.core.client.button.ButtonGroup;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class AnalysisToolBar {

	protected ToolBar toolBar;
	
	public AnalysisToolBar()
	{
		toolBar = new ToolBar();
		build();
	}
	
	public ToolBar getToolBar()
	{
		return toolBar;
	}

	protected void build()
	{
		ButtonGroup group = new ButtonGroup();
		group.setHeadingText("Chart");
		toolBar.add(group);

		FlexTable table = new FlexTable();
		group.add(table);
/*
		TextButton btn = new TextButton("Bar", TabularDataResources.INSTANCE.chartBar());
		table.setWidget(0, 0, btn);

		btn = new TextButton("Curve", TabularDataResources.INSTANCE.chartCurve());
		table.setWidget(1, 0, btn);

		btn = new TextButton("Pie", TabularDataResources.INSTANCE.chartPie());
		table.setWidget(0, 2, btn);
		
		btn = new TextButton("Bulls", TabularDataResources.INSTANCE.chartBullsEye());
		table.setWidget(1, 2, btn);

		cleanCells(table.getElement());
		
		
		group = new ButtonGroup();
		group.setHeadingText("External Tool");
		toolBar.add(group);

		table = new FlexTable();
		group.add(table);

		btn = new TextButton("R Studio", TabularDataResources.INSTANCE.rstudio());
		table.setWidget(0, 0, btn);

		btn = new TextButton("Statistical", TabularDataResources.INSTANCE.sm());
		table.setWidget(1, 0, btn);

		/*btn = new TextButton("Pie", TabularDataResources.INSTANCE.chartPie());
		table.setWidget(0, 2, btn);
		
		btn = new TextButton("Bulls", TabularDataResources.INSTANCE.chartBullsEye());
		table.setWidget(1, 2, btn);*/

		cleanCells(table.getElement());
	}

	protected void cleanCells(Element elem) {
		NodeList<Element> tds = elem.<XElement> cast().select("td");
		for (int i = 0; i < tds.getLength(); i++) {
			Element td = tds.getItem(i);

			if (!td.hasChildNodes() && td.getClassName().equals("")) {
				td.removeFromParent();
			}
		}
	}

}
