/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.client.template;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.core.client.IdentityValueProvider;
import com.sencha.gxt.core.client.Style;
import com.sencha.gxt.core.client.resources.ThemeStyles;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.Store;
import com.sencha.gxt.data.shared.loader.DataProxy;
import com.sencha.gxt.data.shared.loader.ListLoadConfig;
import com.sencha.gxt.data.shared.loader.ListLoadResult;
import com.sencha.gxt.data.shared.loader.ListLoader;
import com.sencha.gxt.data.shared.loader.LoadHandler;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.grid.CheckBoxSelectionModel;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.GridSelectionModel;
import com.sencha.gxt.widget.core.client.toolbar.LabelToolItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.ArrayList;
import org.gcube.portlets.user.td.client.resource.TabularDataResources;
import org.gcube.portlets.user.td.client.template.TemplateApplyDialog;
import org.gcube.portlets.user.td.client.template.TemplateApplyPanel;
import org.gcube.portlets.user.td.client.template.TemplateDataProperties;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateApplySession;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateData;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

public class TemplateApplyPanel
extends FramedPanel {
    protected String WIDTH = "630px";
    protected String HEIGHT = "520px";
    protected EventBus eventBus;
    protected TemplateApplyDialog parent;
    protected TRId trId;
    protected TemplateApplySession templateApplySession;
    private TextButton btnApply;
    private TextButton btnClose;
    protected ListLoader<ListLoadConfig, ListLoadResult<TemplateData>> loader;
    protected Grid<TemplateData> grid;
    protected ExtendedListStore<TemplateData> store;

    public TemplateApplyPanel(TemplateApplyDialog parent, TRId trId, EventBus eventBus) {
        this.parent = parent;
        this.trId = trId;
        Log.debug((String)"TemplateApplyPanel");
        this.setWidth(this.WIDTH);
        this.setHeight(this.HEIGHT);
        this.setHeaderVisible(false);
        this.setBodyBorder(false);
        this.eventBus = eventBus;
        this.create();
    }

    protected void create() {
        ToolBar toolBarHead = new ToolBar();
        toolBarHead.add((Widget)new LabelToolItem("Search: "));
        TextField searchField = new TextField();
        toolBarHead.add((Widget)searchField);
        TextButton btnReload = new TextButton();
        btnReload.setIcon(TabularDataResources.INSTANCE.refresh());
        btnReload.setToolTip("Reload");
        toolBarHead.add((Widget)btnReload);
        IdentityValueProvider identity = new IdentityValueProvider();
        CheckBoxSelectionModel sm = new CheckBoxSelectionModel(identity);
        TemplateDataProperties props = (TemplateDataProperties)GWT.create(TemplateDataProperties.class);
        ColumnConfig nameCol = new ColumnConfig(props.name(), 120, "Name");
        ColumnConfig categoryCol = new ColumnConfig(props.category(), 60, "Category");
        ColumnConfig ownerCol = new ColumnConfig(props.ownerLogin(), 70, "Owner");
        ColumnConfig agencyCol = new ColumnConfig(props.agency(), 100, "Agency");
        ColumnConfig descriptionCol = new ColumnConfig(props.description(), 120, "Description");
        ArrayList<ColumnConfig> l = new ArrayList<ColumnConfig>();
        l.add(nameCol);
        l.add(categoryCol);
        l.add(ownerCol);
        l.add(agencyCol);
        l.add(descriptionCol);
        ColumnModel cm = new ColumnModel(l);
        this.store = new ExtendedListStore(this, props.id());
        searchField.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.store.addFilter((Store.StoreFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.store.setEnableFilters(true);
        3 proxy = new /* Unavailable Anonymous Inner Class!! */;
        this.loader = new ListLoader((DataProxy)proxy);
        this.loader.setRemoteSort(false);
        this.loader.addLoadHandler((LoadHandler)new /* Unavailable Anonymous Inner Class!! */);
        5 sh = new /* Unavailable Anonymous Inner Class!! */;
        btnReload.addSelectHandler((SelectEvent.SelectHandler)sh);
        this.grid = new /* Unavailable Anonymous Inner Class!! */;
        sm.setSelectionMode(Style.SelectionMode.SINGLE);
        this.grid.setLoader(this.loader);
        this.grid.setSelectionModel((GridSelectionModel)sm);
        this.grid.setHeight("384px");
        this.grid.getView().setStripeRows(true);
        this.grid.getView().setColumnLines(true);
        this.grid.getView().setAutoFill(true);
        this.grid.setBorders(false);
        this.grid.setLoadMask(true);
        this.grid.setColumnReordering(true);
        this.grid.setColumnResize(true);
        this.grid.getView().setAutoExpandColumn(descriptionCol);
        ToolBar toolBar = new ToolBar();
        toolBar.add((Widget)this.grid);
        toolBar.addStyleName(ThemeStyles.getStyle().borderTop());
        toolBar.getElement().getStyle().setProperty("borderBottom", "none");
        this.btnApply = new TextButton("Apply");
        this.btnApply.setIcon(TabularDataResources.INSTANCE.templateApply());
        this.btnApply.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.btnApply.setTitle("Apply Template");
        this.btnApply.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.btnClose = new TextButton("Close");
        this.btnClose.setIcon(TabularDataResources.INSTANCE.close());
        this.btnClose.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.btnClose.setTitle("Cancel filter");
        this.btnClose.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
        flowButton.setHBoxLayoutAlign(HBoxLayoutContainer.HBoxLayoutAlign.MIDDLE);
        flowButton.setPack(BoxLayoutContainer.BoxLayoutPack.CENTER);
        flowButton.add((IsWidget)this.btnApply, new BoxLayoutContainer.BoxLayoutData(new Margins(2, 4, 2, 4)));
        flowButton.add((IsWidget)this.btnClose, new BoxLayoutContainer.BoxLayoutData(new Margins(2, 4, 2, 4)));
        VerticalLayoutContainer v = new VerticalLayoutContainer();
        v.add((IsWidget)toolBarHead, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        v.add((IsWidget)this.grid, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        v.add((IsWidget)toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, 25.0, new Margins(0)));
        v.add((IsWidget)flowButton, new VerticalLayoutContainer.VerticalLayoutData(-1.0, 36.0, new Margins(5, 2, 5, 2)));
        this.add((Widget)v);
    }

    protected void loadData(ListLoadConfig loadConfig, AsyncCallback<ListLoadResult<TemplateData>> callback) {
        TDGWTServiceAsync.INSTANCE.getTemplates((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected TemplateData getSelectedItem() {
        return (TemplateData)this.grid.getSelectionModel().getSelectedItem();
    }

    protected void apply() {
        this.templateApplySession = new TemplateApplySession();
        TemplateData template = this.getSelectedItem();
        if (template == null) {
            UtilsGXT3.info((String)"Attention", (String)"Select the template to apply");
        } else {
            this.templateApplySession.setTemplateData(this.getSelectedItem());
            this.templateApplySession.setTrId(this.trId);
            Log.debug((String)("applyTemplateSession: " + this.templateApplySession));
            this.parent.applyTemplate(this.templateApplySession);
        }
    }

    protected void close() {
        this.parent.close();
    }

    public void gridReload() {
        this.grid.getLoader().load();
    }

    protected boolean select(TemplateData item, String searchTerm) {
        if (item.getName() != null && item.getName().toLowerCase().contains(searchTerm.toLowerCase())) {
            return true;
        }
        if (item.getCategory() != null && item.getCategory().toLowerCase().contains(searchTerm.toLowerCase())) {
            return true;
        }
        if (item.getAgency() != null && item.getAgency().toLowerCase().contains(searchTerm.toLowerCase())) {
            return true;
        }
        return item.getDescription() != null && item.getDescription().toLowerCase().contains(searchTerm.toLowerCase());
    }
}

